/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.Filter;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetOperations;
import de.uni_leipzig.simba.mapper.atomic.TotalOrderBlockingMapper;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.MeasureFactory;
import org.apache.log4j.Logger;

public class SimpleSetConstraintsMapper
implements SetConstraintsMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    Cache source;
    Cache target;
    KBInfo sourceInfo;
    KBInfo targetInfo;
    Filter filter;
    int granularity;

    public SimpleSetConstraintsMapper() {
    }

    public SimpleSetConstraintsMapper(KBInfo sInfo, KBInfo tInfo, Cache s, Cache t, Filter f, int _granularity) {
        this.source = s;
        this.target = t;
        this.filter = f;
        this.sourceInfo = sInfo;
        this.targetInfo = tInfo;
        this.granularity = _granularity;
    }

    public Mapping getLinks(String expression, double threshold) {
        Mapping map = new Mapping();
        Parser p = new Parser(expression, threshold);
        if (p.isAtomic()) {
            map = this.getLinksFromAtomic(expression, threshold);
        } else {
            long startTime = System.currentTimeMillis();
            Mapping map1 = this.getLinks(p.term1, p.threshold1);
            startTime = System.currentTimeMillis();
            Mapping map2 = this.getLinks(p.term2, p.threshold2);
            startTime = System.currentTimeMillis();
            map = this.mergeMaps(p.op, map1, map2, p.coef1, p.coef2, expression, threshold);
        }
        return map;
    }

    public Mapping getLinksFromAtomic(String expression, double threshold) {
        Parser p = new Parser(expression, threshold);
        AtomicMapper mapper = MeasureFactory.getMapper(p.op);
        Measure m = MeasureFactory.getMeasure(p.op);
        if (mapper instanceof TotalOrderBlockingMapper) {
            ((TotalOrderBlockingMapper)mapper).granularity = this.granularity;
        }
        return mapper.getMapping(this.source, this.target, this.sourceInfo.var, this.targetInfo.var, expression, threshold);
    }

    public Mapping mergeMaps(String operation, Mapping map1, Mapping map2, double coef1, double coef2, String condition, double threshold) {
        Mapping map = new Mapping();
        if (operation.equalsIgnoreCase("MAX")) {
            logger.info((Object)"Merging with MAX");
            return SetOperations.union(map1, map2);
        }
        if (operation.equalsIgnoreCase("AND")) {
            return this.filter.filter(SetOperations.intersection(map1, map2), threshold);
        }
        if (operation.equalsIgnoreCase("MIN")) {
            logger.info((Object)"Merging with MIN");
            return SetOperations.intersection(map1, map2);
        }
        if (operation.equalsIgnoreCase("OR")) {
            return this.filter.filter(SetOperations.union(map1, map2), threshold);
        }
        if (operation.equalsIgnoreCase("MINUS")) {
            return this.filter.filter(SetOperations.difference(map1, map2), threshold);
        }
        if (operation.equalsIgnoreCase("XOR")) {
            return this.filter.filter(SetOperations.union(SetOperations.difference(map1, map2), SetOperations.difference(map2, map1)), threshold);
        }
        if (operation.equalsIgnoreCase("ADD")) {
            logger.info((Object)("Merging with ADD and filtering with condition " + condition + " and threshold " + threshold));
            return this.filter.filter(map1, map2, coef1, coef2, threshold, "ADD");
        }
        if (operation.equalsIgnoreCase("MULT")) {
            return this.filter.filter(map1, map2, coef1, coef2, threshold, "MULT");
        }
        logger.fatal((Object)("Operation " + operation + " unknown or not yet implemented"));
        return map;
    }
}

