/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper;

import de.uni_leipzig.simba.data.Mapping;

public class SetOperations {
    public static Mapping getMapping(Mapping source, Mapping target, Operator op) {
        if (op.equals((Object)Operator.AND)) {
            return SetOperations.intersection(source, target);
        }
        if (op.equals((Object)Operator.OR)) {
            return SetOperations.union(source, target);
        }
        if (op.equals((Object)Operator.DIFF)) {
            return SetOperations.difference(source, target);
        }
        if (op.equals((Object)Operator.XOR)) {
            return SetOperations.union(SetOperations.difference(source, target), SetOperations.difference(target, source).reverseSourceTarget());
        }
        return new Mapping();
    }

    public static double getRuntimeApproximation(Operator op, int mappingSize1, int mappingSize2) {
        if (op.equals((Object)Operator.AND)) {
            return 1.0;
        }
        if (op.equals((Object)Operator.OR)) {
            return 1.0;
        }
        return 1.0;
    }

    public static double getMappingSizeApproximation(Operator op, int mappingSize1, int mappingSize2) {
        if (op.equals((Object)Operator.AND)) {
            return Math.min(mappingSize1, mappingSize2);
        }
        if (op.equals((Object)Operator.OR)) {
            return Math.max(mappingSize1, mappingSize2);
        }
        if (op.equals((Object)Operator.DIFF) || op.equals((Object)Operator.XOR)) {
            return Math.max(mappingSize1, mappingSize2) - Math.min(mappingSize1, mappingSize2);
        }
        return 0.0;
    }

    public static Mapping difference(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        for (String key : map1.map.keySet()) {
            if (map2.map.containsKey(key)) {
                for (String value : map1.map.get(key).keySet()) {
                    if (map2.map.get(key).containsKey(value)) continue;
                    map.add(key, value, map1.map.get(key).get(value));
                }
                continue;
            }
            map.add(key, map1.map.get(key));
        }
        return map;
    }

    public static Mapping intersection(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        if (map1.size() == 0 || map2.size() == 0) {
            return new Mapping();
        }
        for (String key : map1.map.keySet()) {
            if (!map2.map.containsKey(key)) continue;
            for (String value : map1.map.get(key).keySet()) {
                if (!map2.map.get(key).containsKey(value)) continue;
                if (map1.map.get(key).get(value) <= map2.map.get(key).get(value)) {
                    map.add(key, value, map1.map.get(key).get(value));
                    continue;
                }
                map.add(key, value, map2.map.get(key).get(value));
            }
        }
        return map;
    }

    public static Mapping union(Mapping map1, Mapping map2) {
        Mapping map = new Mapping();
        for (String key : map1.map.keySet()) {
            for (String value : map1.map.get(key).keySet()) {
                map.add(key, value, map1.getSimilarity(key, value));
            }
        }
        for (String key : map2.map.keySet()) {
            for (String value : map2.map.get(key).keySet()) {
                map.add(key, value, map2.getSimilarity(key, value));
            }
        }
        return map;
    }

    public static Mapping xor(Mapping map1, Mapping map2) {
        return SetOperations.union(SetOperations.difference(map1, map2), SetOperations.difference(map2, map1).reverseSourceTarget());
    }

    public static void main(String[] args) {
        Mapping a = new Mapping();
        Mapping b = new Mapping();
        a.add("c", "c", 0.5);
        a.add("a", "z", 0.5);
        a.add("a", "b", 0.5);
        b.add("a", "c", 0.5);
        b.add("a", "b", 0.7);
        b.add("b", "y", 0.7);
        System.out.println(SetOperations.union(a, b));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operator {
        AND,
        OR,
        DIFF,
        XOR;

    }
}

