/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.Filter;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.mapper.SetOperations;
import de.uni_leipzig.simba.mapper.SimpleSetConstraintsMapper;

public class FilterBasedSetConstraintsMapper
extends SimpleSetConstraintsMapper {
    public FilterBasedSetConstraintsMapper(KBInfo sInfo, KBInfo tInfo, Cache s, Cache t, Filter f) {
        this.source = s;
        this.target = t;
        this.filter = f;
        this.sourceInfo = sInfo;
        this.targetInfo = tInfo;
    }

    public Mapping getLinks(String expression, double threshold) {
        Mapping map = new Mapping();
        Parser p = new Parser(expression, threshold);
        if (p.isAtomic()) {
            logger.info((Object)("Expression " + expression + " is atomic."));
            logger.info((Object)("Starting atomic mapper on " + expression + " with threshold " + threshold));
            map = this.getLinksFromAtomic(expression, threshold);
        } else {
            logger.info((Object)("Expression " + expression + " is not atomic"));
            if (p.threshold1 > p.threshold2) {
                logger.info((Object)("Getting links for " + p.term1 + " with threshold " + p.threshold1));
                Mapping map1 = this.getLinks(p.term1, p.threshold1);
                logger.info((Object)("Getting links for " + p.term2 + " with threshold " + p.threshold2 + " via filtering"));
                Mapping map2 = this.getLinks(p.term2, p.threshold2);
                map = this.mergeMaps(p.op, map1, map2, p.coef1, p.coef2, expression, threshold);
            }
        }
        return map;
    }

    public Mapping mergeMaps(String operation, Mapping map1, Mapping map2, double coef1, double coef2, String condition, double threshold) {
        Mapping map = new Mapping();
        if (operation.equalsIgnoreCase("MAX")) {
            logger.info((Object)"Merging with MAX");
            return SetOperations.union(map1, map2);
        }
        if (operation.equalsIgnoreCase("AND")) {
            logger.info((Object)("Merging with AND and filtering with threshold" + threshold));
            return this.filter.filter(SetOperations.union(map1, map2), threshold);
        }
        if (operation.equalsIgnoreCase("MIN")) {
            logger.info((Object)"Merging with MIN");
            return SetOperations.intersection(map1, map2);
        }
        if (operation.equalsIgnoreCase("OR")) {
            logger.info((Object)("Merging with OR and filtering with threshold" + threshold));
            return this.filter.filter(SetOperations.intersection(map1, map2), threshold);
        }
        if (operation.equalsIgnoreCase("MINUS")) {
            logger.info((Object)"Merging with MINUS");
            return this.filter.filter(SetOperations.difference(map1, map2), threshold);
        }
        if (operation.equalsIgnoreCase("XOR")) {
            logger.info((Object)("Merging with XOR and filtering with threshold " + threshold));
            return this.filter.filter(SetOperations.union(SetOperations.difference(map1, map2), SetOperations.difference(map2, map1)), threshold);
        }
        if (operation.equalsIgnoreCase("ADD")) {
            logger.info((Object)("Merging with ADD and filtering with condition " + condition + " and threshold " + threshold));
            return this.filter.filter(map1, map2, coef1, coef2, threshold, "ADD");
        }
        if (operation.equalsIgnoreCase("MULT")) {
            logger.info((Object)("Merging with MULT and filtering with condition " + condition + " and threshold " + threshold));
            return this.filter.filter(map1, map2, coef1, coef2, threshold, "MULT");
        }
        logger.fatal((Object)("Operation " + operation + " unknown or not yet implemented"));
        return map;
    }
}

