/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.stablematching;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.learning.stablematching.Hospital;
import de.uni_leipzig.simba.learning.stablematching.Resident;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HospitalResidents {
    static Logger logger = Logger.getLogger((String)"LIMES");
    HashMap<Integer, String> residentReverseIndex = new HashMap();
    HashMap<String, Integer> hospitalIndex = new HashMap();
    HashMap<String, Integer> residentIndex = new HashMap();
    HashMap<Integer, String> hospitalReverseIndex = new HashMap();

    public Mapping getMatching(Mapping m) {
        double[] preferences;
        int i;
        this.residentReverseIndex = new HashMap();
        this.hospitalIndex = new HashMap();
        this.residentIndex = new HashMap();
        this.hospitalReverseIndex = new HashMap();
        int rCounter = 0;
        int hCounter = 0;
        for (String key : m.map.keySet()) {
            this.residentReverseIndex.put(rCounter, key);
            this.residentIndex.put(key, rCounter);
            ++rCounter;
            for (String value : m.map.get(key).keySet()) {
                if (this.hospitalIndex.containsKey(value)) continue;
                this.hospitalIndex.put(value, hCounter);
                this.hospitalReverseIndex.put(hCounter, value);
                ++hCounter;
            }
        }
        logger.info((Object)(hCounter + " hospitals and " + rCounter + " residents"));
        ArrayList<Resident> residents = new ArrayList<Resident>();
        ArrayList<Hospital> hospitals = new ArrayList<Hospital>();
        for (i = 0; i < rCounter; ++i) {
            int j;
            String r = this.residentReverseIndex.get(i);
            preferences = new double[hCounter];
            for (int j2 = 0; j2 < hCounter; ++j2) {
                preferences[j2] = 0.0;
            }
            for (String h : m.map.get(r).keySet()) {
                int index = this.hospitalIndex.get(h);
                preferences[index] = m.getSimilarity(r, h);
            }
            for (j = 0; j < hCounter; ++j) {
            }
            preferences = this.sort(preferences);
            for (j = 0; j < hCounter; ++j) {
            }
            residents.add(new Resident(i, preferences));
            residents.get((int)i).label = r;
        }
        for (i = 0; i < hCounter; ++i) {
            String h = this.hospitalReverseIndex.get(i);
            preferences = new double[rCounter];
            for (int j = 0; j < rCounter; ++j) {
                preferences[j] = 0.0;
            }
            for (String r : m.map.keySet()) {
                int index = this.residentIndex.get(r);
                preferences[index] = m.getSimilarity(r, h);
            }
            preferences = this.sort(preferences);
            if (rCounter % hCounter == 0) {
                hospitals.add(new Hospital(i, rCounter / hCounter, preferences));
            } else {
                hospitals.add(new Hospital(i, rCounter / hCounter + 1, preferences));
            }
            hospitals.get((int)i).label = h;
        }
        Mapping result = new Mapping();
        ArrayList<ArrayList<Integer>> match = this.getMatching(residents, hospitals);
        for (int i2 = 0; i2 < match.size(); ++i2) {
            for (int j = 0; j < match.get(i2).size(); ++j) {
                String uri1 = this.residentReverseIndex.get(match.get(i2).get(j));
                String uri2 = this.hospitalReverseIndex.get(i2);
                result.add(uri1, uri2, m.getSimilarity(uri1, uri2));
            }
        }
        return result;
    }

    public double[] sort(double[] input) {
        double[] result = new double[input.length];
        for (int k = 0; k < input.length; ++k) {
            double max = -2.0;
            int index = 0;
            for (int jj = 0; jj < input.length; ++jj) {
                if (!(input[jj] > max)) continue;
                max = input[jj];
                index = jj;
            }
            result[input.length - k - 1] = index;
            input[index] = -1.0;
        }
        return result;
    }

    public ArrayList<ArrayList<Integer>> getMatching(ArrayList<Resident> r, ArrayList<Hospital> h) {
        ArrayList<Integer> unmatched = new ArrayList<Integer>();
        for (int i = 0; i < r.size(); ++i) {
            unmatched.add(i);
        }
        while (unmatched.size() > 0) {
            logger.info((Object)("unmatched = " + unmatched));
            int residentID = (Integer)unmatched.get(0);
            unmatched.remove(0);
            int bestHospital = r.get(residentID).getNextChoice();
            int rejected = h.get(bestHospital).grantAdmission(residentID);
            if (rejected < 0) continue;
            System.out.println("Unmatched = " + unmatched + "; Rejected = " + rejected);
            unmatched.add(rejected);
        }
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < h.size(); ++i) {
            result.add(h.get((int)i).acceptedResidents);
        }
        System.out.println("Results = " + result);
        return result;
    }

    public static void main(String[] args) {
        double[] input = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0};
    }
}

