/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.stablematching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Hospital {
    HashMap<Integer, Double> residentToWeight;
    int currentChoice;
    int capacity;
    List<Double> sortedPreferences;
    ArrayList<Integer> acceptedResidents;
    int ID;
    public String label;

    public Hospital(int idValue, int capacityValue, double[] preferences) {
        this.ID = idValue;
        this.residentToWeight = new HashMap();
        this.sortedPreferences = new ArrayList<Double>();
        for (int i = 0; i < preferences.length; ++i) {
            this.residentToWeight.put(i, preferences[i]);
            this.sortedPreferences.add(preferences[i]);
        }
        this.capacity = capacityValue;
        Collections.sort(this.sortedPreferences);
        this.acceptedResidents = new ArrayList();
        System.out.println("Preferences of hospital " + this.ID + " with capacity " + this.capacity + " is " + this.residentToWeight);
    }

    public int grantAdmission(int resident) {
        if (this.acceptedResidents.size() < this.capacity) {
            this.acceptedResidents.add(resident);
            System.out.println("Admission granted by " + this.ID + " to " + resident);
            System.out.println("Accepted residents are now " + this.acceptedResidents.size() + "/" + this.capacity);
            System.out.println(this.ID + "->" + this.acceptedResidents);
            return -1;
        }
        double min = this.residentToWeight.get(resident);
        int index = -1;
        for (int i = 0; i < this.acceptedResidents.size(); ++i) {
            if (!(this.residentToWeight.get(this.acceptedResidents.get(i)) < min)) continue;
            min = this.residentToWeight.get(resident);
            index = i;
        }
        if (index == -1) {
            System.out.println("Rejection of " + resident + " by " + this.ID);
            System.out.println(this.ID + "->" + this.acceptedResidents);
            return resident;
        }
        System.out.println("Admission granted by " + this.ID + " to " + resident);
        int reject = this.acceptedResidents.get(index);
        this.acceptedResidents.set(index, resident);
        System.out.println("Rejection of " + index + " by " + this.ID);
        System.out.println(this.ID + "->" + this.acceptedResidents);
        return reject;
    }
}

