/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.query;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.query.ModelRegistry;
import de.uni_leipzig.simba.query.QueryModuleFactory;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelBasedClassMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    QGramsDistance metric = new QGramsDistance();
    private Model sourceModel;
    private Model targetModel;

    public LabelBasedClassMapper() {
    }

    public LabelBasedClassMapper(Model sourceModel, Model targetModel) {
        this();
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    public Mapping getEntityMapping(String endpoint1, String endpoint2) {
        Set<Node> classes1 = this.getClasses(endpoint1, this.sourceModel);
        Set<Node> classes2 = this.getClasses(endpoint2, this.targetModel);
        Mapping result = new Mapping();
        for (Node a : classes1) {
            for (Node b : classes2) {
                String s = a.getLocalName().toLowerCase();
                String t = b.getLocalName().toLowerCase();
                result.add(a.getURI(), b.getURI(), this.metric.getSimilarity(s, t));
            }
        }
        return result;
    }

    private Set<Node> getClasses(String endpoint, Model model) {
        HashSet<Node> result = new HashSet<Node>();
        try {
            String query = "SELECT DISTINCT ?y WHERE { ?s a ?y }";
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = model == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                result.add(soln.get("y").asNode());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error while processing classes");
        }
        return result;
    }

    public static void main(String[] args) {
        String base = "C:/Users/Lyko/workspace/LIMES/resources/";
        KBInfo sKB = new KBInfo();
        sKB.endpoint = base + "Persons1/person11.nt";
        sKB.graph = null;
        sKB.pageSize = 1000;
        sKB.id = "person11";
        KBInfo tKB = new KBInfo();
        tKB.endpoint = base + "Persons1/person12.nt";
        tKB.graph = null;
        tKB.pageSize = 1000;
        tKB.id = "person12";
        QueryModuleFactory.getQueryModule("nt", sKB);
        QueryModuleFactory.getQueryModule("nt", tKB);
        Model sModel = ModelRegistry.getInstance().getMap().get(sKB.endpoint);
        Model tModel = ModelRegistry.getInstance().getMap().get(tKB.endpoint);
        LabelBasedClassMapper mapper = new LabelBasedClassMapper(sModel, tModel);
        Mapping m = mapper.getEntityMapping(sKB.endpoint, tKB.endpoint);
        System.out.println("Result = " + m);
    }
}

