/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.query.PropertyMapper;
import de.uni_leipzig.simba.learning.stablematching.HospitalResidents;
import de.uni_leipzig.simba.query.ModelRegistry;
import de.uni_leipzig.simba.query.QueryModuleFactory;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class DefaultPropertyMapper
implements PropertyMapper {
    public int LIMIT = 500;
    static Logger logger = Logger.getLogger((String)"LIMES");
    public int MINSIM = 1;
    Model sourceModel;
    Model targetModel;

    public Mapping getPropertyMapping(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        Mapping m = this.getMappingProperties(endpoint1, endpoint2, classExpression1, classExpression2);
        HospitalResidents hr = new HospitalResidents();
        m = hr.getMatching(m);
        Mapping copy = new Mapping();
        for (String s : m.map.keySet()) {
            for (String t : m.map.get(s).keySet()) {
                if (!(m.getSimilarity(s, t) >= (double)this.MINSIM)) continue;
                copy.add(s, t, m.getSimilarity(s, t));
            }
        }
        return copy;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    public Mapping getMappingProperties(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        logger.info((Object)("Getting mapping from " + classExpression1 + " to " + classExpression2));
        Mapping m2 = this.getMonoDirectionalMap(endpoint1, endpoint2, classExpression1, classExpression2);
        logger.info((Object)("m2=" + m2.size()));
        logger.info((Object)("Getting mapping from " + classExpression2 + " to " + classExpression1));
        Mapping m1 = this.getMonoDirectionalMap(endpoint2, endpoint1, classExpression2, classExpression1);
        logger.info((Object)("m1=" + m1.size()));
        logger.info((Object)"Merging the mappings...");
        for (String key : m1.map.keySet()) {
            for (String value : m1.map.get(key).keySet()) {
                double sim2 = m2.getSimilarity(value, key);
                double sim1 = m1.getSimilarity(key, value);
                m2.add(value, key, sim1 + sim2);
            }
        }
        logger.info((Object)("Property mapping is \n" + m2));
        return m2;
    }

    public Mapping getMonoDirectionalMap(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        String p;
        HashMap propertyValueMap = new HashMap();
        Mapping propertyToProperty = new Mapping();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?s ?p ?o \nWHERE { ?s rdf:type <" + classExpression1 + "> . \n" + "?s ?p ?o . " + "\n}";
        if (this.LIMIT > 0) {
            query = query + " LIMIT " + this.LIMIT;
        }
        logger.info((Object)("Query:\n" + query));
        Query sparqlQuery = QueryFactory.create((String)query);
        QueryExecution qexec = this.sourceModel == null ? QueryExecutionFactory.sparqlService((String)endpoint1, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.sourceModel);
        ResultSet results = qexec.execSelect();
        int count = 0;
        while (results.hasNext()) {
            ++count;
            QuerySolution soln = results.nextSolution();
            try {
                String s = soln.get("s").toString();
                p = soln.get("p").toString();
                String o = soln.get("o").toString();
                if (DefaultPropertyMapper.isNumeric(o)) continue;
                if (!propertyValueMap.containsKey(p)) {
                    propertyValueMap.put(p, new TreeSet());
                }
                ((TreeSet)propertyValueMap.get(p)).add(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("Had " + count + "results"));
        for (String property : propertyValueMap.keySet()) {
            for (String object : (TreeSet)propertyValueMap.get(property)) {
                if ((object = object.split("@")[0]).contains("\\") || object.contains("\n") || object.contains("\"")) continue;
                String objectString = !object.startsWith("http") ? "\"" + object.replaceAll(" ", "_") + "\"" : "<" + object.replaceAll(" ", "_") + ">";
                query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?p WHERE { ?s rdf:type <" + classExpression2 + "> . " + "?s ?p " + objectString + "}" + "LIMIT 50";
                logger.info((Object)query);
                sparqlQuery = QueryFactory.create((String)query);
                qexec = this.targetModel == null ? QueryExecutionFactory.sparqlService((String)endpoint2, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.targetModel);
                results = qexec.execSelect();
                int count2 = 0;
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    ++count2;
                    try {
                        p = soln.get("p").toString();
                        double sim = propertyToProperty.getSimilarity(property, p);
                        if (sim > 0.0) {
                            propertyToProperty.map.get(property).put(p, sim + 1.0);
                            continue;
                        }
                        propertyToProperty.add(property, p, 1.0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                logger.info((Object)("lead to " + count2 + " results"));
            }
        }
        return propertyToProperty;
    }

    public static void main(String[] args) {
        String base = "C:/Users/Lyko/workspace/LIMES/resources/";
        KBInfo sKB = new KBInfo();
        sKB.endpoint = base + "Persons1/person11.nt";
        sKB.graph = null;
        sKB.pageSize = 1000;
        sKB.id = "person11";
        KBInfo tKB = new KBInfo();
        tKB.endpoint = base + "Persons1/person12.nt";
        tKB.graph = null;
        tKB.pageSize = 1000;
        tKB.id = "person12";
        QueryModuleFactory.getQueryModule("nt", sKB);
        QueryModuleFactory.getQueryModule("nt", tKB);
        Model sModel = ModelRegistry.getInstance().getMap().get(sKB.endpoint);
        Model tModel = ModelRegistry.getInstance().getMap().get(tKB.endpoint);
        DefaultPropertyMapper mapper = new DefaultPropertyMapper();
        mapper.setSourceModel(sModel);
        mapper.setTargetModel(tModel);
        Mapping m = mapper.getPropertyMapping(sKB.endpoint, tKB.endpoint, "http://www.okkam.org/ontology_person1.owl#Person", "http://www.okkam.org/ontology_person2.owl#Person");
        System.out.println("Result = " + m);
    }

    public static boolean isNumeric(String input) {
        if (input.contains("^^")) {
            input = input.split("^^")[0];
        }
        if (input.contains("%")) {
            input = input.split("\\%")[0];
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

