/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.learning.query.OntologyClassMapper;
import de.uni_leipzig.simba.learning.stablematching.HospitalResidents;
import de.uni_leipzig.simba.util.Clock;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class DefaultClassMapper
implements OntologyClassMapper {
    public int LIMIT = 300;
    static Logger logger = Logger.getLogger((String)"LIMES");
    String relation = "http://www.w3.org/2002/07/owl#sameAs";
    Model sourceModel;
    Model targetModel;

    public DefaultClassMapper() {
    }

    public DefaultClassMapper(int limit) {
        this.LIMIT = limit;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    public Mapping getEntityMapping(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        Mapping m = this.getMappingClasses(endpoint1, endpoint2, namespace1, namespace2);
        logger.info((Object)("Got class mapping " + m));
        HospitalResidents hr = new HospitalResidents();
        m = hr.getMatching(m);
        logger.info((Object)("Final class mapping is " + m));
        return m;
    }

    public Mapping getMappingClasses(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        Clock clock = new Clock();
        logger.info((Object)("Getting mapping from " + namespace1 + " to " + namespace2));
        Mapping m1 = this.getMonoDirectionalMap(endpoint1, endpoint2, namespace1, namespace2);
        logger.info((Object)("Took " + clock.durationSinceClick() + " ms"));
        logger.info((Object)("Getting mapping from " + namespace2 + " to " + namespace1));
        Mapping m2 = this.getMonoDirectionalMap(endpoint2, endpoint1, namespace2, namespace1);
        logger.info((Object)("Took " + clock.durationSinceClick() + " ms"));
        logger.info((Object)"Merging the mappings...");
        for (String value : m2.map.keySet()) {
            for (String key : m2.map.get(value).keySet()) {
                double sim2 = m2.getSimilarity(value, key);
                double sim1 = m1.getSimilarity(key, value);
                m1.add(key, value, sim1 + sim2);
            }
        }
        if (m1.size() == 0) {
            logger.info((Object)"No mapping found. Using fallback solution.");
            m1 = this.getMappingClassesFallback(endpoint1, endpoint2, namespace1, namespace2);
        }
        return m1;
    }

    public Mapping getMappingClassesFallback(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        Clock clock = new Clock();
        logger.info((Object)("Getting mapping from " + namespace1 + " to " + namespace2));
        Mapping m1 = this.getMonoDirectionalMapFallback(endpoint1, endpoint2, namespace1, namespace2);
        logger.info((Object)("Took " + clock.durationSinceClick() + " ms"));
        logger.info((Object)("Getting mapping from " + namespace2 + " to " + namespace1));
        Mapping m2 = this.getMonoDirectionalMapFallback(endpoint2, endpoint1, namespace2, namespace1);
        logger.info((Object)("Took " + clock.durationSinceClick() + " ms"));
        logger.info((Object)"Merging the mappings...");
        for (String value : m2.map.keySet()) {
            for (String key : m2.map.get(value).keySet()) {
                double sim2 = m2.getSimilarity(value, key);
                double sim1 = m1.getSimilarity(key, value);
                m1.add(key, value, sim1 + sim2);
            }
        }
        return m1;
    }

    public Mapping getMonoDirectionalMap(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        String x;
        HashMap instanceToClassMap = new HashMap();
        HashMap instanceToInstanceMap = new HashMap();
        Mapping classToClassMapping = new Mapping();
        String query = "SELECT ?x ?a ?b WHERE { ?a <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?x. ?a <" + this.relation + "> ?b. " + "FILTER REGEX(str(?b), \"" + namespace2 + "\") " + "} ";
        if (this.LIMIT > 0) {
            query = query + "LIMIT " + this.LIMIT;
        }
        logger.info((Object)("Query from " + namespace1 + " to " + namespace2 + ":\n" + query));
        Query sparqlQuery = QueryFactory.create((String)query);
        QueryExecution qexec = this.sourceModel == null ? QueryExecutionFactory.sparqlService((String)endpoint1, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.sourceModel);
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            try {
                x = soln.get("x").toString();
                String a = soln.get("a").toString();
                String b = soln.get("b").toString();
                if (x.equalsIgnoreCase("http://www.w3.org/2002/07/owl#Thing")) continue;
                if (!instanceToClassMap.containsKey(a)) {
                    instanceToClassMap.put(a, new TreeSet());
                }
                ((TreeSet)instanceToClassMap.get(a)).add(x);
                if (!instanceToInstanceMap.containsKey(b)) {
                    instanceToInstanceMap.put(b, new TreeSet());
                }
                ((TreeSet)instanceToInstanceMap.get(b)).add(a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        logger.info((Object)("Got " + instanceToClassMap.size() + " classes"));
        for (String bValue : instanceToInstanceMap.keySet()) {
            bValue = bValue.replaceAll(" ", "_");
            query = "SELECT distinct ?x WHERE { <" + bValue + "> <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> ?x }";
            sparqlQuery = QueryFactory.create((String)query);
            qexec = this.targetModel == null ? QueryExecutionFactory.sparqlService((String)endpoint2, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.targetModel);
            results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                try {
                    x = soln.get("x").toString();
                    for (String instance : (TreeSet)instanceToInstanceMap.get(bValue)) {
                        TreeSet set = (TreeSet)instanceToClassMap.get(instance);
                        for (String clas : set) {
                            if (classToClassMapping.map.containsKey(x)) {
                                if (classToClassMapping.map.get(x).containsKey(clas)) {
                                    classToClassMapping.map.get(x).put(clas, classToClassMapping.map.get(x).get(clas) + 1.0);
                                    continue;
                                }
                                classToClassMapping.map.get(x).put(clas, 1.0);
                                continue;
                            }
                            classToClassMapping.add(x, clas, 1.0);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return classToClassMapping;
    }

    public Mapping getMonoDirectionalMapFallback(String endpoint1, String endpoint2, String namespace1, String namespace2) {
        HashMap classValueMap = new HashMap();
        Mapping classToClass = new Mapping();
        String query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?s ?p ?x ?o \nWHERE { ?s rdf:type ?x . \n?s ?p ?o .\n}";
        if (this.LIMIT > 0) {
            query = query + " LIMIT " + this.LIMIT;
        }
        logger.info((Object)("Query:\n" + query));
        Query sparqlQuery = QueryFactory.create((String)query);
        QueryExecution qexec = this.sourceModel == null ? QueryExecutionFactory.sparqlService((String)endpoint1, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.sourceModel);
        ResultSet results = qexec.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            try {
                String s = soln.get("s").toString();
                String p = soln.get("p").toString();
                String o = soln.get("o").toString();
                String x = soln.get("x").toString();
                if (!classValueMap.containsKey(x)) {
                    classValueMap.put(x, new TreeSet());
                }
                ((TreeSet)classValueMap.get(x)).add(o);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String className : classValueMap.keySet()) {
            for (String object : (TreeSet)classValueMap.get(className)) {
                if ((object = object.split("@")[0]).contains("\\") || object.contains("\n") || object.contains("\"")) continue;
                query = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> \nSELECT ?y WHERE { ?s rdf:type ?y . ?s ?p \"" + object + "\"}";
                sparqlQuery = QueryFactory.create((String)query);
                qexec = this.targetModel == null ? QueryExecutionFactory.sparqlService((String)endpoint2, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)this.targetModel);
                results = qexec.execSelect();
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    try {
                        String y = soln.get("y").toString();
                        double sim = classToClass.getSimilarity(className, y);
                        if (sim > 0.0) {
                            classToClass.map.get(className).put(y, sim + 1.0);
                            continue;
                        }
                        classToClass.add(className, y, 1.0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return classToClass;
    }

    public static void main(String[] args) {
        DefaultClassMapper cm = new DefaultClassMapper(100);
        String ep1 = "http://live.dbpedia.org/sparql";
        String ep2 = "http://www4.wiwiss.fu-berlin.de/sider/sparql";
        String nsp1 = "dbpedia";
        String nsp2 = "sider";
        Mapping m = cm.getMappingClasses(ep1, ep2, nsp1, nsp2).reverseSourceTarget();
        logger.info((Object)m);
    }

    public static boolean isNumeric(String input) {
        if (input.contains("^^")) {
            input = input.split("^^")[0];
        }
        if (input.contains("%")) {
            input = input.split("\\%")[0];
        }
        try {
            Double.parseDouble(input);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

