/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.oracle.mappingreader;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.learning.oracle.mappingreader.MappingReader;
import java.io.FileInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLMappingReader
implements MappingReader {
    public Mapping getMapping(String filePath) {
        Mapping m = new Mapping();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document xmlDocument = builder.parse(new FileInputStream(filePath));
            NodeList list = xmlDocument.getElementsByTagName("Alignment");
            String namespace = "";
            String label = "";
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList children = list.item(i).getChildNodes();
                for (int j = 0; j < children.getLength(); ++j) {
                    Node child = children.item(j);
                    if (!child.getNodeName().equals("map")) continue;
                    NodeList grandChildren = child.getChildNodes();
                    for (int k = 0; k < grandChildren.getLength(); ++k) {
                        Node grandChild = grandChildren.item(k);
                        if (!grandChild.getNodeName().equals("Cell")) continue;
                        String s = "";
                        String t = "";
                        NodeList ggChildren = grandChild.getChildNodes();
                        for (int z = 0; z < ggChildren.getLength(); ++z) {
                            Node ggChild = ggChildren.item(z);
                            if (ggChild.getNodeName().equalsIgnoreCase("entity1")) {
                                s = ggChild.getAttributes().getNamedItem("rdf:resource").getNodeValue();
                            }
                            if (!ggChild.getNodeName().equalsIgnoreCase("entity2")) continue;
                            t = ggChild.getAttributes().getNamedItem("rdf:resource").getNodeValue();
                        }
                        if (s.endsWith("/") || t.endsWith("/")) continue;
                        m.add(s, t, 1.0);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public static void main(String[] args) {
        Mapping m = new XMLMappingReader().getMapping("D:/Work/Data/Linking/DI03062010/sider-alignment-test.xml");
        System.out.println(m.size());
    }

    public String getType() {
        return "XML";
    }
}

