/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.oracle.mappingreader;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.learning.oracle.mappingreader.MappingReader;
import de.uni_leipzig.simba.util.DataCleaner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class CSVMappingReader
implements MappingReader {
    private String SEP = ",";
    private boolean cleanIRI = false;

    public Mapping getMapping(String filePath) {
        Mapping result = new Mapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filePath));
            String s = reader.readLine();
            if (s != null) {
                ArrayList<String> properties = new ArrayList<String>();
                String[] split = s.split(this.SEP);
                for (int i = 0; i < split.length; ++i) {
                    properties.add(split[i]);
                }
                s = reader.readLine();
                while (s != null) {
                    split = s.split(this.SEP);
                    if (split.length != properties.size()) {
                        split = DataCleaner.separate(s, this.SEP, properties.size());
                    }
                    if (!this.cleanIRI) {
                        result.add(split[0], split[1], 1.0);
                    } else {
                        result.add(split[0].replaceAll("\\<", "").replaceAll("\\>", ""), split[1].replaceAll("\\<", "").replaceAll("\\>", ""), 1.0);
                    }
                    s = reader.readLine();
                }
            } else {
                Logger logger = Logger.getLogger((String)"Limes");
                logger.error((Object)("No line in reference + " + filePath));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setSeparator(String s) {
        this.SEP = s;
    }

    public void setCleanIRI(boolean clean) {
        this.cleanIRI = clean;
    }

    public static void main(String[] args) {
        CSVMappingReader reader = new CSVMappingReader();
        String test = "Examples/GeneticEval/Datasets/dbpedia-linkedmdb/reference2.csv";
        Mapping m = reader.getMapping(test);
        System.out.println(m);
    }

    public String getType() {
        if (this.SEP.equalsIgnoreCase("\t")) {
            return "TAB";
        }
        return "CSV";
    }
}

