/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.learner;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.learner.Configuration;
import de.uni_leipzig.simba.learning.learner.Learner;
import de.uni_leipzig.simba.learning.learner.LinearConfiguration;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.MeasureFactory;
import de.uni_leipzig.simba.util.Utils;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerceptronLearner
implements Learner {
    public double REGRESSION = 0.8;
    static Logger logger = Logger.getLogger((String)"LIMES");
    int inquiries;
    Oracle oracle;
    Cache source;
    KBInfo sourceInfo;
    Cache target;
    KBInfo targetInfo;
    LinearConfiguration config;
    Mapping positives;
    Mapping negatives;
    Mapping results;
    Mapping oldResults;
    SetConstraintsMapper mapper;
    double learningRate;
    double EPSILON = 0.1;

    public PerceptronLearner(KBInfo sInfo, KBInfo tInfo, Cache s, Cache t, Oracle o, Mapping propertyMapping, HashMap<String, String> propertyType, double a, double b) {
        this.oracle = o;
        this.source = s;
        this.target = t;
        if (this.source.size() < 10 || this.target.size() < 10) {
            logger.fatal((Object)"No enough instances in caches");
            System.exit(1);
        }
        this.sourceInfo = sInfo;
        this.targetInfo = tInfo;
        this.inquiries = 0;
        this.positives = new Mapping();
        this.negatives = new Mapping();
        this.config = new LinearConfiguration(propertyMapping, propertyType);
        this.mapper = SetConstraintsMapperFactory.getMapper("simple", this.targetInfo, this.sourceInfo, this.target, this.source, new LinearFilter(), 2);
        double threshold = this.config.threshold * this.REGRESSION;
        logger.info((Object)("Getting initial links with threshold " + threshold));
        this.results = new Mapping();
        while (this.results.size < 10) {
            this.results = this.mapper.getLinks(this.config.getExpression(), threshold);
            logger.info((Object)("Got " + this.results.size() + " initial links ..."));
            if (this.results.size >= 10) continue;
            logger.warn((Object)"Not enough instances to learn from");
            if (threshold < 0.1) {
                logger.fatal((Object)"Threshold < 0.1. Exiting");
                System.exit(1);
                continue;
            }
            logger.info((Object)("\n\nNew threshold = " + (threshold *= this.REGRESSION)));
        }
        logger.info(this.getPRF());
        this.oldResults = new Mapping();
        this.learningRate = (a + b) / 2.0;
    }

    @Override
    public boolean computeNextConfig(int n) {
        boolean moreSteps;
        boolean answer;
        String term2;
        String term1;
        Measure m;
        Parser parser;
        Mapping mostInfPos = PerceptronLearner.getMostInformativePositives(this.results, this.config.threshold, this.positives, n / 2);
        Mapping mostInfNeg = PerceptronLearner.getMostInformativeNegatives(this.results, this.config.threshold, this.negatives, n / 2);
        logger.info((Object)("\n\nMOSTINFPOS = " + mostInfPos));
        logger.info((Object)("\n\nMOSTINFNEG = " + mostInfNeg));
        HashMap<String, Double> vector = new HashMap<String, Double>();
        for (String expression : this.config.mapping.keySet()) {
            vector.put(expression, 0.0);
        }
        vector.put("bias", 0.0);
        for (String expression : this.config.mapping.keySet()) {
            parser = new Parser(expression, 1.0);
            m = MeasureFactory.getMeasure(parser.op);
            term1 = parser.term1.substring(parser.term1.indexOf(".") + 1);
            term2 = parser.term2.substring(parser.term2.indexOf(".") + 1);
            System.out.println("***" + this.source.getAllUris().get(0));
            System.out.println(this.target.getAllUris().get(0) + "\n");
            for (String key : mostInfPos.map.keySet()) {
                for (String value : mostInfPos.map.get(key).keySet()) {
                    answer = this.oracle.ask(key, value);
                    if (answer) continue;
                    System.out.println(key);
                    System.out.println(value);
                    vector.put(expression, (Double)vector.get(expression) + m.getSimilarity(this.source.getInstance(key), this.target.getInstance(value), term1, term2));
                }
            }
        }
        double examples = 0.0;
        for (String key : mostInfPos.map.keySet()) {
            for (String value : mostInfPos.map.get(key).keySet()) {
                answer = this.oracle.ask(key, value);
                if (answer) continue;
                logger.info((Object)("(" + key + "," + value + ") should be negative"));
                vector.put("bias", (Double)vector.get("bias") + mostInfPos.getSimilarity(key, value));
                this.negatives.add(key, value, 1.0);
                examples += 1.0;
            }
        }
        for (String expression : this.config.mapping.keySet()) {
            parser = new Parser(expression, 1.0);
            m = MeasureFactory.getMeasure(parser.op);
            term1 = parser.term1.substring(parser.term1.indexOf(".") + 1);
            term2 = parser.term2.substring(parser.term2.indexOf(".") + 1);
            for (String key : mostInfNeg.map.keySet()) {
                for (String value : mostInfNeg.map.get(key).keySet()) {
                    answer = this.oracle.ask(key, value);
                    if (!answer) continue;
                    logger.info((Object)("(" + key + "," + value + ") should be positive"));
                    vector.put(expression, (Double)vector.get(expression) - m.getSimilarity(this.source.getInstance(key), this.target.getInstance(value), term1, term2));
                }
            }
        }
        for (String key : mostInfNeg.map.keySet()) {
            for (String value : mostInfNeg.map.get(key).keySet()) {
                answer = this.oracle.ask(key, value);
                if (!answer) continue;
                vector.put("bias", (Double)vector.get("bias") - mostInfNeg.getSimilarity(key, value));
                this.positives.add(key, value, 1.0);
                examples += 1.0;
            }
        }
        logger.info((Object)("Update vector:\n" + vector));
        if (examples > 0.0) {
            moreSteps = true;
            for (String expression : this.config.mapping.keySet()) {
                this.config.mapping.put(expression, this.config.mapping.get(expression) + this.learningRate * (Double)vector.get(expression) / examples);
            }
            this.config.threshold += this.learningRate * (Double)vector.get("bias");
            this.oldResults = this.results;
            this.results = this.mapper.getLinks(this.config.getExpression(), this.config.threshold);
            logger.info(this.getPRF());
        } else {
            logger.info((Object)"Classifications were all correct. No need to update");
            moreSteps = false;
        }
        return moreSteps;
    }

    public HashMap<String, Double> getPRF() {
        return Utils.getPRF(this.oracle.getMapping(), this.results);
    }

    public Mapping returnFinalResults() {
        return this.mapper.getLinks(this.config.getExpression(), this.config.threshold);
    }

    public static Mapping getMostInformativePositives(Mapping m, double threshold, Mapping tabu, int n) {
        logger.info((Object)("Getting most informative positives with threshold " + threshold));
        Mapping mostInfPos = new Mapping();
        double min = Double.MAX_VALUE;
        double sim = 0.0;
        String[] result = new String[2];
        for (int i = 0; i < n; ++i) {
            String uri1 = "";
            String uri2 = "";
            min = Double.MAX_VALUE;
            sim = 0.0;
            for (String key : m.map.keySet()) {
                for (String value : m.map.get(key).keySet()) {
                    if (tabu.contains(key, value) || mostInfPos.contains(key, value) || !((sim = m.getSimilarity(key, value)) >= threshold) || !(sim - threshold < min)) continue;
                    min = sim - threshold;
                    logger.info((Object)("Min went down to " + min));
                    uri1 = key;
                    uri2 = value;
                    logger.info((Object)("Min valid for <" + uri1 + "> <" + uri2 + "> with sim " + sim));
                }
            }
            if (uri1.equals("")) break;
            logger.info((Object)("Adding <" + uri1 + "> <" + uri2 + "> with sim " + (threshold + min)));
            mostInfPos.add(uri1, uri2, threshold + min);
        }
        logger.info((Object)("Found " + mostInfPos + " most informative positives"));
        return mostInfPos;
    }

    public static Mapping getMostInformativeNegatives(Mapping m, double threshold, Mapping tabu, int n) {
        Mapping mostInfNeg = new Mapping();
        double min = Double.MAX_VALUE;
        double sim = 0.0;
        for (int i = 0; i < n; ++i) {
            String uri1 = "";
            String uri2 = "";
            min = Double.MAX_VALUE;
            sim = 0.0;
            for (String key : m.map.keySet()) {
                for (String value : m.map.get(key).keySet()) {
                    if (tabu.contains(key, value) || mostInfNeg.contains(key, value) || !((sim = m.getSimilarity(key, value)) < threshold) || !(threshold - sim < min)) continue;
                    min = threshold - sim;
                    uri1 = key;
                    uri2 = value;
                    logger.info((Object)("Min went down to " + min));
                    logger.info((Object)("Min valid for <" + uri1 + "> <" + uri2 + "> with sim " + sim));
                }
            }
            if (uri1.equals("")) break;
            logger.info((Object)("Adding <" + uri1 + "> <" + uri2 + "> with sim " + (threshold + min)));
            mostInfNeg.add(uri1, uri2, threshold - min);
        }
        logger.info((Object)("Found " + mostInfNeg + " most informative negatives"));
        return mostInfNeg;
    }

    @Override
    public Configuration getCurrentConfig() {
        return this.config;
    }

    @Override
    public double getPrecision() {
        double tp = 0.0;
        for (String s : this.positives.map.keySet()) {
            for (String t : this.positives.map.get(s).keySet()) {
                if (!(this.results.getSimilarity(s, t) > 0.0)) continue;
                tp += 1.0;
            }
        }
        return tp / (double)this.positives.size();
    }

    @Override
    public double getRecall() {
        return this.results.size();
    }
}

