/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.learner;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.learner.Configuration;
import de.uni_leipzig.simba.learning.learner.Learner;
import de.uni_leipzig.simba.learning.learner.LinearConfiguration;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.MeasureFactory;
import de.uni_leipzig.simba.measures.MeasureProcessor;
import java.util.HashMap;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearCombinationLearner
implements Learner {
    static Logger logger = Logger.getLogger((String)"LIMES");
    int inquiries;
    Oracle oracle;
    Cache source;
    KBInfo sourceInfo;
    Cache target;
    KBInfo targetInfo;
    LinearConfiguration config;
    Mapping positives;
    Mapping negatives;
    Mapping results;
    Mapping oldResults;
    SetConstraintsMapper mapper;
    double alpha;
    double beta;

    public LinearCombinationLearner(KBInfo sInfo, KBInfo tInfo, Cache s, Cache t, Oracle o, Mapping propertyMapping, HashMap<String, String> propertyType, double a, double b) {
        this.oracle = o;
        this.source = s;
        this.target = t;
        this.sourceInfo = sInfo;
        this.targetInfo = tInfo;
        this.inquiries = 0;
        this.positives = new Mapping();
        this.negatives = new Mapping();
        this.config = new LinearConfiguration(propertyMapping, propertyType);
        this.mapper = SetConstraintsMapperFactory.getMapper("simple", this.sourceInfo, this.targetInfo, this.source, this.target, new LinearFilter(), 2);
        logger.info((Object)"Getting initial links ...");
        this.results = this.mapper.getLinks(this.config.getExpression(), this.config.threshold);
        logger.info((Object)("Got " + this.results.size() + " initial links ..."));
        this.oldResults = new Mapping();
        this.alpha = a;
        this.beta = b;
    }

    @Override
    public boolean computeNextConfig(int n) {
        Mapping difference = this.diff(this.results, this.oldResults, n);
        if (difference.size() == 0) {
            return false;
        }
        Mapping newPositives = new Mapping();
        Mapping newNegatives = new Mapping();
        logger.info((Object)("\n\n\nDifference contains " + difference.size() + " entities"));
        for (String s : difference.map.keySet()) {
            for (String p : difference.map.get(s).keySet()) {
                boolean positive = this.oracle.ask(s, p);
                ++this.inquiries;
                double sim = MeasureProcessor.getSimilarity(this.source.getInstance(s), this.target.getInstance(p), this.config.getExpression(), this.sourceInfo.var, this.targetInfo.var);
                if (positive) {
                    newPositives.add(s, p, sim);
                    continue;
                }
                newNegatives.add(s, p, sim);
            }
        }
        logger.info((Object)("New positives = " + newPositives));
        logger.info((Object)("New negatives = " + newNegatives));
        double sum = 0.0;
        logger.info((Object)("Configuration before learning = " + this.config.mapping));
        for (String expression : this.config.mapping.keySet()) {
            String term1;
            Parser parser = new Parser(expression, 1.0);
            Measure m = MeasureFactory.getMeasure(parser.op);
            for (String uri1 : newPositives.map.keySet()) {
                for (String uri2 : newPositives.map.get(uri1).keySet()) {
                    term1 = parser.term1.substring(parser.term1.indexOf(".") + 1);
                    String term2 = parser.term2.substring(parser.term2.indexOf(".") + 1);
                    logger.info((Object)("Sum = " + (sum += this.alpha * m.getSimilarity(this.source.getInstance(uri1), this.target.getInstance(uri2), term1, term2))));
                }
            }
            for (String uri1 : newNegatives.map.keySet()) {
                for (String uri2 : newNegatives.map.get(uri1).keySet()) {
                    term1 = parser.term1.substring(parser.term1.indexOf(".") + 1);
                    String term2 = parser.term2.substring(parser.term2.indexOf(".") + 1);
                    logger.info((Object)("Sum = " + (sum -= this.beta * m.getSimilarity(this.source.getInstance(uri1), this.target.getInstance(uri2), term1, term2))));
                }
            }
            double weight = this.config.mapping.get(expression);
            logger.info((Object)("Weight for <" + parser.term1 + "> and <" + parser.term2 + "> goes from " + weight + " to " + (weight + sum)));
            this.config.mapping.put(expression, weight + sum);
        }
        logger.info((Object)("Configuration after learning = " + this.config.mapping));
        Mapping help = new Mapping();
        double sim = 0.0;
        double min = 2.147483647E9;
        double totalSum = 0.0;
        double counter = 0.0;
        for (String key : this.positives.map.keySet()) {
            for (String value : this.positives.map.get(key).keySet()) {
                sim = MeasureProcessor.getSimilarity(this.source.getInstance(key), this.target.getInstance(value), this.config.getExpression(), this.sourceInfo.var, this.targetInfo.var);
                totalSum += sim;
                counter += 1.0;
                if (sim > min) {
                    min = sim;
                }
                help.add(key, value, sim);
            }
        }
        for (String key : newPositives.map.keySet()) {
            for (String value : newPositives.map.get(key).keySet()) {
                sim = MeasureProcessor.getSimilarity(this.source.getInstance(key), this.target.getInstance(value), this.config.getExpression(), this.sourceInfo.var, this.targetInfo.var);
                totalSum += sim;
                counter += 1.0;
                if (sim > min) {
                    min = sim;
                }
                help.add(key, value, sim);
            }
        }
        this.positives = help;
        help = new Mapping();
        sim = 0.0;
        double max = 0.0;
        for (String key : this.negatives.map.keySet()) {
            for (String value : this.negatives.map.get(key).keySet()) {
                sim = MeasureProcessor.getSimilarity(this.source.getInstance(key), this.target.getInstance(value), this.config.getExpression(), this.sourceInfo.var, this.targetInfo.var);
                totalSum += sim;
                counter += 1.0;
                if (sim > max) {
                    max = sim;
                }
                help.add(key, value, sim);
            }
        }
        for (String key : newNegatives.map.keySet()) {
            for (String value : newNegatives.map.get(key).keySet()) {
                sim = MeasureProcessor.getSimilarity(this.source.getInstance(key), this.target.getInstance(value), this.config.getExpression(), this.sourceInfo.var, this.targetInfo.var);
                totalSum += sim;
                counter += 1.0;
                if (sim > max) {
                    max = sim;
                }
                help.add(key, value, sim);
            }
        }
        this.negatives = help;
        this.config.threshold = totalSum / counter;
        logger.info((Object)("New threshold = " + this.config.threshold));
        this.oldResults = this.results;
        logger.info((Object)("Current Precision = " + this.getPrecision()));
        logger.info((Object)("Current Recall = " + this.getRecall()));
        this.results = this.mapper.getLinks(this.config.getExpression(), this.config.threshold);
        return true;
    }

    public Mapping diff(Mapping a, Mapping b, int maxSize) {
        Mapping difference = new Mapping();
        int counter = 0;
        for (String uri1 : a.map.keySet()) {
            for (String uri2 : a.map.get(uri1).keySet()) {
                if (b.contains(uri1, uri2) || this.positives.contains(uri1, uri2) || this.negatives.contains(uri1, uri2)) continue;
                difference.add(uri2, uri1, a.getSimilarity(uri1, uri2));
                if (++counter != maxSize) continue;
                return difference;
            }
        }
        return difference;
    }

    @Override
    public Configuration getCurrentConfig() {
        return this.config;
    }

    @Override
    public double getPrecision() {
        double tp = 0.0;
        if (this.positives.size() == 0) {
            return Double.NaN;
        }
        for (String s : this.positives.map.keySet()) {
            for (String t : this.positives.map.get(s).keySet()) {
                if (!(this.results.getSimilarity(s, t) > 0.0)) continue;
                tp += 1.0;
            }
        }
        return tp / (double)this.positives.size();
    }

    @Override
    public double getRecall() {
        return this.results.size();
    }
}

