/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.learner;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.learner.LinearConfiguration;
import de.uni_leipzig.simba.learning.learner.PerceptronLearner;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.learning.oracle.oracle.SimpleOracle;
import de.uni_leipzig.simba.learning.query.DefaultClassMapper;
import de.uni_leipzig.simba.learning.query.DefaultPropertyMapper;
import de.uni_leipzig.simba.learning.stablematching.HospitalResidents;
import de.uni_leipzig.simba.util.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

public class LearningController {
    static int CLASS_LIMIT = 100;
    static int PROP_LIMIT = 500;
    static int NUMBER_INQUIRIES = 4;
    static int NUMBER_ITERATIONS = 30;
    static double LR = 0.01;
    String sourceEndpoint;
    String targetEndpoint;
    String sourceNamespace;
    String targetNamespace;
    SimpleOracle oracle;
    static Logger logger = Logger.getLogger((String)"LIMES");
    Clock clock;

    public LearningController(String endpoint1, String endpoint2, String ns1, String ns2, String oracleData, String oracleDataType) {
        this.sourceEndpoint = endpoint1;
        this.targetEndpoint = endpoint2;
        this.sourceNamespace = ns1;
        this.targetNamespace = ns2;
        this.oracle = (SimpleOracle)OracleFactory.getOracle(oracleData, oracleDataType, "simple");
        String configFile = oracleData + ".log";
        this.clock = new Clock();
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, configFile.replaceAll(".xml", "") + ".log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
    }

    public String[] getBestMatch(Mapping m) {
        double maxSim = 0.0;
        double sim = 0.0;
        String s = null;
        String t = null;
        for (String a : m.map.keySet()) {
            for (String b : m.map.get(a).keySet()) {
                if (a.equals("http://www.w3.org/2002/07/owl#Thing") || b.equals("http://www.w3.org/2002/07/owl#Thing") || !((sim = m.getSimilarity(a, b)) > maxSim)) continue;
                maxSim = sim;
                s = a;
                t = b;
            }
        }
        if (s == null) {
            return null;
        }
        String[] match = new String[]{s, t};
        return match;
    }

    public void run() {
        String[] match;
        Clock c = new Clock();
        logger.info((Object)c.durationSinceClick());
        DefaultClassMapper cm = new DefaultClassMapper();
        cm.LIMIT = CLASS_LIMIT;
        DefaultPropertyMapper pm = new DefaultPropertyMapper();
        pm.LIMIT = PROP_LIMIT;
        logger.info((Object)"Generating initial configuration");
        Mapping properties = new Mapping();
        Mapping classes = new Mapping();
        Mapping mappingClasses = cm.getMappingClasses(this.sourceEndpoint, this.targetEndpoint, this.sourceNamespace, this.targetNamespace);
        HospitalResidents hr = new HospitalResidents();
        int counter = 0;
        logger.info((Object)("Classes:\n" + classes));
        do {
            logger.info((Object)("\n******\nAttempt " + ++counter + " ... "));
            if (mappingClasses.size() == 0) {
                logger.info((Object)"No mapping classes found. Exiting.");
                System.exit(1);
            }
            classes = hr.getMatching(mappingClasses);
            logger.info((Object)("Classes:\n" + classes));
            match = this.getBestMatch(classes);
            if (match == null) continue;
            logger.info((Object)("Best match : " + match[0] + " -> " + match[1]));
            properties = pm.getPropertyMapping(this.sourceEndpoint, this.targetEndpoint, match[0], match[1]);
            if (properties.size() != 0) continue;
            logger.info((Object)(match[0] + " to " + match[1] + " did not have matching properties."));
            logger.info((Object)"Trying the next option.");
            mappingClasses.map.get(match[0]).remove(match[1]);
        } while (properties.size() == 0);
        logger.info((Object)("Properties:\n" + properties));
        LinearConfiguration lc = new LinearConfiguration(properties, LinearConfiguration.generateStringTyping(properties));
        logger.info((Object)("Initial configuration: " + lc.getExpression() + " >= " + lc.threshold));
        KBInfo sourceInfo = new KBInfo();
        sourceInfo.endpoint = this.sourceEndpoint;
        sourceInfo.id = this.sourceNamespace;
        if (!this.sourceNamespace.equals("dbpedia") && this.sourceEndpoint.contains("http://lgd.aksw.org:5678")) {
            sourceInfo.graph = "http://www.instancematching.org/oaei/di/" + this.sourceNamespace + "/";
        }
        sourceInfo.pageSize = 100;
        sourceInfo.prefixes = new HashMap<String, String>();
        ArrayList<String> sourceProperties = new ArrayList<String>();
        ArrayList<String> sourceRestrictions = new ArrayList<String>();
        for (String prop : properties.map.keySet()) {
            sourceProperties.add(prop);
        }
        sourceRestrictions.add("?x <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + match[0] + ">");
        sourceInfo.properties = sourceProperties;
        sourceInfo.restrictions = sourceRestrictions;
        sourceInfo.type = "sparql";
        sourceInfo.var = "?x";
        KBInfo targetInfo = new KBInfo();
        targetInfo.endpoint = this.targetEndpoint;
        targetInfo.id = this.targetNamespace;
        if (!this.targetNamespace.equals("dbpedia") && this.targetEndpoint.contains("http://lgd.aksw.org:5678")) {
            targetInfo.graph = "http://www.instancematching.org/oaei/di/" + this.targetNamespace + "/";
        }
        targetInfo.pageSize = 100;
        targetInfo.prefixes = new HashMap<String, String>();
        ArrayList<String> targetProperties = new ArrayList<String>();
        ArrayList<String> targetRestrictions = new ArrayList<String>();
        for (String prop : sourceProperties) {
            for (String targetProp : properties.map.get(prop).keySet()) {
                if (targetProperties.contains(targetProp)) continue;
                targetProperties.add(targetProp);
            }
        }
        targetRestrictions.add("?y <http://www.w3.org/1999/02/22-rdf-syntax-ns#type> <" + match[1] + ">");
        targetInfo.properties = targetProperties;
        targetInfo.restrictions = targetRestrictions;
        targetInfo.type = "sparql";
        targetInfo.var = "?y";
        logger.info((Object)("Source Info = " + sourceInfo));
        logger.info((Object)("Target Info = " + targetInfo));
        HybridCache sourceCache = HybridCache.getNoPrefixData(sourceInfo);
        HybridCache targetCache = HybridCache.getNoPrefixData(targetInfo);
        this.clock.durationSinceClick();
        PerceptronLearner learner = new PerceptronLearner(sourceInfo, targetInfo, sourceCache, targetCache, this.oracle, properties, LinearConfiguration.generateStringTyping(properties), LR, LR);
        logger.info((Object)("Preparation time is " + c.durationSinceClick() + " ms"));
        logger.info((Object)("\n\nInitial config = " + learner.config.getExpression()));
        boolean more = true;
        String results = "Iteration\tInquiries\tPrecision\tRecall\tF-Score\tRuntime\n";
        results = results + "0\t0\t";
        HashMap<String, Double> prf = learner.getPRF();
        results = results + prf.get("precision") + "\t";
        results = results + prf.get("recall") + "\t";
        results = results + prf.get("fscore") + "\t";
        results = results + this.clock.durationSinceClick() + "\n";
        for (int i = 0; i < NUMBER_ITERATIONS; ++i) {
            results = results + (i + 1) + "\t" + (i + 1) * NUMBER_INQUIRIES + "\t";
            this.clock.durationSinceClick();
            logger.info((Object)("\n\n========= Iteration Nr. " + (i + 1)));
            more = learner.computeNextConfig(NUMBER_INQUIRIES);
            logger.info((Object)("Iteration " + i + " led to " + learner.config.getExpression()));
            prf = learner.getPRF();
            results = results + prf.get("precision") + "\t";
            results = results + prf.get("recall") + "\t";
            results = results + prf.get("fscore") + "\t";
            results = results + this.clock.durationSinceClick() + "\n";
            logger.info((Object)("Computation lasted " + this.clock.durationSinceClick() + " ms."));
        }
        logger.info((Object)learner.returnFinalResults());
        logger.info((Object)("Results: \n\n" + results));
    }

    public static void main(String[] args) {
        String namespace = "diseasome";
        LearningController c = new LearningController("http://lgd.aksw.org:5678/sparql", "http://lgd.aksw.org:5678/sparql", "diseasome", "sider", "D:/Work/Data/Linking/Final Reference Data/diseasome_sider_reference.nt", "CSV");
        c.run();
    }
}

