/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.learning.learner;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.learning.learner.Configuration;
import de.uni_leipzig.simba.measures.MeasureFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanClassifier
implements Configuration {
    HashMap<String, Double> mapping = new HashMap();
    public double INIT_THRESHOLD = 0.9;
    static Logger logger = Logger.getLogger((String)"LIMES");

    public BooleanClassifier(HashMap<String, TreeSet<String>> propertyMapping, HashMap<String, String> propertyType) {
        for (String p : propertyMapping.keySet()) {
            String measure = MeasureFactory.getMeasure("default", propertyType.get(p)).getName();
            for (String q : propertyMapping.get(p)) {
                this.mapping.put(measure + "(" + p + "," + q + ")", this.INIT_THRESHOLD);
            }
        }
    }

    public BooleanClassifier(Mapping propertyMapping, HashMap<String, String> propertyType) {
        for (String p : propertyMapping.map.keySet()) {
            String measure = MeasureFactory.getMeasure("random", propertyType.get(p)).getName();
            for (String q : propertyMapping.map.get(p).keySet()) {
                if (!(propertyMapping.getSimilarity(p, q) > 0.0)) continue;
                this.mapping.put(measure + "(x." + p + ",y." + q + ")", this.INIT_THRESHOLD);
            }
        }
        logger.info((Object)("Size of property map is " + propertyMapping.size()));
        logger.info((Object)("Setting threshold to " + this.INIT_THRESHOLD));
    }

    @Override
    public String getExpression() {
        String expression = "";
        if (this.mapping.size() == 0) {
            return expression;
        }
        if (this.mapping.size() == 1) {
            Iterator<String> i$ = this.mapping.keySet().iterator();
            while (i$.hasNext()) {
                String s;
                expression = s = i$.next();
            }
            return expression;
        }
        ArrayList<String> nodes = new ArrayList<String>();
        for (String s : this.mapping.keySet()) {
            nodes.add(s);
        }
        expression = (String)nodes.get(0) + "|" + this.mapping.get(nodes.get(0));
        for (int i = 1; i < nodes.size(); ++i) {
            if (this.mapping.get(nodes.get(i)) > 0.0) {
                expression = "AND(" + expression + ", " + (String)nodes.get(i) + "|" + this.mapping.get(nodes.get(i)) + ")";
                continue;
            }
            this.mapping.remove(nodes.get(i));
        }
        return expression;
    }

    public String getExpression(double multiplier) {
        String expression = "";
        if (this.mapping.size() == 0) {
            return expression;
        }
        if (this.mapping.size() == 1) {
            Iterator<String> i$ = this.mapping.keySet().iterator();
            while (i$.hasNext()) {
                String s;
                expression = s = i$.next();
            }
            return expression;
        }
        ArrayList<String> nodes = new ArrayList<String>();
        for (String s : this.mapping.keySet()) {
            nodes.add(s);
        }
        expression = (String)nodes.get(0) + "|" + this.mapping.get(nodes.get(0)) * multiplier;
        for (int i = 1; i < nodes.size(); ++i) {
            if (this.mapping.get(nodes.get(i)) > 0.0) {
                expression = "AND(" + expression + ", " + (String)nodes.get(i) + "|" + this.mapping.get(nodes.get(i)) * multiplier + ")";
                continue;
            }
            this.mapping.remove(nodes.get(i));
        }
        return expression;
    }

    public static HashMap<String, String> generateStringTyping(Mapping m) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : m.map.keySet()) {
            map.put(s, "string");
            for (String p : m.map.get(s).keySet()) {
                map.put(p, "string");
            }
        }
        return map;
    }

    public static void main(String[] args) {
        Mapping m = new Mapping();
        m.add("http://dbpedia.org/property/bioavailability", "http://www4.wiwiss.fu-berlin.de/drugbank/resource/drugbank/proteinBinding", 9.0);
        m.add("http://www.w3.org/2000/01/rdf-schema#label", "http://www.w3.org/2000/01/rdf-schema#label", 1.0);
        m.add("http://www.w3.org/2000/01/rdf#label", "http://www.w3.org/2000/01/rdfa#label", 1.0);
        BooleanClassifier bc = new BooleanClassifier(m, BooleanClassifier.generateStringTyping(m));
        System.out.println("\n" + bc.getExpression());
        System.out.println("\n" + bc.getExpression(0.8));
    }
}

