/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io.serializer;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.Serializer;
import de.uni_leipzig.simba.io.SerializerFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TtlSerializer
implements Serializer {
    PrintWriter writer;
    Logger logger = Logger.getLogger((String)"LIMES");
    TreeSet<String> statements;
    Map<String, String> prefixList;
    File folder = new File("");

    public TtlSerializer() {
        this.statements = new TreeSet();
        this.prefixList = new HashMap<String, String>();
    }

    @Override
    public void addStatement(String subject, String predicate, String object, double similarity) {
        this.statements.add("<" + subject + "> " + predicate + " <" + object + "> .");
    }

    public void flush() {
        try {
            for (String s : this.statements) {
                this.writer.println(s);
            }
            this.statements = new TreeSet();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error writing");
        }
    }

    @Override
    public void writeToFile(Mapping m, String predicate, String file) {
        this.open(file);
        this.printPrefixes();
        this.statements = new TreeSet();
        for (String s : m.map.keySet()) {
            for (String t : m.map.get(s).keySet()) {
                this.writer.println("<" + s + "> " + predicate + " <" + t + "> .");
            }
        }
        this.close();
    }

    public void printPrefixes() {
        try {
            for (String prefix : this.prefixList.keySet()) {
                this.writer.println("@prefix " + prefix + ": <" + this.prefixList.get(prefix) + "> .");
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error writing");
        }
    }

    @Override
    public void printStatement(String subject, String predicate, String object, double similarity) {
        try {
            this.writer.println("<" + subject + "> " + predicate + " <" + object + "> .");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e);
            this.logger.warn((Object)"Error writing");
        }
    }

    @Override
    public boolean close() {
        try {
            if (this.statements.size() > 0) {
                for (String s : this.statements) {
                    this.writer.println(s);
                }
            }
            this.writer.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error closing PrintWriter");
            this.logger.warn((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean open(String file) {
        try {
            if (!file.contains("/") && !file.contains("\\")) {
                String filePath = this.folder.getAbsolutePath() + File.separatorChar + file;
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            } else {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error creating PrintWriter");
            this.logger.warn((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "TtlSerializer";
    }

    @Override
    public void setPrefixes(Map<String, String> prefixes) {
        this.prefixList = prefixes;
    }

    @Override
    public String getFileExtension() {
        return "ttl";
    }

    public static void main(String[] args) {
        Serializer s = SerializerFactory.getSerializer("ttl");
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put("owl", "http://owl/");
        prefixes.put("rdf", "http://rdf/");
        prefixes.put("dbr", "http://dbpedia.org/resource/");
        s.setPrefixes(prefixes);
        Mapping m = new Mapping();
        m.add("dbr:Lagos", "dbr:Lagoos", 1.0);
        m.add("dbr:Lagois", "dbr:Lagoos", 1.0);
        m.add("dbr:Lagosr", "dbr:Lagoos", 1.0);
        s.writeToFile(m, "owl:sameAs", System.getProperty("user.home") + "/" + "nttest.ttl");
        s.close();
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.folder.getAbsolutePath() + File.separatorChar + fileName);
    }

    @Override
    public void setFolderPath(File f) {
        this.folder = f;
    }
}

