/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io.serializer;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.serializer.NtSerializer;

public class TabSeparatedSerializer
extends NtSerializer {
    public String SEPARATOR = "\t";

    public void addStatement(String subject, String predicate, String object, double similarity) {
        this.statements.add(subject + this.SEPARATOR + object + this.SEPARATOR + similarity);
    }

    public void printStatement(String subject, String predicate, String object, double similarity) {
        try {
            this.writer.println(subject + this.SEPARATOR + object + this.SEPARATOR + similarity);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error writing");
        }
    }

    public String getName() {
        return "TabSeparatedSerializer";
    }

    public void writeToFile(Mapping m, String predicate, String file) {
        this.open(file);
        if (m.size() > 0) {
            String source = m.map.keySet().iterator().next();
            String target = m.map.get(source).keySet().iterator().next();
            for (String s : m.map.keySet()) {
                for (String t : m.map.get(s).keySet()) {
                    this.writer.println("<" + s + ">\t<" + t + ">\t" + m.getSimilarity(s, t));
                }
            }
        }
        this.close();
    }

    public String getFileExtension() {
        return "tsv";
    }
}

