/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io.serializer;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.Serializer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NtSerializer
implements Serializer {
    PrintWriter writer;
    Logger logger = Logger.getLogger((String)"LIMES");
    Set<String> statements;
    Map<String, String> prefixMap;
    File folder = new File("");

    public NtSerializer() {
        this.prefixMap = new HashMap<String, String>();
        this.statements = new TreeSet<String>();
    }

    public NtSerializer(HashMap<String, String> prefixes) {
        this.statements = new TreeSet<String>();
        this.prefixMap = prefixes;
    }

    @Override
    public void addStatement(String subject, String predicate, String object, double similarity) {
        this.statements.add("<" + subject + "> " + predicate + " <" + object + "> .");
    }

    public void flush() {
        try {
            for (String s : this.statements) {
                this.writer.println(s);
            }
            this.statements = new TreeSet<String>();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error writing");
        }
    }

    @Override
    public void writeToFile(Mapping m, String predicate, String file) {
        this.open(file);
        String predicatePrefix = this.getPrefix(predicate);
        if (m.size() > 0) {
            String source = m.map.keySet().iterator().next();
            String target = m.map.get(source).keySet().iterator().next();
            for (String s : m.map.keySet()) {
                for (String t : m.map.get(s).keySet()) {
                    this.writer.println("<" + s + "> " + "<" + NtSerializer.expand(predicate, predicatePrefix) + "> " + "<" + t + "> .");
                }
            }
        }
        this.close();
    }

    public static String expand(String s, String predicate) {
        if (predicate != null && s.indexOf(":") > 0) {
            String[] split = s.split(":");
            return predicate + split[1];
        }
        return s;
    }

    @Override
    public void printStatement(String subject, String predicate, String object, double similarity) {
        String predicatePrefix = this.getPrefix(predicate);
        try {
            this.writer.println("<" + subject + "> " + "<" + NtSerializer.expand(predicate, predicatePrefix) + "> " + "<" + object + "> .");
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error writing");
        }
    }

    public void printPrefixes(Map<String, String> prefixMap, String file) {
        this.open(file);
        for (Map.Entry<String, String> e : prefixMap.entrySet()) {
            String key = e.getKey();
            String url = e.getValue();
            if (!url.startsWith("<") && url.endsWith(">")) {
                url = "<" + e.getValue() + ">";
            }
            if (!key.endsWith(":")) {
                key = key + ":";
            }
            String out = "@prefix " + key + " " + url + " .";
            this.writer.println(out);
        }
        this.writer.flush();
    }

    @Override
    public boolean close() {
        try {
            if (this.statements.size() > 0) {
                for (String s : this.statements) {
                    this.writer.println(s);
                }
            }
            this.writer.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error closing PrintWriter");
            this.logger.warn((Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean open(String file) {
        try {
            if (!file.contains("/") && !file.contains("\\")) {
                String filePath = this.folder.getAbsolutePath() + File.separatorChar + file;
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(filePath)));
            } else {
                this.writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error creating PrintWriter");
            this.logger.warn((Object)e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "N3Serializer";
    }

    @Override
    public void setPrefixes(Map<String, String> prefixes) {
        this.prefixMap = prefixes;
    }

    private String getPrefix(String entry) {
        for (String prefix : this.prefixMap.keySet()) {
            if (!entry.startsWith(prefix + ":")) continue;
            return this.prefixMap.get(prefix);
        }
        return null;
    }

    public static void main(String[] args) {
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put("owl", "http://www.owl.org/");
        prefixes.put("test", "http://www.test.org/");
        NtSerializer n3 = new NtSerializer();
        n3.setPrefixes(prefixes);
        System.out.println(n3.getPrefix("owl:sameAs"));
        System.out.println(NtSerializer.expand("owl:sameAs", "http://www.owl.org/"));
    }

    @Override
    public String getFileExtension() {
        return "nt";
    }

    @Override
    public File getFile(String fileName) {
        return new File(this.folder.getAbsolutePath() + File.separatorChar + fileName);
    }

    @Override
    public void setFolderPath(File folder) {
        this.folder = folder;
    }
}

