/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io.serializer;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.Serializer;
import de.uni_leipzig.simba.io.SerializerFactory;
import de.uni_leipzig.simba.io.serializer.TabSeparatedSerializer;
import java.util.HashMap;
import java.util.Map;

public class CSVSerializer
extends TabSeparatedSerializer {
    public String SEPARATOR = ",";

    public String getName() {
        return "CommaSeparatedSerializer";
    }

    public void printStatement(String subject, String predicate, String object, double similarity) {
        try {
            this.writer.println("\"" + subject + "\"" + this.SEPARATOR + "\"" + object + "\"" + this.SEPARATOR + similarity);
        }
        catch (Exception e) {
            this.logger.warn((Object)"Error writing");
        }
    }

    public String getFileExtension() {
        return "csv";
    }

    public static void main(String[] args) {
        Mapping m = new Mapping();
        m.add("foo:a", "foo:b", 1.0);
        m.add("aa", "bb", 1.0);
        m.add("foo:aaaa", "foo:bb", 0.8);
        Serializer serial = SerializerFactory.getSerializer("csv");
        String fileName = System.getProperty("user.home") + "/";
        fileName = fileName + "test";
        serial.open(fileName);
        String predicate = "foo:sameAs";
        HashMap<String, String> prefixes = new HashMap<String, String>();
        prefixes.put("foo", "http://example.com/");
        serial.setPrefixes(prefixes);
        for (String uri1 : m.map.keySet()) {
            for (Map.Entry<String, Double> e : m.map.get(uri1).entrySet()) {
                serial.printStatement(uri1, predicate, e.getKey(), e.getValue());
            }
        }
        serial.close();
    }
}

