/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io;

import de.uni_leipzig.simba.io.Serializer;
import de.uni_leipzig.simba.io.serializer.CSVSerializer;
import de.uni_leipzig.simba.io.serializer.NtSerializer;
import de.uni_leipzig.simba.io.serializer.TabSeparatedSerializer;
import de.uni_leipzig.simba.io.serializer.TtlSerializer;
import org.apache.log4j.Logger;

public class SerializerFactory {
    public static Serializer getSerializer(String name) {
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.info((Object)("Getting serializer with name " + name));
        if (name == null) {
            return new NtSerializer();
        }
        if (name.toLowerCase().trim().startsWith("tab")) {
            return new TabSeparatedSerializer();
        }
        if (name.toLowerCase().trim().startsWith("csv")) {
            return new CSVSerializer();
        }
        if (name.toLowerCase().trim().startsWith("ttl") || name.toLowerCase().trim().startsWith("turtle")) {
            return new TtlSerializer();
        }
        if (name.toLowerCase().trim().startsWith("nt") || name.toLowerCase().trim().startsWith("turtle")) {
            return new NtSerializer();
        }
        logger.info((Object)("Serializer with name " + name + " not found. Using .nt as default format."));
        return new NtSerializer();
    }

    public static Serializer[] getAllSerializers() {
        return new Serializer[]{SerializerFactory.getSerializer("nt"), SerializerFactory.getSerializer("csv"), SerializerFactory.getSerializer("tab"), SerializerFactory.getSerializer("ttl")};
    }
}

