/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KBInfo
implements Serializable {
    public String id = null;
    public String endpoint = null;
    public String graph = null;
    public String var;
    public List<String> properties;
    public ArrayList<String> restrictions = new ArrayList();
    public Map<String, Map<String, String>> functions;
    public Map<String, String> prefixes;
    public int pageSize = -1;
    public String type = "sparql";

    public KBInfo() {
        this.properties = new ArrayList<String>();
        this.prefixes = new HashMap<String, String>();
        this.functions = new HashMap<String, Map<String, String>>();
    }

    public String toString() {
        String s = "ID: " + this.id + "\n";
        s = s + "Var: " + this.var + "\n";
        s = s + "Prefixes: " + this.prefixes + "\n";
        s = s + "Endpoint: " + this.endpoint + "\n";
        s = s + "Graph: " + this.graph + "\n";
        s = s + "Restrictions: " + this.restrictions + "\n";
        s = s + "Properties: " + this.properties + "\n";
        s = s + "Functions: " + this.functions + "\n";
        s = s + "Page size: " + this.pageSize + "\n";
        s = s + "Type: " + this.type + "\n";
        return s;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.graph == null ? 0 : this.graph.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.pageSize;
        result = 31 * result + (this.prefixes == null ? 0 : this.prefixes.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (this.restrictions == null ? 0 : this.restrictions.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KBInfo other = (KBInfo)obj;
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.graph == null ? other.graph != null : !this.graph.equals(other.graph)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.pageSize != other.pageSize) {
            return false;
        }
        if (this.prefixes == null ? other.prefixes != null : !this.prefixes.equals(other.prefixes)) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        if (this.restrictions == null ? other.restrictions != null : !this.restrictions.equals(other.restrictions)) {
            return false;
        }
        return !(this.var == null ? other.var != null : !this.var.equals(other.var));
    }

    public String getClassOfendpoint() {
        for (String rest : this.restrictions) {
            if (!rest.matches(".* rdf:type .*")) continue;
            String result = rest.substring(rest.indexOf("rdf:type") + 8).replaceAll("<", "").replaceAll(">", "").trim();
            return result;
        }
        return null;
    }

    public String getClassOfendpoint(boolean expanded) {
        for (String rest : this.restrictions) {
            if (!rest.matches(".* rdf:type .*")) continue;
            String result = rest.substring(rest.indexOf("rdf:type") + 8).replaceAll("<", "").replaceAll(">", "").trim();
            if (!expanded) {
                return result;
            }
            String namespace = result.substring(0, result.indexOf(":"));
            if (this.prefixes.containsKey(namespace)) {
                return this.prefixes.get(namespace) + result.substring(result.indexOf(":") + 1);
            }
            return result;
        }
        return null;
    }

    public String getClassRestriction() {
        String ret = null;
        for (String s : this.restrictions) {
            if (s.indexOf("rdf:type") <= -1) continue;
            ret = s.substring(s.indexOf("rdf:type") + 8).trim();
        }
        return ret;
    }

    public String getPrefix(String baseUri) {
        if (this.prefixes.containsValue(baseUri)) {
            for (Map.Entry<String, String> e : this.prefixes.entrySet()) {
                if (!e.getValue().equals(baseUri)) continue;
                return e.getKey();
            }
        }
        return null;
    }
}

