/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.io;

import de.uni_leipzig.simba.io.DtdChecker;
import de.uni_leipzig.simba.io.KBInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigReader {
    public KBInfo sourceInfo;
    public KBInfo targetInfo;
    public String metricExpression;
    public String acceptanceRelation;
    public String verificationRelation;
    public double acceptanceThreshold;
    public String acceptanceFile;
    public double verificationThreshold;
    public String verificationFile;
    public int exemplars = -1;
    public HashMap<String, String> prefixes;
    public String outputFormat;
    public String executionPlan = "simple";
    public int granularity = 2;
    Logger logger = Logger.getLogger((String)"LIMES");
    public static String AS = " AS ";
    public static String RENAME = " RENAME ";
    private String folder = "";

    public ConfigReader() {
        this.prefixes = new HashMap();
    }

    public void processKBDescription(String kb, NodeList children) {
        KBInfo kbinfo = kb.equalsIgnoreCase("source") ? this.sourceInfo : this.targetInfo;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equals("ID")) {
                kbinfo.id = ConfigReader.getText(child);
                continue;
            }
            if (child.getNodeName().equals("ENDPOINT")) {
                kbinfo.endpoint = ConfigReader.getText(child);
                continue;
            }
            if (child.getNodeName().equals("GRAPH")) {
                kbinfo.graph = ConfigReader.getText(child);
                continue;
            }
            if (child.getNodeName().equals("RESTRICTION")) {
                String restriction = ConfigReader.getText(child).trim();
                if (restriction.endsWith(".")) {
                    restriction = restriction.substring(0, restriction.length() - 1);
                }
                kbinfo.restrictions.add(restriction);
                continue;
            }
            if (child.getNodeName().equals("PROPERTY")) {
                String property = ConfigReader.getText(child);
                String function = "";
                String propertyLabel = "";
                String propertyRename = "";
                if (!property.contains(RENAME) && !property.contains(AS)) {
                    propertyLabel = property;
                    propertyRename = property;
                } else if (!property.contains(RENAME) && property.contains(AS)) {
                    propertyRename = propertyLabel = property.substring(0, property.indexOf(AS));
                    function = property.substring(property.indexOf(AS) + AS.length(), property.length());
                } else if (!property.contains(AS) && property.contains(RENAME)) {
                    propertyLabel = property.substring(0, property.indexOf(AS));
                    propertyRename = property.substring(property.indexOf(AS) + AS.length(), property.length());
                } else {
                    propertyLabel = property.substring(0, property.indexOf(AS));
                    function = property.substring(property.indexOf(AS) + AS.length(), property.indexOf(RENAME));
                    propertyRename = property.substring(property.indexOf(RENAME) + RENAME.length(), property.length());
                }
                if (!kbinfo.functions.containsKey(propertyLabel)) {
                    kbinfo.functions.put(propertyLabel, new HashMap());
                }
                kbinfo.functions.get(propertyLabel).put(propertyRename, function);
                if (kbinfo.properties.contains(propertyLabel)) continue;
                kbinfo.properties.add(propertyLabel);
                continue;
            }
            if (child.getNodeName().equals("PAGESIZE")) {
                kbinfo.pageSize = Integer.parseInt(ConfigReader.getText(child));
                continue;
            }
            if (child.getNodeName().equals("VAR")) {
                kbinfo.var = ConfigReader.getText(child);
                continue;
            }
            if (!child.getNodeName().equals("TYPE")) continue;
            kbinfo.type = ConfigReader.getText(child).toLowerCase();
        }
        kbinfo.prefixes = this.prefixes;
    }

    public boolean validateAndRead(InputStream input, String filePath) {
        DtdChecker dtdChecker = new DtdChecker();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(dtdChecker);
            Document xmlDocument = builder.parse(input);
            if (dtdChecker.valid) {
                String file;
                NodeList children;
                int i;
                this.sourceInfo = new KBInfo();
                this.targetInfo = new KBInfo();
                NodeList list = xmlDocument.getElementsByTagName("PREFIX");
                String namespace = "";
                String label = "";
                for (i = 0; i < list.getLength(); ++i) {
                    children = list.item(i).getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node child = children.item(j);
                        if (child.getNodeName().equals("NAMESPACE")) {
                            namespace = ConfigReader.getText(child);
                            continue;
                        }
                        if (!child.getNodeName().equals("LABEL")) continue;
                        label = ConfigReader.getText(child);
                    }
                    this.prefixes.put(label, namespace);
                }
                list = xmlDocument.getElementsByTagName("SOURCE");
                children = list.item(0).getChildNodes();
                this.processKBDescription("SOURCE", children);
                this.logger.info((Object)("Source = " + this.sourceInfo));
                list = xmlDocument.getElementsByTagName("TARGET");
                children = list.item(0).getChildNodes();
                this.processKBDescription("TARGET", children);
                this.logger.info((Object)("Target = " + this.targetInfo));
                list = xmlDocument.getElementsByTagName("METRIC");
                this.metricExpression = ConfigReader.getText(list.item(0));
                list = xmlDocument.getElementsByTagName("EXEMPLARS");
                if (list.getLength() > 0) {
                    this.exemplars = Integer.parseInt(ConfigReader.getText(list.item(0)));
                }
                list = xmlDocument.getElementsByTagName("ACCEPTANCE");
                children = list.item(0).getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeName().equals("THRESHOLD")) {
                        this.acceptanceThreshold = Double.parseDouble(ConfigReader.getText(child));
                        continue;
                    }
                    if (child.getNodeName().equals("FILE")) {
                        this.acceptanceFile = file = ConfigReader.getText(child);
                        continue;
                    }
                    if (!child.getNodeName().equals("RELATION")) continue;
                    this.acceptanceRelation = ConfigReader.getText(child);
                }
                list = xmlDocument.getElementsByTagName("REVIEW");
                children = list.item(0).getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    if (child.getNodeName().equals("THRESHOLD")) {
                        this.verificationThreshold = Double.parseDouble(ConfigReader.getText(child));
                        continue;
                    }
                    if (child.getNodeName().equals("FILE")) {
                        this.verificationFile = file = ConfigReader.getText(child);
                        continue;
                    }
                    if (!child.getNodeName().equals("RELATION")) continue;
                    this.verificationRelation = ConfigReader.getText(child);
                }
                if (list.getLength() > 0) {
                    list = xmlDocument.getElementsByTagName("EXECUTION");
                    children = list.item(0).getChildNodes();
                    this.executionPlan = ConfigReader.getText(list.item(0));
                }
                if ((list = xmlDocument.getElementsByTagName("GRANULARITY")).getLength() > 0) {
                    children = list.item(0).getChildNodes();
                    this.granularity = Integer.parseInt(ConfigReader.getText(list.item(0)));
                }
                if ((list = xmlDocument.getElementsByTagName("OUTPUT")).getLength() > 0) {
                    children = list.item(0).getChildNodes();
                    this.outputFormat = ConfigReader.getText(list.item(0));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
            e.printStackTrace();
            this.logger.warn((Object)"Some values were not set. Crossing my fingers and using defaults.");
        }
        return dtdChecker.valid;
    }

    public static String getText(Node node) {
        short type = node.getNodeType();
        if (type == 8 || type == 7) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        String value = node.getNodeValue();
        if (value != null) {
            text.append(value);
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                text.append(ConfigReader.getText(child));
            }
        }
        return text.toString();
    }

    public boolean validateAndRead(String filePath) {
        try {
            FileInputStream input = new FileInputStream(filePath);
            return this.validateAndRead(input, filePath);
        }
        catch (FileNotFoundException e) {
            this.logger.warn((Object)e.getMessage());
            e.printStackTrace();
            this.logger.warn((Object)"Some values were not set. Crossing my fingers and using defaults.");
            return false;
        }
    }

    public KBInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public KBInfo getTargetInfo() {
        return this.targetInfo;
    }

    public static void main(String[] args) {
        ConfigReader cr = new ConfigReader();
        String file = "Release_Examples/dblp-semanticwebresearcher.xml";
        cr.validateAndRead(file);
    }
}

