/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.util;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.genetics.util.Pair;
import de.uni_leipzig.simba.io.KBInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class PropertyMapping {
    Logger logger = Logger.getLogger((String)"Limes");
    private boolean aMatchWasSet = false;
    private Mapping propMapping = new Mapping();
    private Mapping numberProps = new Mapping();
    public List<Pair<String>> stringPropPairs = new ArrayList<Pair<String>>();
    public List<Pair<String>> numberPropPairs = new ArrayList<Pair<String>>();
    public HashSet<String> sourceStringProps = new HashSet();
    public HashSet<String> targetStringProps = new HashSet();
    public HashSet<String> sourceNumberProps = new HashSet();
    public HashSet<String> targetNumberProps = new HashSet();

    public void addStringPropertyMatch(String sourceProp, String targetProp) {
        if (!this.propMapping.contains(sourceProp, targetProp)) {
            this.propMapping.add(sourceProp, targetProp, 1.0);
            this.sourceStringProps.add(sourceProp);
            this.targetStringProps.add(targetProp);
            this.aMatchWasSet = true;
            Pair<String> pair = new Pair<String>(sourceProp, targetProp);
            if (!this.stringPropPairs.contains(pair)) {
                this.stringPropPairs.add(pair);
            }
        }
    }

    public void addNumberPropertyMatch(String sourceProp, String targetProp) {
        if (!this.numberProps.contains(sourceProp, targetProp)) {
            this.numberProps.add(sourceProp, targetProp, 1.0);
            this.sourceNumberProps.add(sourceProp);
            this.targetNumberProps.add(targetProp);
            this.aMatchWasSet = true;
            Pair<String> pair = new Pair<String>(sourceProp, targetProp);
            if (!this.numberPropPairs.contains(pair)) {
                this.numberPropPairs.add(pair);
            }
        }
    }

    public boolean isMatch(String sourceProp, String targetProp) {
        return this.propMapping.contains(sourceProp, targetProp) || this.numberProps.contains(sourceProp, targetProp);
    }

    public boolean isNumberProp(String name) {
        return this.numberProps.map.containsKey(name) || this.numberProps.map.containsValue(name);
    }

    public Mapping getStringPropMapping() {
        return this.propMapping;
    }

    public Mapping getNumberPropMapping() {
        return this.numberProps;
    }

    public boolean wasSet() {
        return this.aMatchWasSet;
    }

    public String toString() {
        String out = "STRING\n";
        out = out + this.propMapping.toString();
        out = out + "\nNUMBER\n";
        out = out + this.numberProps.toString();
        return out;
    }

    public void setDefault(KBInfo source, KBInfo target) {
        if (source.type != null && source.type.equalsIgnoreCase("csv") && target.type != null && target.type.equalsIgnoreCase("csv")) {
            int max = Math.min(source.properties.size(), target.properties.size());
            for (int i = 0; i < max; ++i) {
                this.addStringPropertyMatch(source.properties.get(i), target.properties.get(i));
            }
        } else {
            for (int i = 0; i < source.properties.size(); ++i) {
                for (int j = 0; j < target.properties.size(); ++j) {
                    this.addStringPropertyMatch(source.properties.get(i), target.properties.get(j));
                }
            }
        }
    }
}

