/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.util;

import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class PropMapper {
    public static PropertyMapping getPropertyMapping(String configFile) {
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        return PropMapper.getPropertyMapping(cR, configFile);
    }

    public static PropertyMapping getPropertyMapping(ConfigReader cR, String name) {
        PropertyMapping pM = new PropertyMapping();
        if (!name.substring(name.lastIndexOf("/") + 1).startsWith("dbpedia-linkedmdb") && !name.substring(name.lastIndexOf("/") + 1).startsWith("dailymed-drugbank")) {
            int max = Math.max(cR.sourceInfo.properties.size(), cR.targetInfo.properties.size()) - 1;
            for (int i = 0; i < max; ++i) {
                pM.addStringPropertyMatch(cR.sourceInfo.properties.get(i), cR.targetInfo.properties.get(i));
            }
            pM.addNumberPropertyMatch(cR.sourceInfo.properties.get(max), cR.targetInfo.properties.get(max));
        } else {
            int max = Math.max(cR.sourceInfo.properties.size(), cR.targetInfo.properties.size() - 1);
            for (int i = 0; i < max; ++i) {
                pM.addStringPropertyMatch(cR.sourceInfo.properties.get(i), cR.targetInfo.properties.get(i));
            }
        }
        System.out.println(pM);
        return pM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PropertyMapping getPropertyMappingFromFile(String folder, String name) {
        if (name.indexOf("/") > 0) {
            name = name.substring(name.lastIndexOf("/"));
        }
        String filename = name.substring(0, name.lastIndexOf("."));
        filename = filename + "propertymatch";
        PropertyMapping pM = new PropertyMapping();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(folder + filename));
            String s = reader.readLine();
            while (s != null) {
                if (s.length() > 0) {
                    String[] split = s.split("\t");
                    if (split[2].equalsIgnoreCase("number")) {
                        pM.addNumberPropertyMatch(split[0], split[1]);
                    } else {
                        pM.addStringPropertyMatch(split[0], split[1]);
                    }
                    s = reader.readLine();
                    continue;
                }
                break;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return pM;
        }
    }
}

