/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.selfconfig;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.core.PseudoFMeasureFitnessFunction;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.selfconfig.GeneticSelfConfigurator;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import java.util.HashMap;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicGeneticSelfConfigurator
implements GeneticSelfConfigurator {
    int pop;
    int gens;
    KBInfo sInfo;
    KBInfo tInfo;
    Cache sC;
    Cache tC;
    double beta = 1.0;
    float mutation = 0.4f;
    float crossover = 0.4f;
    float reproduction = 0.5f;
    PropertyMapping propMapping;
    PseudoMeasures measure;
    PseudoFMeasureFitnessFunction fitness;
    Mapping bestMapping = new Mapping();

    @Override
    public Metric learn(HashMap<String, Object> parameters) throws InvalidConfigurationException {
        this.setParams(parameters);
        LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(this.sInfo, this.tInfo, this.propMapping);
        config.setCrossoverProb(this.crossover);
        config.setMutationProb(this.mutation);
        config.setReproductionProb(this.reproduction);
        config.setPopulationSize(this.pop);
        config.setPreservFittestIndividual(true);
        this.fitness = PseudoFMeasureFitnessFunction.getInstance(config, this.measure, this.sC, this.tC);
        this.fitness.setBeta(this.beta);
        config.setFitnessFunction(this.fitness);
        ExpressionProblem gpP = new ExpressionProblem(config);
        GPGenotype gp = gpP.create();
        for (int gen = 1; gen <= this.gens; ++gen) {
            System.out.println("Running gen:" + gen);
            gp.evolve();
            GPPopulation pop = gp.getGPPopulation();
            for (int i = 0; i < pop.getPopSize(); ++i) {
                System.out.println(">>" + Metric.getMetric(pop.getGPProgram(i)));
            }
        }
        return this.getFittest(gp);
    }

    private Metric getFittest(GPGenotype gp) {
        IGPProgram fittest = this.determinFittest(gp);
        if (fittest != null) {
            Metric metric = Metric.getMetric(fittest);
            this.bestMapping = this.fitness.getMapping(metric.getExpression(), metric.getThreshold());
            return metric;
        }
        return null;
    }

    private IGPProgram determinFittest(GPGenotype gp) {
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        IGPProgram[] bests = new IGPProgram[]{gp.getFittestProgramComputed(), pop.determineFittestProgram(), gp.getAllTimeBest(), pop.getGPProgram(0)};
        IGPProgram bestHere = null;
        double fittest = Double.MAX_VALUE;
        for (IGPProgram p : bests) {
            double fitM;
            if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
            fittest = fitM;
            bestHere = p;
        }
        return bestHere;
    }

    @Override
    public Mapping getMapping() {
        return this.bestMapping;
    }

    private boolean setParams(HashMap<String, Object> params) {
        this.sInfo = (KBInfo)params.get("sourceInfo");
        this.tInfo = (KBInfo)params.get("targetInfo");
        this.pop = (Integer)params.get("populationSize");
        this.gens = (Integer)params.get("generations");
        this.sC = (Cache)params.get("sourceCache");
        this.tC = (Cache)params.get("targetCache");
        this.propMapping = (PropertyMapping)params.get("propertyMapping");
        this.measure = (PseudoMeasures)params.get("measure");
        if (params.containsKey("mutationRate")) {
            this.mutation = ((Float)params.get("mutationRate")).floatValue();
        }
        if (params.containsKey("crossOverRate")) {
            this.crossover = ((Float)params.get("crossOverRate")).floatValue();
        }
        if (params.containsKey("beta")) {
            this.beta = (Double)params.get("beta");
        }
        return true;
    }

    public static void main(String[] args) {
        HashMap<String, Object> param = DataSetChooser.getRestaurant();
        HashMap<String, Object> params = new HashMap<String, Object>();
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead("" + param.get("basefolder") + param.get("config"));
        System.out.println("" + param.get("basefolder") + param.get("config"));
        params.put("sourceInfo", cR.sourceInfo);
        params.put("targetInfo", cR.targetInfo);
        params.put("sourceCache", param.get("sourcecache"));
        params.put("targetCache", param.get("targetcache"));
        params.put("propertyMapping", param.get("propertymapping"));
        params.put("beta", 1.0);
        params.put("generations", 100);
        params.put("populationSize", 10);
        params.put("crossOverRate", Float.valueOf(0.4f));
        params.put("mutationRate", Float.valueOf(0.4f));
        params.put("measure", new PseudoMeasures());
        BasicGeneticSelfConfigurator configer = new BasicGeneticSelfConfigurator();
        try {
            Metric m = configer.learn(params);
            Mapping map = configer.getMapping();
            System.out.println(m);
            System.out.println(map.size());
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

