/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.learner;

import cern.colt.function.DoubleDoubleFunction;
import cern.colt.function.DoubleFunction;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.genetics.util.Pair;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.measures.string.CosineMeasure;
import de.uni_leipzig.simba.measures.string.JaccardMeasure;
import de.uni_leipzig.simba.measures.string.Levenshtein;
import de.uni_leipzig.simba.measures.string.OverlapMeasure;
import de.uni_leipzig.simba.measures.string.QGramSimilarity;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeightDecayCorrelation {
    private HashMap<String, StringMeasure> measures;
    private DenseDoubleMatrix2D adjacenceMatrix;
    private DenseDoubleMatrix1D activationVector;
    private int maxProperties;
    private HashMap<Pair<String>, StringMeasure> propMeasureMap;
    private final Logger log = Logger.getLogger(WeightDecayCorrelation.class);
    private HybridCache sourceCache;
    private HybridCache targetCache;

    public WeightDecayCorrelation(KBInfo source, KBInfo target, String metric) {
        this(source, target, metric, 2);
    }

    private WeightDecayCorrelation() {
    }

    public WeightDecayCorrelation(KBInfo source, KBInfo target, String metric, int maxPropertyCount) {
        this.log.setLevel(Level.INFO);
        this.measures = new HashMap();
        this.measures.put("cosine", new CosineMeasure());
        this.measures.put("jaccard", new JaccardMeasure());
        this.measures.put("levenshtein", new Levenshtein());
        this.measures.put("overlap", new OverlapMeasure());
        this.measures.put("qgrams", new QGramSimilarity());
        this.maxProperties = maxPropertyCount;
        this.propMeasureMap = this.getStringMeasures(metric);
        this.log.info((Object)metric);
        this.sourceCache = HybridCache.getData(source);
        this.targetCache = HybridCache.getData(target);
    }

    private HashMap<Pair<String>, StringMeasure> getStringMeasures(String metric) {
        HashMap<Pair<String>, StringMeasure> measureMap = new HashMap<Pair<String>, StringMeasure>();
        HashMap trimedMeasureMap = new HashMap();
        Pattern propP = Pattern.compile("\\((.){3,}?,(.){3,}?\\)");
        for (String measure : this.measures.keySet()) {
            int pos;
            String copy = metric.toLowerCase();
            do {
                Matcher m;
                if ((pos = copy.lastIndexOf(measure)) == -1 || !(m = propP.matcher(copy.substring(pos + measure.length()))).find()) continue;
                String simPart = m.group();
                simPart = simPart.replaceAll("\\(|\\)", "");
                String[] props = simPart.split(",");
                Pair<String> p = new Pair<String>(props[0].substring(props[0].indexOf(".") + 1), props[1].substring(props[1].indexOf(".") + 1));
                measureMap.put(p, this.measures.get(measure));
                copy = copy.substring(0, pos);
            } while (pos != -1);
        }
        int propertyCount = 0;
        for (Map.Entry e : measureMap.entrySet()) {
            trimedMeasureMap.put(e.getKey(), e.getValue());
            if (++propertyCount < this.maxProperties) continue;
            break;
        }
        return measureMap;
    }

    private HashMap<Integer, HashMap<String, Double>> initSimilarityCache(List<Triple> triples) {
        HashMap<Integer, HashMap<String, Double>> cache = new HashMap<Integer, HashMap<String, Double>>();
        for (Triple t : triples) {
            HashMap<String, Double> measures = cache.get(t.hashCode());
            if (measures == null) {
                measures = new HashMap();
                cache.put(t.hashCode(), measures);
            }
            Instance source = this.sourceCache.getInstance(t.getSourceUri());
            Instance target = this.targetCache.getInstance(t.getTargetUri());
            for (Pair<String> pair : this.propMeasureMap.keySet()) {
                Double similarity = this.propMeasureMap.get(pair).getSimilarity(source, target, (String)pair.a, (String)pair.b);
                measures.put(pair.toString(), similarity);
            }
        }
        return cache;
    }

    private double calculateDistance(Triple t1, Triple t2, HashMap<Integer, HashMap<String, Double>> similarityCache) {
        double simT1 = 0.0;
        double simT2 = 0.0;
        double squareDiff = 0.0;
        double signT1 = (double)t1.getSimilarity() < 0.5 ? -1.0 : 1.0;
        double signT2 = (double)t2.getSimilarity() < 0.5 ? -1.0 : 1.0;
        for (Pair<String> pair : this.propMeasureMap.keySet()) {
            simT1 = similarityCache.get(t1.hashCode()).get(pair.toString());
            simT2 = similarityCache.get(t2.hashCode()).get(pair.toString());
            squareDiff += Math.pow(signT1 * (1.0 - simT1) - signT2 * (1.0 - simT2), 2.0);
        }
        return 1.0 / (1.0 + Math.sqrt(squareDiff));
    }

    private void initSimilarityGraph(List<Triple> tripleList) {
        this.adjacenceMatrix = new DenseDoubleMatrix2D(tripleList.size(), tripleList.size());
        this.activationVector = new DenseDoubleMatrix1D(tripleList.size());
        HashMap<Integer, HashMap<String, Double>> cache = this.initSimilarityCache(tripleList);
        for (int i = 0; i < tripleList.size(); ++i) {
            double distanceToThres = Math.abs((double)tripleList.get(i).getSimilarity() - 0.5);
            this.activationVector.set(i, 1.0 - distanceToThres);
            for (int j = i; j < tripleList.size(); ++j) {
                double sim = i != j ? this.calculateDistance(tripleList.get(i), tripleList.get(j), cache) : 0.0;
                this.adjacenceMatrix.set(i, j, sim);
                this.adjacenceMatrix.set(j, i, sim);
            }
        }
    }

    private double getMax() {
        double max = 0.0;
        for (double value : this.activationVector.elements) {
            if (!(value > max)) continue;
            max = value;
        }
        return max;
    }

    private void calculation(int iteration, double decreaseExponent) {
        this.log.info((Object)"start weight Decay correlation");
        for (int currentIteration = 0; currentIteration < iteration; ++currentIteration) {
            DenseDoubleMatrix1D product = new DenseDoubleMatrix1D(this.activationVector.size);
            this.adjacenceMatrix.zMult((DoubleMatrix1D)this.activationVector, (DoubleMatrix1D)product);
            this.activationVector = (DenseDoubleMatrix1D)this.activationVector.assign((DoubleMatrix1D)product, (DoubleDoubleFunction)PlusMult.plusMult((double)1.0));
            this.activationVector.assign(new DoubleFunction(){
                double max;
                {
                    this.max = WeightDecayCorrelation.this.getMax();
                }

                public double apply(double arg0) {
                    return arg0 / this.max;
                }
            });
            this.adjacenceMatrix.assign(Functions.pow((double)decreaseExponent));
        }
        this.log.info((Object)this.adjacenceMatrix.toString());
        this.log.info((Object)this.activationVector.toString());
        this.log.info((Object)"end weight Decay correlation");
    }

    public List<Triple> getDisimilarMappings(List<Triple> tripleList, int trainingDataSize, double decreaseExponent) {
        ArrayList<Triple> list = new ArrayList<Triple>();
        if (tripleList.size() < trainingDataSize) {
            int toIndex = tripleList.size();
            return tripleList.subList(0, toIndex);
        }
        ArrayList<Triple> trimmedInitList = new ArrayList<Triple>();
        Collections.sort(tripleList, new TripleComparator());
        trimmedInitList.addAll(tripleList.subList(0, Math.round((float)tripleList.size() / 2.0f)));
        this.initSimilarityGraph(trimmedInitList);
        this.calculation(10, decreaseExponent);
        this.log.info((Object)this.activationVector.toString());
        TreeMap<Double, ArrayList<Integer>> sortedActivation = new TreeMap<Double, ArrayList<Integer>>();
        for (int i = 0; i < this.activationVector.size; ++i) {
            ArrayList<Integer> activateList = (ArrayList<Integer>)sortedActivation.get(this.activationVector.get(i));
            if (activateList == null) {
                activateList = new ArrayList<Integer>();
                sortedActivation.put(this.activationVector.get(i), activateList);
            }
            activateList.add(i);
        }
        int elementCount = 0;
        Double maxActivation = (Double)sortedActivation.lastKey();
        while (maxActivation != null && elementCount < trainingDataSize) {
            List triples = (List)sortedActivation.get(maxActivation);
            Iterator i$ = triples.iterator();
            while (i$.hasNext()) {
                int triple = (Integer)i$.next();
                if (elementCount >= trainingDataSize) break;
                list.add((Triple)trimmedInitList.get(triple));
                ++elementCount;
            }
            maxActivation = sortedActivation.lowerKey(maxActivation);
        }
        return list;
    }

    public void setMaxProperties(int maxProperties) {
        this.maxProperties = maxProperties;
    }

    public int getMaxProperties() {
        return this.maxProperties;
    }

    public static void main(String[] args) {
        DenseDoubleMatrix2D matrix;
        WeightDecayCorrelation cor = new WeightDecayCorrelation();
        double[][] values = new double[][]{{0.0, 0.25, 0.5, 0.0}, {0.25, 0.0, 0.5, 0.5}, {0.5, 0.5, 0.0, 0.25}, {0.0, 0.5, 0.25, 0.0}};
        cor.adjacenceMatrix = matrix = new DenseDoubleMatrix2D((double[][])values);
        cor.activationVector = new DenseDoubleMatrix1D(new double[]{0.9, 0.8, 0.9, 0.8});
        cor.calculation(3, 2.0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TripleComparator
    implements Comparator<Triple> {
        private TripleComparator() {
        }

        @Override
        public int compare(Triple o1, Triple o2) {
            Float sim1 = Float.valueOf(o1.getSimilarity());
            Float sim2 = Float.valueOf(o2.getSimilarity());
            return Double.valueOf(Math.abs((double)sim1.floatValue() - 0.5)).compareTo(Math.abs((double)sim2.floatValue() - 0.5));
        }
    }
}

