/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.learner;

import de.uni_leipzig.gk.cluster.BorderFlowHard;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.genetics.util.Pair;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.measures.string.CosineMeasure;
import de.uni_leipzig.simba.measures.string.JaccardMeasure;
import de.uni_leipzig.simba.measures.string.Levenshtein;
import de.uni_leipzig.simba.measures.string.OverlapMeasure;
import de.uni_leipzig.simba.measures.string.QGramSimilarity;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import de.uni_leipzig.simba.measures.string.TrigramMeasure;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingCorrelation {
    public static final Logger log = Logger.getLogger(MappingCorrelation.class);
    public static final int DEFAULT_MAX_PROP = 2;
    private BorderFlowHard clustering;
    private String metric;
    private KBInfo source;
    private KBInfo target;
    private double similarThreshold;
    private HashMap<String, StringMeasure> measures;
    private HybridCache sourceCache;
    private HybridCache targetCache;
    private int maxProperties;
    private HashMap<Pair<String>, StringMeasure> propMeasureMap;
    private static final String CLUSTER_FILE = "cluster.txt";

    public MappingCorrelation(KBInfo source, KBInfo target, String metric) {
        this(source, target, metric, 2);
    }

    public MappingCorrelation(KBInfo source, KBInfo target, String metric, int maxProperties) {
        this.source = source;
        this.target = target;
        this.metric = metric;
        this.measures = new HashMap();
        this.measures.put("cosine", new CosineMeasure());
        this.measures.put("jaccard", new JaccardMeasure());
        this.measures.put("levenshtein", new Levenshtein());
        this.measures.put("overlap", new OverlapMeasure());
        this.measures.put("qgrams", new QGramSimilarity());
        this.measures.put("trigrams", new TrigramMeasure());
        this.maxProperties = maxProperties;
        this.propMeasureMap = this.getStringMeasures(metric);
        log.info((Object)this.propMeasureMap.toString());
        this.sourceCache = HybridCache.getData(source);
        this.targetCache = HybridCache.getData(target);
    }

    public List<Triple> getDisimilarMappings(List<Triple> tripleList, int trainingDataSize, int edgeCountPerNode) {
        List<Triple> returnList = null;
        log.info((Object)("start similarity  calculation for " + tripleList.size() + " triples"));
        if (tripleList.size() / 2 < trainingDataSize) {
            log.info((Object)"triple list too small for clustering");
            int toIndex = tripleList.size() < trainingDataSize ? tripleList.size() : trainingDataSize;
            this.propMeasureMap.clear();
            return tripleList.subList(0, toIndex);
        }
        TreeMap<Float, List<Triple>> tripleMap = this.initInformativeTripleMap(tripleList);
        int totalElements = Math.round((float)tripleList.size() * 0.15f);
        log.info((Object)("number of triples for clustering " + totalElements));
        List<Triple> positiveTriples = this.initListForClustering(false, tripleMap, totalElements);
        List<Triple> negativeTriples = this.initListForClustering(true, tripleMap, totalElements);
        try {
            ArrayList<String> nodes;
            HashMap<Integer, List<String>> clusterPositiveMap = new HashMap<Integer, List<String>>();
            HashMap<String, Integer> reversePositiveMap = new HashMap<String, Integer>();
            HashMap<Integer, List<String>> clusterNegativeMap = new HashMap<Integer, List<String>>();
            HashMap<String, Integer> reverseNegativeMap = new HashMap<String, Integer>();
            Map<Set<String>, Set<String>> clusterPos = this.clustering(positiveTriples, edgeCountPerNode);
            Map<Set<String>, Set<String>> clusterNeg = this.clustering(negativeTriples, edgeCountPerNode);
            int id = 0;
            for (Set<String> cluster : clusterPos.keySet()) {
                nodes = new ArrayList<String>();
                nodes.addAll(cluster);
                clusterPositiveMap.put(id, nodes);
                for (String node : nodes) {
                    reversePositiveMap.put(node, id);
                }
                ++id;
            }
            for (Set<String> cluster : clusterNeg.keySet()) {
                nodes = new ArrayList();
                nodes.addAll(cluster);
                clusterNegativeMap.put(id, nodes);
                for (String node : nodes) {
                    reverseNegativeMap.put(node, id);
                }
                ++id;
            }
            ArrayList<Triple> initList = new ArrayList<Triple>();
            initList.addAll(tripleList);
            if (clusterPos.size() == 0 && clusterNeg.size() == 0) {
                int toIndex = initList.size() < trainingDataSize ? initList.size() : trainingDataSize;
                log.info((Object)("no Cluster:" + initList.subList(0, toIndex).toString()));
                return initList.subList(0, toIndex);
            }
            returnList = this.initOracleList(initList, trainingDataSize, reversePositiveMap, reverseNegativeMap, clusterPositiveMap, clusterNegativeMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        log.info((Object)("count of returned elements after clustering:" + returnList.size()));
        log.info((Object)"end similarity calculation...");
        return returnList;
    }

    private TreeMap<Float, List<Triple>> initInformativeTripleMap(List<Triple> tripleList) {
        TreeMap<Float, List<Triple>> tripleMap = new TreeMap<Float, List<Triple>>();
        for (Triple t : tripleList) {
            List<Triple> triples = tripleMap.get(Float.valueOf(t.getSimilarity()));
            if (triples == null) {
                triples = new ArrayList<Triple>();
                tripleMap.put(Float.valueOf(t.getSimilarity()), triples);
            }
            triples.add(t);
        }
        return tripleMap;
    }

    private List<Triple> initListForClustering(boolean isNegative, TreeMap<Float, List<Triple>> tripleMap, int totalElements) {
        Float currentKey = isNegative ? tripleMap.lowerKey(Float.valueOf(0.5f)) : tripleMap.ceilingKey(Float.valueOf(0.5f));
        int elementCount = 0;
        ArrayList<Triple> listForClustering = new ArrayList<Triple>();
        do {
            if (currentKey == null) continue;
            List<Triple> list = tripleMap.get(currentKey);
            elementCount += list.size();
            listForClustering.addAll(list);
            currentKey = isNegative ? tripleMap.lowerKey(currentKey) : tripleMap.higherKey(currentKey);
        } while (elementCount < totalElements && currentKey != null);
        return listForClustering;
    }

    private double calculateDistance(Triple t1, Triple t2, HashMap<Integer, HashMap<String, Double>> similarityCache) {
        double simT1 = 0.0;
        double simT2 = 0.0;
        double squareDiff = 0.0;
        for (Pair<String> pair : this.propMeasureMap.keySet()) {
            simT1 = similarityCache.get(t1.hashCode()).get(pair.toString());
            simT2 = similarityCache.get(t2.hashCode()).get(pair.toString());
            squareDiff += Math.pow(1.0 - simT1 - (1.0 - simT2), 2.0);
        }
        return 1.0 / (1.0 + Math.sqrt(squareDiff));
    }

    private Map<Set<String>, Set<String>> clustering(List<Triple> tripleList, int edgesPerNode) throws IOException {
        ArrayList<Integer> adjNodes;
        log.info((Object)("init Cluster File" + tripleList.size()));
        HashMap<Integer, HashMap<String, Double>> similarityCache = this.initSimilarityCache(tripleList);
        HashMap nodes = new HashMap();
        for (int i = 0; i < tripleList.size(); ++i) {
            for (int j = i; j < tripleList.size(); ++j) {
                if (i == j) continue;
                double sim = this.calculateDistance(tripleList.get(i), tripleList.get(j), similarityCache);
                Integer t1 = tripleList.get(i).hashCode();
                Integer t2 = tripleList.get(j).hashCode();
                TreeMap<Double, ArrayList<Integer>> edges = (TreeMap<Double, ArrayList<Integer>>)nodes.get(t1);
                if (edges == null) {
                    edges = new TreeMap<Double, ArrayList<Integer>>();
                    nodes.put(t1, edges);
                }
                if ((adjNodes = (List)edges.get(sim)) == null) {
                    adjNodes = new ArrayList<Integer>();
                    edges.put(sim, adjNodes);
                }
                adjNodes.add(t2);
            }
        }
        log.info((Object)"similarity calculation ready");
        int edgelog = 0;
        FileWriter fw = new FileWriter(CLUSTER_FILE);
        for (Integer node : nodes.keySet()) {
            TreeMap edges = (TreeMap)nodes.get(node);
            if (edges == null) continue;
            Double currentKey = (Double)edges.lastKey();
            int edgeCount = 0;
            if (currentKey == null) continue;
            do {
                adjNodes = (ArrayList<Integer>)edges.get(currentKey);
                for (Integer adjNode : adjNodes) {
                    if (edgeCount == edgesPerNode) break;
                    fw.append(node + "\t" + adjNode + "\t" + currentKey + System.getProperty("line.separator"));
                    ++edgelog;
                    ++edgeCount;
                }
                currentKey = edges.lowerKey(currentKey);
            } while (edgeCount < edgesPerNode && currentKey != null);
        }
        log.info((Object)("edges in graph" + edgelog));
        nodes.clear();
        fw.close();
        this.clustering = new BorderFlowHard(CLUSTER_FILE);
        log.info((Object)"start clustering mappings");
        this.clustering.hardPartitioning = true;
        Map clusters = this.clustering.cluster(1.0, true, true, false);
        return clusters;
    }

    private HashMap<Integer, HashMap<String, Double>> initSimilarityCache(List<Triple> triples) {
        HashMap<Integer, HashMap<String, Double>> cache = new HashMap<Integer, HashMap<String, Double>>();
        for (Triple t : triples) {
            HashMap<String, Double> measures = cache.get(t.hashCode());
            if (measures == null) {
                measures = new HashMap();
                cache.put(t.hashCode(), measures);
            }
            Instance source = this.sourceCache.getInstance(t.getSourceUri());
            Instance target = this.targetCache.getInstance(t.getTargetUri());
            if (source == null) {
                log.error((Object)("no instance found in source cache for URI: " + t.getSourceUri()));
            }
            if (target == null) {
                log.error((Object)("no instance found in target cache for URI: " + t.getTargetUri()));
            }
            for (Pair<String> pair : this.propMeasureMap.keySet()) {
                Double similarity = this.propMeasureMap.get(pair).getSimilarity(source, target, (String)pair.a, (String)pair.b);
                measures.put(pair.toString(), similarity);
            }
        }
        return cache;
    }

    private List<Triple> initOracleList(List<Triple> initList, int trainingDataSize, HashMap<String, Integer> reverseMap, HashMap<String, Integer> reverseNegativeMap, HashMap<Integer, List<String>> clusterMap, HashMap<Integer, List<String>> clusterNegativeMap) {
        Collections.sort(initList, new TripleComparator());
        ArrayList<Triple> tripleList = new ArrayList<Triple>();
        HashSet<Integer> visitPosCluster = new HashSet<Integer>();
        HashSet<Integer> visitNegCluster = new HashSet<Integer>();
        int counter = 0;
        for (int tripleId = 0; tripleId < initList.size() && counter != trainingDataSize; ++tripleId) {
            Triple t = initList.get(tripleId);
            if (visitPosCluster.contains(reverseMap.get(t.hashCode() + "")) || visitNegCluster.contains(reverseNegativeMap.get(t.hashCode() + ""))) continue;
            tripleList.add(initList.get(tripleId));
            Integer clusterId = reverseMap.containsKey(t.hashCode() + "") ? reverseMap.get(t.hashCode() + "") : reverseNegativeMap.get(t.hashCode() + "");
            ++counter;
            if (reverseMap.containsKey(t.hashCode() + "")) {
                visitPosCluster.add(clusterId);
                continue;
            }
            if (!reverseNegativeMap.containsKey(t.hashCode() + "")) continue;
            visitNegCluster.add(clusterId);
        }
        return tripleList;
    }

    private HashMap<Pair<String>, StringMeasure> getStringMeasures(String metric) {
        HashMap<Pair<String>, StringMeasure> measureMap = new HashMap<Pair<String>, StringMeasure>();
        HashMap<Pair<String>, StringMeasure> trimedMeasureMap = new HashMap<Pair<String>, StringMeasure>();
        Pattern propP = Pattern.compile("\\((.){3,}?,(.){3,}?\\)");
        for (String measure : this.measures.keySet()) {
            int pos;
            String copy = metric.toLowerCase();
            do {
                Matcher m;
                if ((pos = copy.lastIndexOf(measure)) == -1 || !(m = propP.matcher(copy.substring(pos + measure.length()))).find()) continue;
                String simPart = m.group();
                simPart = simPart.replaceAll("\\(|\\)", "");
                String[] props = simPart.split(",");
                Pair<String> p = new Pair<String>(props[0].substring(props[0].indexOf(".") + 1), props[1].substring(props[1].indexOf(".") + 1));
                log.info((Object)("identified Properties: " + props[0].substring(props[0].indexOf(".") + 1) + "  AND   " + props[1].substring(props[1].indexOf(".") + 1)));
                measureMap.put(p, this.measures.get(measure));
                copy = copy.substring(0, pos);
            } while (pos != -1);
        }
        int propertyCount = 0;
        for (Map.Entry e : measureMap.entrySet()) {
            trimedMeasureMap.put((Pair<String>)e.getKey(), (StringMeasure)e.getValue());
            if (++propertyCount < this.maxProperties) continue;
            break;
        }
        return trimedMeasureMap;
    }

    public String getMetric() {
        return this.metric;
    }

    public void setMetric(String metric) {
        this.metric = metric;
    }

    public KBInfo getSource() {
        return this.source;
    }

    public void setSource(KBInfo source) {
        this.source = source;
    }

    public KBInfo getTarget() {
        return this.target;
    }

    public void setTarget(KBInfo target) {
        this.target = target;
    }

    public void setSimilarThreshold(double similarThreshold) {
        this.similarThreshold = similarThreshold;
    }

    public double getSimilarThreshold() {
        return this.similarThreshold;
    }

    public void setMaxProperties(int maxProperties) {
        this.maxProperties = maxProperties;
    }

    public int getMaxProperties() {
        return this.maxProperties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TripleComparator
    implements Comparator<Triple> {
        private TripleComparator() {
        }

        @Override
        public int compare(Triple o1, Triple o2) {
            Float sim1 = Float.valueOf(o1.getSimilarity());
            Float sim2 = Float.valueOf(o2.getSimilarity());
            return Double.valueOf(Math.abs((double)sim1.floatValue() - 0.5)).compareTo(Math.abs((double)sim2.floatValue() - 0.5));
        }
    }
}

