/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.learner;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.learner.GeneticActiveLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearnerFactory;
import de.uni_leipzig.simba.genetics.learner.MappingCorrelation;
import de.uni_leipzig.simba.genetics.learner.WeightDecayCorrelation;
import de.uni_leipzig.simba.genetics.util.PropMapper;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;

public class GeneticCorrelationActiveLearner
extends GeneticActiveLearner {
    static boolean testClustering = true;
    public static final boolean CLUSTERING = true;
    public static final boolean WEIGHT_DECAY = false;

    public GeneticCorrelationActiveLearner() {
    }

    public GeneticCorrelationActiveLearner(boolean method) {
        testClustering = method;
    }

    protected Mapping getMappingForOutput(Mapping trainingData, ExpressionFitnessFunction fitness) {
        List<Triple> controversyMatches;
        this.pop.sortByFitness();
        HashSet<Metric> metrics = new HashSet<Metric>();
        LinkedList<Mapping> candidateMaps = new LinkedList<Mapping>();
        if (this.metric != null && this.metric.isValid()) {
            metrics.add(this.metric);
        }
        for (IGPProgram p : this.pop.getGPPrograms()) {
            Metric m = this.getMetric(p);
            if (m == null || !m.isValid() || metrics.contains(m)) continue;
            metrics.add(m);
        }
        if (metrics.size() <= 1) {
            return super.getMappingForOutput(trainingData, fitness);
        }
        logger.info((Object)("Getting " + metrics.size() + " full mappings to determine controversy matches..."));
        for (Metric m : metrics) {
            if (!m.isValid() || m.getExpression().indexOf("falseProp") != -1) continue;
            candidateMaps.add(fitness.getMapping(m.getExpression(), m.getThreshold(), true));
        }
        logger.info((Object)("Getting " + this.trainingDataSize + " controversy match candidates from " + candidateMaps.size() + " maps..."));
        String metric = fitness.getMetric(this.gp.getFittestProgram()).getExpression();
        if (testClustering) {
            logger.info((Object)"Starting clustering based approach");
            MappingCorrelation cor = new MappingCorrelation(this.source, this.target, metric);
            controversyMatches = cor.getDisimilarMappings(this.alDecider.getControversyCandidates(candidateMaps), this.trainingDataSize, 2);
        } else {
            logger.info((Object)"Starting weight decay based approach");
            WeightDecayCorrelation wdc = new WeightDecayCorrelation(this.source, this.target, metric);
            controversyMatches = wdc.getDisimilarMappings(this.alDecider.getControversyCandidates(candidateMaps), this.trainingDataSize, 2.0);
        }
        this.alDecider.retrieved.addAll(controversyMatches);
        logger.info((Object)"Calculation of new data to be evaluated is ready...");
        logger.info((Object)controversyMatches.toString());
        Mapping answer = new Mapping();
        for (Triple t : controversyMatches) {
            answer.add(t.getSourceUri(), t.getTargetUri(), t.getSimilarity());
        }
        return answer;
    }

    public static void main(String[] args) {
        String configFile = "Examples/GeneticEval/DBLP-Scholar.xml";
        Oracle o = OracleFactory.getOracle("Examples/GeneticEval/Datasets/DBLP-Scholar/DBLP-Scholar_perfectMapping.csv", "csv", "simple");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        int size = 10;
        PropertyMapping propMap = PropMapper.getPropertyMapping(configFile);
        LinkSpecificationLearner learner = LinkSpecificationLearnerFactory.getLinkSpecificationLearner("geneticactivecorrelationlearner");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("populationSize", 20);
        param.put("generations", 100);
        param.put("mutationRate", Float.valueOf(0.5f));
        param.put("preserveFittest", false);
        param.put("propertyMapping", propMap);
        param.put("trainingDataSize", size);
        param.put("granularity", 2);
        param.put("config", cR);
        try {
            learner.init(cR.getSourceInfo(), cR.getTargetInfo(), param);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Mapping answer = learner.learn(new Mapping());
        Mapping oracleAnswer = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
            for (Map.Entry<String, Double> entry : e1.getValue().entrySet()) {
                if (o.ask(e1.getKey(), entry.getKey())) {
                    oracleAnswer.add(e1.getKey(), entry.getKey(), 1.0);
                    continue;
                }
                oracleAnswer.add(e1.getKey(), entry.getKey(), 0.0);
            }
        }
        try {
            FileWriter fw = new FileWriter("DBLP-ACM-ClusterEval.txt");
            fw.append("cycle fMeasure" + System.getProperty("line.separator"));
            for (int cycle = 0; cycle < 5; ++cycle) {
                System.out.println("Performing learning cycle " + cycle);
                answer = learner.learn(oracleAnswer);
                logger.info((Object)answer.toString());
                Metric answerMetric = learner.terminate();
                if (answerMetric.isValid()) {
                    PRFComputer prfC = new PRFComputer();
                    double d = prfC.computePrecision(o.getMapping(), learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true));
                    System.out.println("Cycle " + cycle + " Best = " + answerMetric + "\n\tF-Score = " + d);
                    fw.append(cycle + " " + d + System.getProperty("line.separator"));
                } else {
                    Logger.getLogger((String)"Limes").warn((Object)"Method returned no valid metric!");
                }
                System.out.println("Gathering more data from user ... ");
                oracleAnswer = new Mapping();
                for (Map.Entry<String, Serializable> entry : answer.map.entrySet()) {
                    for (Map.Entry e2 : ((HashMap)entry.getValue()).entrySet()) {
                        if (o.ask(entry.getKey(), (String)e2.getKey())) {
                            oracleAnswer.add(entry.getKey(), (String)e2.getKey(), 1.0);
                            continue;
                        }
                        oracleAnswer.add(entry.getKey(), (String)e2.getKey(), 0.0);
                    }
                }
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

