/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.learner;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearnerFactory;
import de.uni_leipzig.simba.genetics.util.PropMapper;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.learning.oracle.oracle.SimpleOracle;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.GPProblem;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneticBatchLearner
implements LinkSpecificationLearner {
    static Logger logger = Logger.getLogger((String)"LIMES");
    protected int popSize;
    protected int gens;
    protected int granularity;
    protected int trainingDataSize;
    protected float mut;
    protected float crossoverRate;
    protected boolean preserveFittest;
    protected PropertyMapping propMap;
    protected Oracle o;
    protected LinkSpecGeneticLearnerConfig config;
    protected ExpressionFitnessFunction fitness;
    protected KBInfo source;
    protected KBInfo target;
    protected ConfigReader cR;
    protected GPProblem gpP;
    protected GPGenotype gp;
    protected IGPProgram allBest;
    Metric metric;
    LinkedList<IGPProgram> bestOfCycles = new LinkedList();

    @Override
    public void init(KBInfo source, KBInfo target, HashMap<String, Object> parameters) throws InvalidConfigurationException {
        this.source = source;
        this.target = target;
        this.popSize = (Integer)parameters.get("populationSize");
        this.gens = (Integer)parameters.get("generations");
        this.mut = ((Float)parameters.get("mutationRate")).floatValue();
        if (parameters.containsKey("crossoverRate")) {
            this.crossoverRate = ((Float)parameters.get("crossoverRate")).floatValue();
        }
        this.preserveFittest = (Boolean)parameters.get("preserveFittest");
        this.propMap = (PropertyMapping)parameters.get("propertyMapping");
        this.granularity = (Integer)parameters.get("granularity");
        this.trainingDataSize = (Integer)parameters.get("trainingDataSize");
        this.cR = (ConfigReader)parameters.get("config");
        this.setUp();
    }

    public static HashMap<String, Class> getParameters() {
        HashMap<String, Class> param = new HashMap<String, Class>();
        param.put("populationSize", Integer.TYPE);
        param.put("generations", Integer.TYPE);
        param.put("mutationRate", Float.TYPE);
        param.put("crossoverRate", Float.TYPE);
        param.put("preserveFittest", Boolean.TYPE);
        param.put("propertyMapping", PropertyMapping.class);
        param.put("trainingDataSize", Integer.TYPE);
        param.put("granularity", Integer.TYPE);
        param.put("config", ConfigReader.class);
        return param;
    }

    @Override
    public Mapping learn(Mapping trainingData) {
        if (trainingData == null || trainingData.size() == 0) {
            return this.getStartingData(this.fitness);
        }
        this.fillOracle(trainingData);
        this.fitness.trimKnowledgeBases(trainingData);
        this.fitness.setReferenceMapping(this.o.getMapping());
        try {
            this.gp = this.gpP.create();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        for (int gen = 0; gen < this.gens; ++gen) {
            this.gp.evolve();
            this.gp.calcFitness();
        }
        this.determineMetric();
        return this.getMappingForOutput(trainingData, this.fitness);
    }

    protected Mapping getMappingForOutput(Mapping trainingData, ExpressionFitnessFunction fitness) {
        logger.info((Object)"Getting Mapping for output");
        if (this.metric == null || !this.metric.isValid()) {
            return new Mapping();
        }
        logger.info((Object)"trying to get a full map");
        Mapping ret = new Mapping();
        Mapping all = fitness.getMapping(this.metric.getExpression(), this.metric.getThreshold(), true);
        for (Map.Entry<String, HashMap<String, Double>> e1 : all.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (ret.size() >= this.trainingDataSize) {
                    return ret;
                }
                if (trainingData.contains(e1.getKey(), e2.getKey())) continue;
                ret.add(e1.getKey(), e2.getKey(), e2.getValue());
            }
        }
        return ret;
    }

    @Override
    public Metric terminate() {
        for (IGPProgram p : this.bestOfCycles) {
            if (!(this.fitness.calculateRawFitness(p) < this.fitness.calculateRawFitness(this.allBest))) continue;
            this.allBest = p;
            this.metric = this.getMetric(p);
        }
        if (!this.metric.isValid()) {
            System.out.println("WARNING false solution.");
        }
        return this.metric;
    }

    protected void determineMetric() {
        this.allBest = this.gp.getAllTimeBest();
        try {
            this.metric = this.getMetric(this.allBest);
            if (!this.metric.isValid() || this.allBest.getFitnessValue() >= 1.0) {
                this.getBestPossibleSolution();
            } else {
                this.bestOfCycles.add(this.allBest);
            }
            logger.info((Object)("Fittest Program is set to: " + this.metric + " with a fitness value of " + this.allBest.getFitnessValue()));
        }
        catch (Exception e) {
            this.getBestPossibleSolution();
        }
    }

    protected void getBestPossibleSolution() {
        logger.info((Object)"The fittest propgram is no vaild solution. So we look for annother one.");
        GPPopulation pop = this.gp.getGPPopulation();
        pop.sortByFitness();
        Metric best = null;
        double fit = Double.MAX_VALUE;
        IGPProgram bestProg = null;
        for (IGPProgram p : pop.getGPPrograms()) {
            if (p == null || !(fit > p.getFitnessValue())) continue;
            try {
                fit = p.getFitnessValue();
                Metric mp = this.getMetric(p);
                if (!mp.isValid()) continue;
                best = mp;
                bestProg = p;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if (best != null && bestProg != null) {
            this.allBest = bestProg;
            this.metric = best;
            this.bestOfCycles.add(bestProg);
            logger.info((Object)("Fittest Program is set to: " + this.metric + " with a fitness value of " + this.allBest.getFitnessValue()));
        }
    }

    private Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    protected Mapping getStartingData(ExpressionFitnessFunction fitness) {
        if (this.cR != null && this.cR.metricExpression != null && this.cR.acceptanceThreshold >= 0.0 && this.cR.acceptanceThreshold <= 1.0) {
            return this.getTrainingDataFromInitialConfig(fitness);
        }
        HybridCache sC = fitness.getSourceCache();
        HybridCache tC = fitness.getTargetCache();
        Mapping m = new Mapping();
        logger.info((Object)"Get random initial training data.");
        sC.resetIterator();
        tC.resetIterator();
        while (m.size() < Math.max(10, this.trainingDataSize)) {
            Instance inst1 = sC.getNextInstance();
            Instance inst2 = tC.getNextInstance();
            if (inst1 == null || inst2 == null) continue;
            m.add(inst1.getUri(), inst2.getUri(), 0.0);
        }
        return m;
    }

    private Mapping getTrainingDataFromInitialConfig(ExpressionFitnessFunction fitness) {
        logger.info((Object)"Retrieving training data by initial config.");
        Mapping full = fitness.getMapping(this.cR.metricExpression, this.cR.acceptanceThreshold, true);
        if (full.size() == 0) {
            logger.warn((Object)("Initial training data retrieved with " + this.cR.metricExpression + " >= " + this.cR.acceptanceThreshold + " is empty!"));
            return this.getRandomTrainingData();
        }
        Mapping answer = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : full.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (answer.size() >= this.trainingDataSize) {
                    return answer;
                }
                if (!(e2.getValue() < 1.0)) continue;
                answer.add(e1.getKey(), e2.getKey(), e2.getValue());
            }
        }
        if (answer.size() == 0) {
            for (Map.Entry<String, HashMap<String, Double>> e1 : full.map.entrySet()) {
                for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                    if (answer.size() >= this.trainingDataSize) {
                        return answer;
                    }
                    if (!(e2.getValue() <= 1.0)) continue;
                    answer.add(e1.getKey(), e2.getKey(), e2.getValue());
                }
            }
        }
        return answer;
    }

    private Mapping getRandomTrainingData() {
        Mapping answer = new Mapping();
        for (int i = 0; i < this.trainingDataSize; ++i) {
            Instance i1 = this.fitness.getSourceCache().getNextInstance();
            Instance i2 = this.fitness.getTargetCache().getInstance(i1.getUri());
            if (i2 == null) {
                i2 = this.fitness.getTargetCache().getNextInstance();
            }
            answer.add(i1.getUri(), i2.getUri(), 0.5);
        }
        return answer;
    }

    private void setUp() throws InvalidConfigurationException {
        if (this.propMap == null) {
            this.propMap = new PropertyMapping();
        }
        if (!this.propMap.wasSet()) {
            logger.warn((Object)"No Property Mapping set we use a fallback solution.");
            if (this.cR == null) {
                this.propMap.setDefault(this.source, this.target);
            } else {
                this.propMap.setDefault(this.source, this.target);
            }
        }
        this.o = new SimpleOracle();
        this.o.loadData(new Mapping());
        this.config = new LinkSpecGeneticLearnerConfig(this.source, this.target, this.propMap);
        this.setUpFitness();
        this.config.setPopulationSize(this.popSize);
        this.config.setCrossoverProb(this.crossoverRate);
        this.config.setMutationProb(this.mut);
        this.config.setPreservFittestIndividual(this.preserveFittest);
        this.gpP = new ExpressionProblem(this.config);
        this.gp = this.gpP.create();
    }

    protected void setUpFitness() throws InvalidConfigurationException {
        Configuration.reset();
        this.fitness = ExpressionFitnessFunction.getInstance(this.config, this.o, "f-score", this.trainingDataSize);
        this.fitness.useFullCaches(true);
        this.fitness.useFScore();
        this.config.setFitnessFunction(this.fitness);
    }

    private void fillOracle(Mapping trainingData) {
        Mapping cachedMatches = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : trainingData.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (!(e2.getValue() > 0.0)) continue;
                cachedMatches.add(e1.getKey(), e2.getKey(), 1.0);
            }
        }
        this.o = new SimpleOracle();
        this.o.loadData(cachedMatches);
    }

    public static void main(String[] args) {
        String configFile = "Examples/GeneticEval/PublicationData.xml";
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        Oracle o = OracleFactory.getOracle("Examples/GeneticEval/Datasets/DBLP-ACM/DBLP-ACM_perfectMapping.csv", "csv", "simple");
        PropertyMapping propMap = PropMapper.getPropertyMapping(configFile);
        LinkSpecificationLearner learner = LinkSpecificationLearnerFactory.getLinkSpecificationLearner("geneticbatchlearner");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("populationSize", 20);
        param.put("generations", 100);
        param.put("mutationRate", Float.valueOf(0.5f));
        param.put("preserveFittest", true);
        param.put("propertyMapping", propMap);
        param.put("trainingDataSize", 50);
        param.put("granularity", 2);
        param.put("config", cR);
        try {
            learner.init(cR.getSourceInfo(), cR.getTargetInfo(), param);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Mapping answer = learner.learn(new Mapping());
        Mapping oracleAnswer = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (o.ask(e1.getKey(), e2.getKey())) {
                    oracleAnswer.add(e1.getKey(), e2.getKey(), 1.0);
                    continue;
                }
                oracleAnswer.add(e1.getKey(), e2.getKey(), 0.0);
            }
        }
        System.out.println(oracleAnswer);
        for (int cycle = 0; cycle < 10; ++cycle) {
            System.out.println("");
            learner.learn(oracleAnswer);
            logger.info((Object)("Learned Cycle " + cycle + " now terminating..."));
            Metric answerMetric = learner.terminate();
            PRFComputer prfC = new PRFComputer();
            Mapping instanceMap = learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true);
            Mapping oracleMap = o.getMapping();
            logger.info((Object)("Computing Mapping of instanceMap:" + instanceMap.size() + " and oracleMap" + oracleMap.size()));
            double fS = prfC.computePrecision(oracleMap, instanceMap);
            System.out.println("Cycle " + cycle + "  -  " + answerMetric);
            System.out.println("Cycle " + cycle + "  -  F-Score = " + fS);
        }
    }

    @Override
    public ExpressionFitnessFunction getFitnessFunction() {
        return this.fitness;
    }
}

