/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.learner;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ALDecider;
import de.uni_leipzig.simba.genetics.core.ALFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.learner.GeneticBatchLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearnerFactory;
import de.uni_leipzig.simba.genetics.util.PropMapper;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;

public class GeneticActiveLearner
extends GeneticBatchLearner
implements LinkSpecificationLearner {
    boolean started = false;
    ALFitnessFunction fitness;
    ALDecider alDecider = new ALDecider();
    Mapping trainingData = new Mapping();
    GPPopulation pop;

    protected void setUpFitness() throws InvalidConfigurationException {
        logger.info((Object)"Setting up fitness for active learning approach.");
        Configuration.reset();
        this.fitness = ALFitnessFunction.getInstance(this.config, this.o, "f-score", this.trainingDataSize);
        this.fitness.useFScore();
        this.config.setFitnessFunction(this.fitness);
    }

    public Mapping learn(Mapping trainingData) {
        if (!(this.started || trainingData != null && trainingData.size() != 0)) {
            logger.info((Object)"Get start data...");
            return this.getStartingData(this.fitness);
        }
        logger.info((Object)("filling with trainingData " + trainingData.size()));
        this.fillOracle(trainingData);
        if (!this.started || this.gp == null) {
            try {
                logger.info((Object)"Creating initial population");
                this.gp = this.gpP.create();
                this.started = true;
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            logger.info((Object)"Starting additional learning cycle.");
        }
        for (int gen = 0; gen < this.gens; ++gen) {
            this.gp.evolve();
            this.pop = this.gp.getGPPopulation();
            for (int i = 0; i < this.pop.getPopSize(); ++i) {
                System.out.println(">>" + Metric.getMetric(this.pop.getGPProgram(i)));
            }
            this.gp.calcFitness();
            this.pop = this.gp.getGPPopulation();
            if (this.gp.getFittestProgramComputed().getFitnessValue() != 0.0) continue;
            logger.info((Object)"Stopping evolution because we already discovered the best possible program");
            break;
        }
        System.out.println("Evolution finished ... ");
        this.determineMetric();
        return this.getMappingForOutput(trainingData, this.fitness);
    }

    protected Mapping getMappingForOutput(Mapping trainingData, ExpressionFitnessFunction fitness) {
        logger.info((Object)"Getting mappings for output");
        this.pop.sortByFitness();
        HashSet<Metric> metrics = new HashSet<Metric>();
        LinkedList<Mapping> candidateMaps = new LinkedList<Mapping>();
        if (this.metric != null && this.metric.isValid()) {
            metrics.add(this.metric);
        }
        for (IGPProgram p : this.pop.getGPPrograms()) {
            Metric m = this.getMetric(p);
            if (m == null || !m.isValid() || metrics.contains(m)) continue;
            metrics.add(m);
        }
        if (metrics.size() <= 1) {
            return super.getMappingForOutput(trainingData, fitness);
        }
        logger.info((Object)("Getting " + metrics.size() + " full mappings to determine controversy matches..."));
        for (Metric m : metrics) {
            if (!m.isValid() || m.getExpression().indexOf("falseProp") != -1) continue;
            candidateMaps.add(fitness.getMapping(m.getExpression(), m.getThreshold(), true));
        }
        logger.info((Object)("Getting " + this.trainingDataSize + " controversy match candidates from " + candidateMaps.size() + " maps..."));
        List<Triple> controversyMatches = this.alDecider.getControversyCandidates(candidateMaps, this.trainingDataSize);
        Mapping answer = new Mapping();
        for (Triple t : controversyMatches) {
            answer.add(t.getSourceUri(), t.getTargetUri(), t.getSimilarity());
        }
        return answer;
    }

    protected void determineMetric() {
        this.pop.sortByFitness();
        Metric best = null;
        double fit = Double.MAX_VALUE;
        IGPProgram bestProg = null;
        for (IGPProgram p : this.pop.getGPPrograms()) {
            if (p == null || !(fit > p.getFitnessValue())) continue;
            try {
                fit = p.getFitnessValue();
                Metric mp = this.getMetric(p);
                if (!mp.isValid()) continue;
                best = mp;
                bestProg = p;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
        if (best != null && bestProg != null) {
            this.allBest = bestProg;
            this.metric = best;
            this.bestOfCycles.add(bestProg);
            logger.info((Object)("Fittest Program is set to: " + this.metric + " with a fitness value of " + this.allBest.getFitnessValue()));
        }
    }

    protected Metric getMetric(IGPProgram p) {
        try {
            Object[] args = new Object[]{};
            ProgramChromosome pc = p.getChromosome(0);
            this.metric = (Metric)pc.getNode(0).execute_object(pc, 0, args);
            if (this.metric.isValid()) {
                return this.metric;
            }
            return this.metric;
        }
        catch (Exception e) {
            logger.warn((Object)("Error executing program. Exception:\n" + e.getMessage()));
            return null;
        }
    }

    private void fillOracle(Mapping trainingData) {
        Mapping cachedMatches = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : trainingData.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (e2.getValue() > 0.0) {
                    cachedMatches.add(e1.getKey(), e2.getKey(), 1.0);
                }
                this.trainingData.add(e1.getKey(), e2.getKey(), e2.getValue());
            }
        }
        this.fitness.addToReference(cachedMatches);
        this.fitness.fillCachesIncrementally(trainingData);
        this.alDecider.setKnown(trainingData);
    }

    public ExpressionFitnessFunction getFitnessFunction() {
        return this.fitness;
    }

    public static void main(String[] args) {
        String configFile = "Examples/GeneticEval/PublicationData.xml";
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        Oracle o = OracleFactory.getOracle("Examples/GeneticEval/Datasets/DBLP-ACM/DBLP-ACM_perfectMapping.csv", "csv", "simple");
        int size = 10;
        PropertyMapping propMap = PropMapper.getPropertyMapping(configFile);
        LinkSpecificationLearner learner = LinkSpecificationLearnerFactory.getLinkSpecificationLearner("geneticactivelearner");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("populationSize", 20);
        param.put("generations", 100);
        param.put("mutationRate", Float.valueOf(0.5f));
        param.put("preserveFittest", false);
        param.put("propertyMapping", propMap);
        param.put("trainingDataSize", size);
        param.put("granularity", 2);
        param.put("config", cR);
        try {
            learner.init(cR.getSourceInfo(), cR.getTargetInfo(), param);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Mapping answer = learner.learn(new Mapping());
        Mapping oracleAnswer = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (o.ask(e1.getKey(), e2.getKey())) {
                    oracleAnswer.add(e1.getKey(), e2.getKey(), 1.0);
                    continue;
                }
                oracleAnswer.add(e1.getKey(), e2.getKey(), 0.0);
            }
        }
        for (int cycle = 0; cycle < 10; ++cycle) {
            System.out.println("Performing learning cycle " + cycle);
            answer = learner.learn(oracleAnswer);
            Metric answerMetric = learner.terminate();
            if (answerMetric.isValid()) {
                PRFComputer prfC = new PRFComputer();
                double fS = prfC.computePrecision(o.getMapping(), learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true));
                System.out.println("Cycle " + cycle + " Best = " + answerMetric + "\n\tF-Score = " + fS);
            } else {
                Logger.getLogger((String)"Limes").warn((Object)"Method returned no valid metric!");
            }
            System.out.println("Gathering more data from user ... ");
            oracleAnswer = new Mapping();
            for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
                for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                    if (o.ask(e1.getKey(), e2.getKey())) {
                        oracleAnswer.add(e1.getKey(), e2.getKey(), 1.0);
                        continue;
                    }
                    oracleAnswer.add(e1.getKey(), e2.getKey(), 0.0);
                }
            }
        }
    }

    protected void printPop(GPPopulation pop) {
        int i = 0;
        for (IGPProgram p : pop.getGPPrograms()) {
            System.out.println(++i + ":" + this.getMetric(p));
        }
    }

    public Metric terminate() {
        this.determineMetric();
        return this.metric;
    }
}

