/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.PseudoEvaluationComplete;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import java.util.HashMap;
import java.util.LinkedList;

public class RestRunner {
    public static void main(String[] args) {
        LinkedList<Double[]> ranges = new LinkedList<Double[]>();
        for (int a = 0; a < 3; ++a) {
            ranges.add(null);
        }
        ranges.set(0, new Double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6});
        ranges.set(1, new Double[]{0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3});
        ranges.set(2, new Double[]{1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0});
        if (args.length == 1) {
            System.out.println("running exp on Amazon-GoogleProds");
            int index = Integer.parseInt(args[0]);
            if (index < 0 || index > 2) {
                System.out.println("Index not recognized");
                System.exit(1);
            } else {
                RestRunner runner = new RestRunner();
                runner.runAmazonGoogleProds((Double[])ranges.get(index));
            }
        } else {
            RestRunner.runbeta2();
        }
    }

    public void runAmazonGoogleProds(Double[] range) {
        PseudoEvaluationComplete eval = new PseudoEvaluationComplete();
        DataSetChooser.DataSets data = DataSetChooser.DataSets.AMAZONGOOGLE;
        PseudoMeasures[] measures = new PseudoMeasures[]{new PseudoMeasures(), new ReferencePseudoMeasures()};
        System.out.println("Running dataset " + (Object)((Object)data));
        HashMap<String, Object> param = DataSetChooser.getData(data);
        for (PseudoMeasures measure : measures) {
            try {
                eval.run(param, measure, range);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void runbeta2() {
        PseudoEvaluationComplete eval = new PseudoEvaluationComplete();
        DataSetChooser.DataSets[] data = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.PERSON1, DataSetChooser.DataSets.PERSON2, DataSetChooser.DataSets.RESTAURANTS, DataSetChooser.DataSets.ABTBUY};
        Double[] toRun = new Double[]{2.0};
        PseudoMeasures[] measures = new PseudoMeasures[]{new PseudoMeasures(), new ReferencePseudoMeasures()};
        for (DataSetChooser.DataSets dataset : data) {
            System.out.println("Running dataset " + (Object)((Object)dataset));
            HashMap<String, Object> param = DataSetChooser.getData(dataset);
            for (PseudoMeasures measure : measures) {
                try {
                    eval.run(param, measure, toRun);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

