/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.core.PseudoFMeasureFitnessFunction;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoCombinedMemory;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import de.uni_leipzig.simba.util.Clock;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoEvaluationComplete {
    static final Logger logger = Logger.getLogger((String)"LIMES");
    public static final String SEP = ";";
    public static final String subFolder = "betaEval/";
    public float mutation = 0.3f;
    public float crossover = 0.5f;
    public float reproduction = 0.5f;
    public int generations = 20;
    public int population = 100;
    LinkSpecGeneticLearnerConfig config;
    PseudoFMeasureFitnessFunction fitness;
    LinkedList<EvaluationPseudoMemory> perRunAndDataSet;
    String extansion;
    IGPProgram bestEver;
    double bestEverFitness;
    private static int maxRuns = 5;

    public void run(HashMap<String, Object> param, PseudoMeasures measure, Double[] allBetaValues) throws Exception {
        LinkedList<EvaluationPseudoCombinedMemory> perDataSetMem = new LinkedList<EvaluationPseudoCombinedMemory>();
        this.bestEver = null;
        System.out.println("Start Evaluating " + param.get("name") + " with measure " + measure.getName());
        Double[] arr$ = allBetaValues;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double beta = arr$[i$];
            System.out.println("Start Evaluating " + param.get("name") + " for " + measure.getName() + " with beta = " + beta);
            EvaluationPseudoCombinedMemory perBeta = new EvaluationPseudoCombinedMemory(beta);
            for (int run = 1; run <= maxRuns; ++run) {
                System.out.println("Running run " + run + " on " + param.get("name"));
                EvaluationPseudoMemory perRun = this.run(param, run, measure, beta);
                perBeta.add(this.evaluate(param, perRun));
            }
            perDataSetMem.add(perBeta);
            System.out.println(perBeta.toString(SEP));
        }
        System.out.println("Finished Evaluating " + param.get("name"));
        String range = "B" + allBetaValues[0] + "-" + allBetaValues[allBetaValues.length - 1];
        System.out.println(range);
        this.writeFile(param, measure, perDataSetMem, range);
    }

    private EvaluationPseudoMemory run(HashMap<String, Object> param, int run, PseudoMeasures measure, double beta) throws InvalidConfigurationException {
        this.bestEverFitness = Double.MAX_VALUE;
        this.bestEver = null;
        System.out.println("Running passage " + run + " on " + param.get("config") + " with beta=" + beta);
        this.perRunAndDataSet = new LinkedList();
        Clock clock = new Clock();
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        Cache sC = (Cache)param.get("sourcecache");
        Cache tC = (Cache)param.get("targetcache");
        PropertyMapping pM = (PropertyMapping)param.get("propertymapping");
        LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(cR.sourceInfo, cR.targetInfo, pM);
        config.setCrossoverProb(this.crossover);
        config.setMutationProb(this.mutation);
        config.setReproductionProb(this.reproduction);
        config.setPopulationSize(this.population);
        config.setPreservFittestIndividual(true);
        this.fitness = PseudoFMeasureFitnessFunction.getInstance(config, measure, sC, tC);
        this.fitness.setBeta(beta);
        config.setFitnessFunction(this.fitness);
        ExpressionProblem gpP = new ExpressionProblem(config);
        GPGenotype gp = gpP.create();
        for (int gen = 1; gen < this.generations; ++gen) {
            gp.evolve();
            if (gen % 5 != 0 && gen != 1) continue;
            this.processGeneration(gp, gen, run);
            System.out.println("Finished generation " + gen + " / " + this.generations);
        }
        IGPProgram bestProgram = this.processGeneration(gp, this.generations, run);
        Metric bestMetric = this.getMetric(bestProgram);
        EvaluationPseudoMemory mem = new EvaluationPseudoMemory(run, this.generations, bestMetric, this.fitness.calculateRawFitness(bestProgram), clock.totalDuration());
        mem.pseudoFMeasure = 1.0 - mem.fitness;
        mem.betaValue = beta;
        mem.fullMapping = this.fitness.getMapping(mem.metric.getExpression(), mem.metric.getThreshold());
        this.fitness.destroy();
        this.fitness = null;
        LinkSpecGeneticLearnerConfig.reset();
        return mem;
    }

    public IGPProgram processGeneration(GPGenotype gp, int gen, int run) {
        IGPProgram pBest = this.determinFittest(gp);
        return pBest;
    }

    private IGPProgram determinFittest(GPGenotype gp) {
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        IGPProgram[] bests = new IGPProgram[]{gp.getFittestProgramComputed(), pop.determineFittestProgram(), gp.getAllTimeBest(), pop.getGPProgram(0)};
        IGPProgram bestHere = null;
        double fittest = Double.MAX_VALUE;
        for (IGPProgram p : bests) {
            double fitM;
            if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
            fittest = fitM;
            bestHere = p;
        }
        if (fittest < this.bestEverFitness) {
            this.bestEverFitness = fittest;
            gp.getGPPopulation().addFittestProgram(this.bestEver);
            return bestHere;
        }
        return this.bestEver;
    }

    public static void main(String[] args) {
        DataSetChooser.DataSets[] data;
        Double[] allBetaValues = new Double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0};
        PseudoEvaluationComplete eval = new PseudoEvaluationComplete();
        DataSetChooser.DataSets[] allDataSets = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.PERSON1, DataSetChooser.DataSets.PERSON2, DataSetChooser.DataSets.RESTAURANTS, DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.AMAZONGOOGLE};
        LinkedList<Double[]> ranges = new LinkedList<Double[]>();
        for (int a = 0; a < 7; ++a) {
            ranges.add(null);
        }
        ranges.set(0, new Double[]{0.1, 0.2, 0.3});
        ranges.set(1, new Double[]{0.4, 0.5, 0.6});
        ranges.set(2, new Double[]{0.7, 0.8, 0.9});
        ranges.set(3, new Double[]{1.0, 1.1, 1.2});
        ranges.set(4, new Double[]{1.3, 1.4, 1.5});
        ranges.set(5, new Double[]{1.6, 1.7, 1.8});
        ranges.set(6, new Double[]{1.9, 2.0});
        Iterator i$ = ranges.iterator();
        while (i$.hasNext()) {
            Double[] entry;
            for (Double d : entry = (Double[])i$.next()) {
                System.out.print(d + " ,");
            }
            System.out.println();
        }
        if (args.length == 0) {
            data = allDataSets;
        } else {
            int index = Integer.parseInt(args[0]);
            if (index >= 0 && index < 6) {
                data = new DataSetChooser.DataSets[]{allDataSets[index]};
            } else {
                System.out.println("Usage: PseudoEvaluationComplete i, where 0<=i<=5.");
                data = new DataSetChooser.DataSets[]{};
            }
        }
        if (args.length == 2) {
            int listIndex = Integer.parseInt(args[1]);
            if (ranges.get(listIndex) != null) {
                allBetaValues = (Double[])ranges.get(listIndex);
            } else {
                System.out.println("Error second argument " + listIndex + " should be on of the keys: " + ranges.toArray());
                System.exit(1);
            }
        }
        PseudoMeasures[] measures = new PseudoMeasures[]{new PseudoMeasures(), new ReferencePseudoMeasures()};
        for (DataSetChooser.DataSets dataset : data) {
            System.out.println("Running dataset " + (Object)((Object)dataset));
            HashMap<String, Object> param = DataSetChooser.getData(dataset);
            for (PseudoMeasures measure : measures) {
                try {
                    eval.run(param, measure, allBetaValues);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private EvaluationPseudoMemory evaluate(HashMap<String, Object> param, EvaluationPseudoMemory mem) {
        Mapping reference = (Mapping)param.get("referencemapping");
        PRFComputer prf = new PRFComputer();
        double prec = prf.computePrecision(mem.fullMapping, reference);
        double recall = prf.computeRecall(mem.fullMapping, reference);
        double fMeasure = prf.computeFScore(mem.fullMapping, reference);
        mem.precision = prec;
        mem.recall = recall;
        mem.fmeasue = fMeasure;
        return mem;
    }

    public Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    private void writeFile(HashMap<String, Object> param, PseudoMeasures measure, List<EvaluationPseudoCombinedMemory> perDataSetMem, String range) throws IOException {
        String fileName = measure.getName() + "_" + (String)param.get("name") + "-" + range + ".csv";
        File file = new File("" + param.get("evalfolder") + subFolder + fileName);
        FileWriter writer = new FileWriter(file, false);
        writer.write(EvaluationPseudoCombinedMemory.getColumnHeader(SEP));
        writer.write(System.getProperty("line.separator"));
        writer.flush();
        for (EvaluationPseudoCombinedMemory mem : perDataSetMem) {
            writer.write(mem.toString(SEP));
            writer.write(System.getProperty("line.separator"));
            writer.flush();
        }
        writer.close();
    }
}

