/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.core.PseudoFMeasureFitnessFunction;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.PseudoEvalFileLogger;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import de.uni_leipzig.simba.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoEvaluation {
    static final Logger logger = Logger.getLogger((String)"LIMES");
    public float mutation = 0.3f;
    public float crossover = 0.5f;
    public float reproduction = 0.5f;
    public int generations = 20;
    public int population = 100;
    double beta = 1.0;
    LinkSpecGeneticLearnerConfig config;
    Clock clock;
    PseudoFMeasureFitnessFunction fitness;
    LinkedList<EvaluationPseudoMemory> perRunAndDataSet;
    LinkedList<EvaluationPseudoMemory> perDataSet = new LinkedList();
    String extansion;
    IGPProgram bestEver;
    double bestEverFitness;
    private static int maxRuns = 5;

    public void run(HashMap<String, Object> param, int run, PseudoMeasures measure, String nameExtansion) throws InvalidConfigurationException {
        this.bestEverFitness = Double.MAX_VALUE;
        if (nameExtansion != null) {
            this.extansion = nameExtansion;
        }
        if (run == 0) {
            System.exit(1);
        }
        System.out.println("Running run" + run + " on " + param.get("config"));
        this.perRunAndDataSet = new LinkedList();
        this.clock = new Clock();
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        Cache sC = (Cache)param.get("sourcecache");
        Cache tC = (Cache)param.get("targetcache");
        Mapping reference = (Mapping)param.get("referencemapping");
        PropertyMapping pM = (PropertyMapping)param.get("propertymapping");
        LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(cR.sourceInfo, cR.targetInfo, pM);
        config.setCrossoverProb(this.crossover);
        config.setMutationProb(this.mutation);
        config.setReproductionProb(this.reproduction);
        config.setPopulationSize(this.population);
        config.setPreservFittestIndividual(true);
        this.fitness = PseudoFMeasureFitnessFunction.getInstance(config, measure, sC, tC);
        this.fitness.setBeta(this.beta);
        config.setFitnessFunction(this.fitness);
        ExpressionProblem gpP = new ExpressionProblem(config);
        GPGenotype gp = gpP.create();
        Metric m = null;
        for (int gen = 1; gen <= this.generations; ++gen) {
            if (gen % 10 == 0) {
                System.out.println("Running gen:" + gen + " of run:" + run);
            }
            gp.evolve();
            m = this.processGeneration(gp, gen, run);
        }
        Mapping bestMapping = this.fitness.getMapping(m.getExpression(), m.getThreshold());
        PRFComputer prf = new PRFComputer();
        double prec = prf.computePrecision(bestMapping, reference);
        double recall = prf.computeRecall(bestMapping, reference);
        double fMeasure = prf.computeFScore(bestMapping, reference);
        System.out.println("prec=" + prec + " recall=" + recall + " fscore=" + fMeasure);
        System.out.println("Duration:" + this.clock.durationSinceClick());
        System.out.println("best Mapping size:" + bestMapping.size());
        System.out.println("reference size: " + reference.size());
        this.finishRun(param, run);
        if ((Integer)param.get("maxruns") == run) {
            this.finishDataSet(param);
        }
        this.fitness.destroy();
        this.fitness = null;
    }

    private void finishRun(HashMap<String, Object> param, int run) {
        this.perDataSet.addAll(this.perRunAndDataSet);
        this.perRunAndDataSet.clear();
        this.fitness.destroy();
        LinkSpecGeneticLearnerConfig.reset();
    }

    public void finishDataSet(HashMap<String, Object> param) {
        Mapping reference = (Mapping)param.get("referencemapping");
        Collections.sort(this.perDataSet);
        for (EvaluationPseudoMemory mem : this.perDataSet) {
            Mapping map = this.fitness.getMapping(mem.metric.getExpression(), mem.metric.getThreshold());
            PRFComputer prf = new PRFComputer();
            double prec = prf.computePrecision(map, reference);
            double recall = prf.computeRecall(map, reference);
            double fMeasure = prf.computeFScore(map, reference);
            mem.precision = prec;
            mem.recall = recall;
            mem.fmeasue = fMeasure;
        }
        PseudoEvalFileLogger fileLog = new PseudoEvalFileLogger((String)param.get("evalfolder"), (String)param.get("evalfilename"));
        fileLog.nameExtansion = this.extansion + "_Beta-" + this.beta + "_";
        if (!fileLog.log(this.perDataSet, maxRuns, this.generations, param)) {
            System.exit(1);
            this.perDataSet.clear();
        }
        this.perDataSet.clear();
        this.perRunAndDataSet.clear();
    }

    public Metric processGeneration(GPGenotype gp, int gen, int run) {
        IGPProgram pBest = this.determinFittest(gp);
        this.perRunAndDataSet.add(new EvaluationPseudoMemory(run, gen, this.getMetric(pBest), this.fitness.calculateRawFitness(pBest), this.clock.totalDuration()));
        return this.getMetric(pBest);
    }

    private IGPProgram determinFittest(GPGenotype gp) {
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        IGPProgram[] bests = new IGPProgram[]{gp.getFittestProgramComputed(), pop.determineFittestProgram(), gp.getAllTimeBest(), pop.getGPProgram(0)};
        IGPProgram bestHere = null;
        double fittest = Double.MAX_VALUE;
        for (IGPProgram p : bests) {
            double fitM;
            if (p == null || !((fitM = this.fitness.calculateRawFitness(p)) < fittest)) continue;
            fittest = fitM;
            bestHere = p;
        }
        if (fittest < this.bestEverFitness) {
            this.bestEverFitness = fittest;
            gp.getGPPopulation().addFittestProgram(this.bestEver);
            return bestHere;
        }
        return this.bestEver;
    }

    public Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    public static void main(String[] args) {
        int run;
        HashMap<String, Object> param;
        PseudoEvaluation eval = new PseudoEvaluation();
        String nameExtansion = "";
        PseudoMeasures measure = new ReferencePseudoMeasures();
        nameExtansion = "_ReferenceMeasure_";
        DataSetChooser.DataSets[] data = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.PERSON1, DataSetChooser.DataSets.PERSON2, DataSetChooser.DataSets.RESTAURANTS, DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.AMAZONGOOGLE};
        try {
            for (DataSetChooser.DataSets dataset : data) {
                System.out.println("Running dataset " + (Object)((Object)dataset));
                param = DataSetChooser.getData(dataset);
                for (run = 1; run <= maxRuns; ++run) {
                    param.put("maxruns", maxRuns);
                    eval.run(param, run, measure, nameExtansion);
                }
            }
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        measure = new PseudoMeasures();
        nameExtansion = "_PseudoMeasures_";
        try {
            for (DataSetChooser.DataSets dataset : data) {
                System.out.println("Running dataset " + (Object)((Object)dataset));
                param = DataSetChooser.getData(dataset);
                for (run = 1; run <= maxRuns; ++run) {
                    param.put("maxruns", maxRuns);
                    eval.run(param, run, measure, nameExtansion);
                }
            }
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

