/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.statistics;
import de.uni_leipzig.simba.util.Clock;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoEvalFileLogger {
    public String fileName;
    public String folder;
    public static final String SEP = ";";
    File f_all;
    File f_mean;
    public String nameExtansion = "";

    public PseudoEvalFileLogger(String folder, String file) {
        this.fileName = file;
        this.folder = folder;
    }

    public boolean log(List<EvaluationPseudoMemory> list, int numberOfRuns, int numberOfGenerations, HashMap<String, Object> param) {
        if (!this.createFiles((String)param.get("evalfolder"), (String)param.get("evalfilename"))) {
            return false;
        }
        statistics fScore = new statistics();
        statistics dur = new statistics();
        int gen = 1;
        int runs = 0;
        for (int iter = 0; iter < list.size(); ++iter) {
            EvaluationPseudoMemory mem = list.get(iter);
            Long durVal = new Long(mem.runTime);
            if (mem.generation == gen) {
                fScore.add(mem.fmeasue);
                dur.add(durVal.doubleValue());
                ++runs;
            } else {
                if (fScore.count > 0) {
                    this.writeMeanEntry(gen, fScore, dur, runs);
                }
                fScore = new statistics();
                fScore.add(mem.fmeasue);
                dur = new statistics();
                dur.add(durVal.doubleValue());
                runs = 1;
            }
            gen = mem.generation;
        }
        this.writeMeanEntry(gen, fScore, dur, runs);
        this.logAll(list, param);
        return true;
    }

    public void logAll(List<EvaluationPseudoMemory> list, HashMap<String, Object> param) {
        try {
            FileWriter writer = new FileWriter(this.f_all, true);
            for (EvaluationPseudoMemory mem : list) {
                writer.write(mem.toString(SEP));
                writer.write(System.getProperty("line.separator"));
                writer.flush();
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean createFiles(String folder, String name) {
        this.f_all = new File(folder + this.nameExtansion + name);
        this.f_mean = new File(folder + this.nameExtansion + "MEAN_" + name);
        return this.writeCaptions();
    }

    private void writeMeanEntry(int gen, statistics f, statistics dur, int runs) {
        try {
            FileWriter writer = new FileWriter(this.f_mean, true);
            String out = "" + gen + SEP + f.mean + SEP + f.standardDeviation + SEP + dur.mean + SEP + runs;
            writer.write(out);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private boolean writeCaptions() {
        String head = "Cycle;Generation;Fitness;F-Score;Recall;Precision;Duration;reference data;Metric";
        String head_mean = "Generation;mean f-Scores;std derivation f-Scores;mean duration;cylces";
        try {
            FileWriter writer = new FileWriter(this.f_all, false);
            writer.write(head);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
            writer = new FileWriter(this.f_mean, false);
            writer.write(head_mean);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        Clock c1 = new Clock();
        long l1 = 100L;
        long l2 = 1444552L;
        Long durVal1 = new Long(l1);
        Long durVal2 = new Long(l2);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        double d1 = durVal1.doubleValue();
        double d2 = durVal2.doubleValue();
        durVal1 = c1.totalDuration() * -1L;
        System.out.println(durVal1);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        durVal2 = c1.totalDuration() * -1L;
        System.out.println(durVal2);
        d1 = durVal1.doubleValue();
        d2 = durVal2.doubleValue();
        System.out.println(durVal1);
        System.out.println(durVal2);
        System.out.println(d1);
        System.out.println(d2);
        System.out.println(new Long(durVal1).doubleValue());
        System.out.println(new Long(durVal2).doubleValue());
    }
}

