/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.genetics.core.Metric;
import org.jgap.gp.IGPProgram;

public class EvaluationPseudoMemory
implements Comparable {
    public int sortNumber;
    public int run;
    public Metric metric;
    public double pseudoFMeasure;
    public double fmeasue;
    public double recall;
    public double precision;
    public long runTime;
    public int generation;
    public double fitness;
    public int knownInstances;
    public IGPProgram program;
    public double betaValue;
    public Mapping fullMapping;

    public EvaluationPseudoMemory(int run, int gen, Metric m, double fitness, long runTime) {
        this.run = run;
        this.generation = gen;
        this.metric = m;
        this.fitness = fitness;
        this.runTime = runTime < 0L ? runTime * -1L : runTime;
        this.sortNumber = gen + run;
    }

    public int getSortNumber() {
        this.sortNumber = Integer.parseInt("" + this.generation + "" + this.run);
        return this.sortNumber;
    }

    public String toString(String sep) {
        String ret = this.run + sep + this.generation + sep + this.fitness + sep + this.fmeasue + sep + this.recall + sep + this.precision + sep + this.runTime;
        ret = this.knownInstances > 0 ? ret + sep + this.knownInstances : ret + sep + 0;
        ret = ret + sep + this.metric;
        return ret;
    }

    public int compareTo(Object o) {
        EvaluationPseudoMemory os = (EvaluationPseudoMemory)o;
        if (this.generation == os.generation) {
            return this.run - os.run;
        }
        return this.generation - os.generation;
    }

    public String toString() {
        return "gen=" + this.generation + "run=" + this.run;
    }
}

