/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.statistics;

public class EvaluationPseudoCombinedMemory {
    public double beta;
    public statistics pseudoFMeasure;
    public statistics FScore;
    public statistics precision;
    public statistics recall;
    public statistics duration;

    public EvaluationPseudoCombinedMemory(double beta) {
        this.beta = beta;
        this.pseudoFMeasure = new statistics();
        this.FScore = new statistics();
        this.precision = new statistics();
        this.recall = new statistics();
        this.duration = new statistics();
    }

    public void add(EvaluationPseudoMemory mem) throws Exception {
        if (this.beta != mem.betaValue) {
            throw new Exception("Trying to combine memory for beta = " + mem.betaValue + " with results for beta =" + this.beta);
        }
        this.pseudoFMeasure.add(mem.pseudoFMeasure);
        this.FScore.add(mem.fmeasue);
        this.precision.add(mem.precision);
        this.recall.add(mem.recall);
        Long durVal = mem.runTime < 0L ? new Long(-1L * mem.runTime) : new Long(mem.runTime);
        this.duration.add(durVal.doubleValue());
    }

    public String toString(String SEP) {
        return "" + this.beta + SEP + this.pseudoFMeasure.mean + SEP + this.pseudoFMeasure.standardDeviation + SEP + this.FScore.mean + SEP + this.FScore.standardDeviation + SEP + this.precision.mean + SEP + this.precision.standardDeviation + SEP + this.recall.mean + SEP + this.recall.standardDeviation + SEP + this.duration.mean + SEP + this.duration.standardDeviation;
    }

    public static String getColumnHeader(String SEP) {
        return "beta" + SEP + "pseudo F" + SEP + "pseudo F std derivation" + SEP + "real f-score" + SEP + "real f std derivation" + SEP + "precision" + SEP + "precision std derivation" + SEP + "recall" + SEP + "recall std derivation" + SEP + "duration ms" + SEP + "duration std derivation";
    }
}

