/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.genetics.util.PropMapper;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.selfconfig.Experiment;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSetChooser {
    public static HashMap<String, Object> getData(DataSets a) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        switch (a) {
            case PERSON1: {
                param = DataSetChooser.getPerson1();
                break;
            }
            case PERSON2: {
                param = DataSetChooser.getPerson2();
                break;
            }
            case RESTAURANTS: {
                param = DataSetChooser.getRestaurant();
                break;
            }
            case DBLPACM: {
                param = DataSetChooser.getDBLPACM();
                break;
            }
            case ABTBUY: {
                param = DataSetChooser.getAbtBuy();
                break;
            }
            case DBLPSCHOLAR: {
                param = DataSetChooser.getDBLPScholar();
                break;
            }
            case AMAZONGOOGLE: {
                param = DataSetChooser.getAmazonGoogleProducts();
                break;
            }
            case DBPLINKEDMDB: {
                param = DataSetChooser.getDBPediaLinkedMDB();
                break;
            }
            case DRUGS: {
                param = DataSetChooser.getDrugs();
                break;
            }
            case PERSON1_CSV: {
                param = DataSetChooser.getPerson1CSV();
                break;
            }
            case PERSON2_CSV: {
                param = DataSetChooser.getPerson2CSV();
                break;
            }
            case RESTAURANTS_CSV: {
                param = DataSetChooser.getRestaurantCSV();
            }
        }
        return param;
    }

    public static HashMap<String, Object> getPerson1() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "resources/");
        param.put("datasetfolder", "resources/Persons1/");
        param.put("config", "persons1.xml");
        param.put("reference", "dataset11_dataset12_goldstandard_person.xml");
        param.put("file1", "person11.nt");
        param.put("file2", "person12.nt");
        String type = "-Person";
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Persons1.csv");
        param.put("name", "Persons1");
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", Experiment.readOAEIFile((String)param.get("datasetfolder") + (String)param.get("file1"), type));
        param.put("targetcache", Experiment.readOAEIFile((String)param.get("datasetfolder") + (String)param.get("file2"), type));
        param.put("referencemapping", Experiment.readOAEIMapping((String)param.get("datasetfolder") + (String)param.get("reference")));
        return param;
    }

    public static HashMap<String, Object> getPerson1CSV() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "resources/");
        param.put("datasetfolder", "Persons1/");
        param.put("config", "persons1_csv.xml");
        param.put("reference", "dataset11_dataset12_goldstandard_person.xml.csv");
        param.put("file1", "person11.nt");
        param.put("file2", "person12.nt");
        String type = "-Person";
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Persons1.csv");
        param.put("name", "Persons1");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + (String)param.get("config"));
        HybridCache sC = HybridCache.getData(cR.sourceInfo);
        HybridCache tC = HybridCache.getData(cR.targetInfo);
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", sC);
        param.put("targetcache", tC);
        Oracle o = OracleFactory.getOracle("" + param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "CSV", "simple");
        param.put("referencemapping", o.getMapping());
        return param;
    }

    public static HashMap<String, Object> getPerson2() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "resources/");
        param.put("datasetfolder", "resources/Persons2/");
        param.put("config", "persons2.xml");
        param.put("reference", "dataset21_dataset22_goldstandard_person.xml");
        param.put("file1", "person21.nt");
        param.put("file2", "person22.nt");
        String type = "-Person";
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Persons2.csv");
        param.put("name", "Persons2");
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", Experiment.readOAEIFile((String)param.get("datasetfolder") + (String)param.get("file1"), type));
        param.put("targetcache", Experiment.readOAEIFile((String)param.get("datasetfolder") + (String)param.get("file2"), type));
        param.put("referencemapping", Experiment.readOAEIMapping((String)param.get("datasetfolder") + (String)param.get("reference")));
        return param;
    }

    public static HashMap<String, Object> getPerson2CSV() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "resources/");
        param.put("datasetfolder", "Persons2/");
        param.put("config", "persons2_csv.xml");
        param.put("reference", "dataset21_dataset22_goldstandard_person.xml.csv");
        param.put("file1", "person21.nt");
        param.put("file2", "person22.nt");
        String type = "-Person";
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Persons2.csv");
        param.put("name", "Persons2");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + (String)param.get("config"));
        HybridCache sC = HybridCache.getData(cR.sourceInfo);
        HybridCache tC = HybridCache.getData(cR.targetInfo);
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", sC);
        param.put("targetcache", tC);
        Oracle o = OracleFactory.getOracle("" + param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "CSV", "simple");
        param.put("referencemapping", o.getMapping());
        return param;
    }

    public static HashMap<String, Object> getRestaurant() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "resources/");
        param.put("datasetfolder", "resources/Restaurants/");
        param.put("config", "restaurants.xml");
        param.put("reference", "restaurant1_restaurant2_goldstandard.rdf");
        param.put("file1", "restaurant1.nt");
        param.put("file2", "restaurant2.nt");
        String type = "-Restaurant";
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Restaurants.csv");
        param.put("name", "Restaurants");
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", Experiment.readOAEIFile((String)param.get("datasetfolder") + (String)param.get("file1"), type));
        param.put("targetcache", Experiment.readOAEIFile((String)param.get("datasetfolder") + (String)param.get("file2"), type));
        param.put("referencemapping", Experiment.readOAEIMapping((String)param.get("datasetfolder") + (String)param.get("reference")));
        return param;
    }

    public static HashMap<String, Object> getRestaurantCSV() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "resources/");
        param.put("datasetfolder", "Restaurants/");
        param.put("config", "restaurants_csv.xml");
        param.put("reference", "restaurant1_restaurant2_goldstandard.rdf.csv");
        param.put("file1", "restaurant1.nt");
        param.put("file2", "restaurant2.nt");
        String type = "-Restaurant";
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Restaurants.csv");
        param.put("name", "Restaurants");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + (String)param.get("config"));
        HybridCache sC = HybridCache.getData(cR.sourceInfo);
        HybridCache tC = HybridCache.getData(cR.targetInfo);
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", sC);
        param.put("targetcache", tC);
        Oracle o = OracleFactory.getOracle("" + param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "CSV", "simple");
        param.put("referencemapping", o.getMapping());
        return param;
    }

    public static HashMap<String, Object> getDBLPACM() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "Examples/GeneticEval/");
        param.put("datasetfolder", "Datasets/DBLP-ACM/");
        param.put("config", "PublicationData.xml");
        param.put("reference", "DBLP-ACM_perfectMapping.csv");
        param.put("file1", "ACM.csv");
        param.put("file2", "DBLP2.csv");
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_DBLP-ACM.csv");
        param.put("name", "DBLP-ACM");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", HybridCache.getData(cR.sourceInfo));
        param.put("targetcache", HybridCache.getData(cR.targetInfo));
        param.put("referencemapping", OracleFactory.getOracle((String)param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "csv", "simple").getMapping());
        return param;
    }

    public static HashMap<String, Object> getAbtBuy() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "Examples/GeneticEval/");
        param.put("datasetfolder", "Datasets/Abt-Buy/");
        param.put("config", "Abt-Buy.xml");
        param.put("reference", "abt_buy_perfectMapping.csv");
        param.put("file1", "Abt.csv");
        param.put("file2", "Buy.csv");
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Abt-Buy.csv");
        param.put("name", "Abt-Buy");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", HybridCache.getData(cR.sourceInfo));
        param.put("targetcache", HybridCache.getData(cR.targetInfo));
        param.put("referencemapping", OracleFactory.getOracle((String)param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "csv", "simple").getMapping());
        return param;
    }

    public static HashMap<String, Object> getDBLPScholar() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "Examples/GeneticEval/");
        param.put("datasetfolder", "Datasets/DBLP-Scholar/");
        param.put("config", "DBLP-Scholar.xml");
        param.put("reference", "DBLP-Scholar_perfectMapping.csv");
        param.put("file1", "DBLP1.csv");
        param.put("file2", "Scholar.csv");
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_DBLP-Scholar.csv");
        param.put("name", "Abt-Buy");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", HybridCache.getData(cR.sourceInfo));
        param.put("targetcache", HybridCache.getData(cR.targetInfo));
        param.put("referencemapping", OracleFactory.getOracle((String)param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "csv", "simple").getMapping());
        return param;
    }

    public static HashMap<String, Object> getAmazonGoogleProducts() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "Examples/GeneticEval/");
        param.put("datasetfolder", "Datasets/Amazon-GoogleProducts/");
        param.put("config", "Amazon-GoogleProducts.xml");
        param.put("reference", "Amzon_GoogleProducts_perfectMapping.csv");
        param.put("file1", "Amazon.csv");
        param.put("file2", "GoogleProducts.csv");
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Amazon-GoogleProducts.csv");
        param.put("name", "Amazon-GoogleProducts");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", HybridCache.getData(cR.sourceInfo));
        param.put("targetcache", HybridCache.getData(cR.targetInfo));
        param.put("referencemapping", OracleFactory.getOracle((String)param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "csv", "simple").getMapping());
        return param;
    }

    public static HashMap<String, Object> getDBPediaLinkedMDB() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "Examples/GeneticEval/");
        param.put("datasetfolder", "Datasets/dbpedia-linkedmdb/");
        param.put("config", "dbpedia-linkedmdb.xml");
        param.put("reference", "reference2.csv");
        param.put("file1", "source2.csv");
        param.put("file2", "target2.csv");
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_DBPedia-LinkedMDB.csv");
        param.put("name", "DBPedia-LinkedMDB");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", HybridCache.getData(cR.sourceInfo));
        param.put("targetcache", HybridCache.getData(cR.targetInfo));
        param.put("referencemapping", OracleFactory.getOracle((String)param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "csv", "simple").getMapping());
        return param;
    }

    public static HashMap<String, Object> getDrugs() {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("basefolder", "Examples/GeneticEval/");
        param.put("datasetfolder", "Datasets/dailymed-drugbank-ingredients/");
        param.put("config", "dailymed-drugbank.xml");
        param.put("reference", "reference2.csv");
        param.put("file1", "source2.csv");
        param.put("file2", "target2.csv");
        param.put("evalfolder", "resources/results/");
        param.put("evalfilename", "Pseudo_eval_Drugs.csv");
        param.put("name", "Drugs");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)param.get("basefolder") + param.get("config"));
        param.put("propertymapping", PropMapper.getPropertyMappingFromFile((String)param.get("basefolder"), (String)param.get("config")));
        param.put("sourcecache", HybridCache.getData(cR.sourceInfo));
        param.put("targetcache", HybridCache.getData(cR.targetInfo));
        param.put("referencemapping", OracleFactory.getOracle((String)param.get("basefolder") + param.get("datasetfolder") + param.get("reference"), "csv", "simple").getMapping());
        return param;
    }

    public static void main(String[] args) {
        DataSetChooser.getPerson1();
        System.out.println("---");
        DataSetChooser.getPerson2();
        System.out.println("---");
        DataSetChooser.getRestaurant();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataSets {
        PERSON1,
        PERSON2,
        RESTAURANTS,
        DBLPACM,
        ABTBUY,
        DBLPSCHOLAR,
        AMAZONGOOGLE,
        DBPLINKEDMDB,
        DRUGS,
        PERSON1_CSV,
        PERSON2_CSV,
        RESTAURANTS_CSV;

    }
}

