/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.pseudomeasures;

import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.PseudoEvaluationComplete;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class AbtBuyRestRunner {
    public static void main(String[] args) {
        DataSetChooser.DataSets[] data;
        Double[] allBetaValues = new Double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0};
        PseudoEvaluationComplete eval = new PseudoEvaluationComplete();
        DataSetChooser.DataSets[] allDataSets = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.PERSON1, DataSetChooser.DataSets.PERSON2, DataSetChooser.DataSets.RESTAURANTS, DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.AMAZONGOOGLE};
        LinkedList<Double[]> ranges = new LinkedList<Double[]>();
        for (int a = 0; a < 7; ++a) {
            ranges.add(null);
        }
        ranges.set(0, new Double[]{0.1, 0.2, 0.3});
        ranges.set(1, new Double[]{0.4, 0.5, 0.6});
        ranges.set(2, new Double[]{0.7, 0.8, 0.9});
        ranges.set(3, new Double[]{1.0, 1.1, 1.2});
        ranges.set(4, new Double[]{1.3, 1.4, 1.5});
        ranges.set(5, new Double[]{1.6, 1.7, 1.8});
        ranges.set(6, new Double[]{1.9, 2.0});
        Iterator i$ = ranges.iterator();
        while (i$.hasNext()) {
            Double[] entry;
            for (Double d : entry = (Double[])i$.next()) {
                System.out.print(d + " ,");
            }
            System.out.println();
        }
        if (args.length == 0) {
            data = allDataSets;
        } else {
            int index = Integer.parseInt(args[0]);
            if (index >= 0 && index < 6) {
                data = new DataSetChooser.DataSets[]{allDataSets[index]};
            } else {
                System.out.println("Usage: PseudoEvaluationComplete i, where 0<=i<=5.");
                data = new DataSetChooser.DataSets[]{};
            }
        }
        if (args.length >= 2) {
            int listIndex = Integer.parseInt(args[1]);
            if (ranges.get(listIndex) != null) {
                allBetaValues = (Double[])ranges.get(listIndex);
            } else {
                System.out.println("Error second argument " + listIndex + " should be on of the keys: " + ranges.toArray());
                System.exit(1);
            }
        }
        LinkedList<PseudoMeasures> measures = new LinkedList<PseudoMeasures>();
        if (args.length == 3) {
            int number = Integer.parseInt(args[2]);
            if (number == 1) {
                measures.add(new PseudoMeasures());
            } else if (number == 2) {
                measures.add(new ReferencePseudoMeasures());
            } else {
                measures.add(new PseudoMeasures());
                measures.add(new ReferencePseudoMeasures());
            }
        }
        for (DataSetChooser.DataSets dataset : data) {
            System.out.println("Running dataset " + (Object)((Object)dataset));
            HashMap<String, Object> param = DataSetChooser.getData(dataset);
            for (PseudoMeasures measure : measures) {
                try {
                    eval.run(param, measure, allBetaValues);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

