/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.matthew;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.genetics.core.ALDecider;
import de.uni_leipzig.simba.genetics.core.ALFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.genetics.evaluation.matthew.BasicEvaluator;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.learner.MappingCorrelation;
import de.uni_leipzig.simba.genetics.learner.WeightDecayCorrelation;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.util.Clock;
import java.util.LinkedList;
import java.util.List;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.impl.GPGenotype;

public class MatthewVSfscore
extends BasicEvaluator {
    public static final String AL = "AL_Normal";
    public static final String AL_CLUSTERING = "AL_Cluster";
    public static final String AL_WEIGHTDECAY = "AL_WD";
    public static String[] methods = new String[]{"AL_Cluster", "AL_WD", "AL_Normal"};
    public static String methodType = "AL_Normal";
    public static double rValueWD = 2.0;
    public static int edgeCountCluster = 3;
    public static String rawFitness;
    public static final String FScore = "fscore";
    public static final String MatthewsCoefficient = "matthews";
    public static String[] rawFitnesses;

    public static void main(String[] args) {
        DataSetChooser.DataSets[] datas;
        for (DataSetChooser.DataSets data : datas = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.PERSON1_CSV, DataSetChooser.DataSets.PERSON2_CSV, DataSetChooser.DataSets.RESTAURANTS_CSV}) {
            MatthewVSfscore.runEval(data);
        }
    }

    public static void runEval(DataSetChooser.DataSets data) {
        for (String ff : rawFitnesses) {
            for (int pop : new int[]{20, 100}) {
                rawFitness = ff;
                MatthewVSfscore eval = new MatthewVSfscore();
                rawFitness = ff;
                try {
                    System.out.println("Running " + (Object)((Object)data) + " with raw fitness: " + rawFitness + " for popSize=" + pop);
                    eval.run(data, pop, 50, 10, 10);
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void run(DataSetChooser.DataSets data, int popSize, int gens, int numberOfExamples, int inquiries) throws InvalidConfigurationException {
        logger.info("Running dataset " + (Object)((Object)data));
        this.currentDataSet = data;
        this.params = DataSetChooser.getData(data);
        String name = ((String)this.params.get("evalfilename")).replaceAll("Pseudo_eval_", "AL_");
        this.params.put("evalfilename", name);
        this.cR = new ConfigReader();
        this.cR.validateAndRead("" + this.params.get("basefolder") + this.params.get("config"));
        String verificationFile = "" + this.params.get("basefolder") + this.params.get("datasetfolder") + this.params.get("reference");
        this.o = OracleFactory.getOracle(verificationFile, verificationFile.substring(verificationFile.lastIndexOf(".") + 1), "simple");
        for (int run = 1; run <= 5; ++run) {
            LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(this.cR.sourceInfo, this.cR.targetInfo, (PropertyMapping)this.params.get("propertymapping"));
            config.setSelectFromPrevGen(this.reproduction);
            config.setCrossoverProb(this.mutationCrossRate);
            config.setMutationProb(this.mutationCrossRate);
            config.setReproductionProb(this.reproduction);
            config.setPopulationSize(popSize);
            config.setPreservFittestIndividual(true);
            config.setAlwaysCaculateFitness(true);
            logger.info("Starting run " + run);
            this.fitness = new ALFitnessFunction(config, this.o, "f-score", numberOfExamples);
            if (rawFitness.equalsIgnoreCase(MatthewsCoefficient)) {
                this.fitness.useMCC();
            } else {
                this.fitness.useFScore();
            }
            Mapping start = ExampleOracleTrimmer.trimExamplesRandomly(this.o.getMapping(), numberOfExamples);
            System.out.println("Start data " + start);
            this.fitness.setReferenceMapping(start);
            this.fitness.trimKnowledgeBases(start);
            config.setFitnessFunction(this.fitness);
            ExpressionProblem gpP = new ExpressionProblem(config);
            GPGenotype gp = gpP.create();
            Clock clock = new Clock();
            ALDecider aLD = new ALDecider();
            for (int inquery = 1; inquery <= inquiries; ++inquery) {
                List<Mapping> mapsOfPop;
                logger.info("Inquery nr " + inquery + " on dataset" + (Object)((Object)data) + " run " + run + " method " + methodType);
                for (int gen = 0; gen < gens; ++gen) {
                    gp.evolve();
                    gp.calcFitness();
                }
                this.examineGen(run, inquery * numberOfExamples, gp, clock);
                if (inquery == inquiries || (mapsOfPop = this.getMaps(gp.getGPPopulation())).size() <= 0) continue;
                List<Object> toAsk = new LinkedList();
                if (methodType.equals(AL_CLUSTERING)) {
                    MappingCorrelation cor = new MappingCorrelation(this.cR.sourceInfo, this.cR.targetInfo, this.fitness.getMetric(gp.getFittestProgram()).getExpression());
                    toAsk = cor.getDisimilarMappings(aLD.getControversyCandidates(mapsOfPop), numberOfExamples, edgeCountCluster);
                    aLD.retrieved.addAll(toAsk);
                } else if (methodType.equals(AL_WEIGHTDECAY)) {
                    WeightDecayCorrelation wdc = new WeightDecayCorrelation(this.cR.sourceInfo, this.cR.targetInfo, this.fitness.getMetric(gp.getFittestProgram()).getExpression());
                    toAsk = wdc.getDisimilarMappings(aLD.getControversyCandidates(mapsOfPop), numberOfExamples, rValueWD);
                    aLD.retrieved.addAll(toAsk);
                } else {
                    toAsk = aLD.getControversyCandidates(mapsOfPop, numberOfExamples);
                }
                logger.info("Asking about " + toAsk.size() + " instances.");
                if (toAsk.size() == 0) {
                    aLD.maxCount += 100;
                }
                Mapping oracleAnswers = new Mapping();
                for (Triple triple : toAsk) {
                    if (!this.o.ask(triple.getSourceUri(), triple.getTargetUri())) continue;
                    oracleAnswers.add(triple.getSourceUri(), triple.getTargetUri(), 1.0);
                }
                this.fitness.addToReference(oracleAnswers);
                this.fitness.fillCachesIncrementally(toAsk);
            }
            this.finishRun();
            this.fitness.destroy();
            LinkSpecGeneticLearnerConfig.reset();
        }
        this.finishDataset(5, popSize, gens, this.params, this.getNameExtension(popSize, gens));
    }

    public String getNameExtension(int popSize, int gens) {
        String nameExtansion = rawFitness + "_";
        nameExtansion = nameExtansion + "AL_pop=" + popSize + "_gens=" + gens + "_meth=" + methodType;
        if (methodType.equals(AL_CLUSTERING)) {
            nameExtansion = nameExtansion + "ECount=" + edgeCountCluster;
        } else if (methodType.equals(AL_WEIGHTDECAY)) {
            nameExtansion = nameExtansion + "rValue=" + rValueWD;
        }
        return nameExtansion;
    }

    static {
        rawFitnesses = new String[]{MatthewsCoefficient, FScore};
    }
}

