/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation.matthew;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ALFitnessFunction;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.PseudoEvalFileLogger;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.util.Clock;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEvaluator {
    public static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    public static final int RUNS = 5;
    public static final int oracleQuestions = 10;
    public DataSetChooser.DataSets currentDataSet;
    HashMap<String, Object> params;
    public ALFitnessFunction fitness;
    Oracle o;
    ConfigReader cR;
    List<EvaluationPseudoMemory> perRunMemory = new LinkedList<EvaluationPseudoMemory>();
    List<EvaluationPseudoMemory> perDatasetMemory = new LinkedList<EvaluationPseudoMemory>();
    public float mutationCrossRate = 0.6f;
    public float reproduction = 0.7f;
    public List<Mapping> startedMappings;
    public boolean restrictGetAllMaps = true;
    public int maxMaps = 20;

    public void examineGen(int run, int gen, GPGenotype gp, Clock clock) {
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        double fittest = Double.MAX_VALUE;
        IGPProgram pBest = pop.determineFittestProgram();
        fittest = this.fitness.calculateRawFitness(pBest);
        for (GPProgram p : (GPProgram[])pop.getGPPrograms()) {
            double actFit = this.fitness.calculateRawFitness((IGPProgram)p);
            if (!(fittest > actFit) || this.getMetric((IGPProgram)p).getExpression().indexOf("falseProp") != -1) continue;
            pBest = p;
            fittest = actFit;
            System.out.println("Setting to fitter program then JGAP");
        }
        boolean getBetterOld = false;
        for (EvaluationPseudoMemory mem : this.perRunMemory) {
            double oldFit = this.fitness.calculateRawFitness(mem.program);
            if (!(oldFit < fittest)) continue;
            fittest = oldFit;
            pBest = mem.program;
            getBetterOld = true;
        }
        if (getBetterOld) {
            System.out.println("Reusing older program...");
        }
        EvaluationPseudoMemory mem = new EvaluationPseudoMemory(run, gen, this.getMetric(pBest), fittest, clock.totalDuration());
        mem.knownInstances = this.fitness.getReferenceMapping().size();
        mem.program = pBest;
        this.perRunMemory.add(mem);
    }

    public void finishRun() {
        logger.info("Fininshing run...");
        logger.info("size of eval data:" + this.perRunMemory.size());
        for (EvaluationPseudoMemory mem : this.perRunMemory) {
            Mapping fullMap = this.fitness.getMapping(mem.metric.getExpression(), mem.metric.getThreshold(), true);
            PRFComputer pRF = new PRFComputer();
            mem.fmeasue = pRF.computeFScore(fullMap, this.o.getMapping());
            mem.recall = pRF.computeRecall(fullMap, this.o.getMapping());
            mem.precision = pRF.computePrecision(fullMap, this.o.getMapping());
            logger.info("mem" + mem.runTime + "instances" + mem.knownInstances + "\t" + mem.fmeasue);
        }
        this.perDatasetMemory.addAll(this.perRunMemory);
        this.perRunMemory.clear();
    }

    public void finishDataset(int maxRuns, int popSize, int gens, HashMap<String, Object> params, String nameExtension) {
        Collections.sort(this.perDatasetMemory);
        PseudoEvalFileLogger fileLog = new PseudoEvalFileLogger((String)params.get("evalfolder"), (String)params.get("evalfilename"));
        fileLog.nameExtansion = nameExtension;
        fileLog.log(this.perDatasetMemory, maxRuns, gens, params);
        this.perDatasetMemory.clear();
    }

    private Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    public List<Mapping> getMaps(GPPopulation pop) {
        LinkedList<Mapping> allMaps = new LinkedList<Mapping>();
        HashSet<String> expressions = new HashSet<String>();
        LinkedList<IGPProgram> considered = new LinkedList<IGPProgram>();
        int max = pop.size();
        if (this.restrictGetAllMaps) {
            pop.sortByFitness();
            pop.sort((Comparator)new Comparator<IGPProgram>(){

                @Override
                public int compare(IGPProgram o1, IGPProgram o2) {
                    if (o1.getFitnessValue() < o2.getFitnessValue()) {
                        return -1;
                    }
                    if (o1.getFitnessValue() > o2.getFitnessValue()) {
                        return 1;
                    }
                    return 0;
                }
            });
            max = Math.min(this.maxMaps, pop.size());
        }
        for (int i = 0; i < max; ++i) {
            considered.add(pop.getGPProgram(i));
        }
        for (IGPProgram gProg : considered) {
            String expr = "falseProp";
            double d = 0.9;
            try {
                Metric metric = this.getMetric(gProg);
                expr = metric.getExpression();
                d = metric.getThreshold();
            }
            catch (IllegalStateException e) {
                continue;
            }
            if (expr.indexOf("falseProp") > -1) continue;
            if (expressions.contains(expr + d)) {
                ++this.maxMaps;
                continue;
            }
            expressions.add(expr + d);
            try {
                allMaps.add(this.fitness.getMapping(expr, d, true));
            }
            catch (OutOfMemoryError bounded) {
                logger.info("Encountered Memory error...");
            }
        }
        return allMaps;
    }
}

