/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.PseudoFMeasureFitnessFunction;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.oracle.mappingreader.CSVMappingReader;
import de.uni_leipzig.simba.learning.oracle.mappingreader.XMLMappingReader;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import de.uni_leipzig.simba.query.ModelRegistry;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.query.QueryModuleFactory;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tester {
    static Logger log = Logger.getLogger((String)"LIMES");

    public static void main(String[] args) {
        Tester.testOracleReader();
    }

    public static void run(HashMap<String, Object> params, String expression, double threshold) throws InvalidConfigurationException {
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead((String)params.get("basefolder") + params.get("config"));
        Cache sC = (Cache)params.get("sourcecache");
        Cache tC = (Cache)params.get("targetcache");
        Mapping reference = (Mapping)params.get("referencemapping");
        PropertyMapping pM = (PropertyMapping)params.get("propertymapping");
        LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(cR.sourceInfo, cR.targetInfo, pM);
        config.setCrossoverProb(0.4f);
        config.setMutationProb(0.4f);
        config.setReproductionProb(0.4f);
        config.setPopulationSize(100);
        config.setPreservFittestIndividual(true);
        PseudoFMeasureFitnessFunction fitness = PseudoFMeasureFitnessFunction.getInstance(config, new PseudoMeasures(), sC, tC);
        Mapping bestMapping = fitness.getMapping(expression, threshold);
        System.out.println(bestMapping.size());
        PRFComputer prf = new PRFComputer();
        double prec = prf.computePrecision(bestMapping, reference);
        double recall = prf.computeRecall(bestMapping, reference);
        double fMeasure = prf.computeFScore(bestMapping, reference);
        System.out.println("prec=" + prec + " recall=" + recall + " fscore=" + fMeasure);
        System.out.println("best Mapping size:" + bestMapping.size());
    }

    public static void run(ConfigReader cR) {
        HybridCache sC = HybridCache.getData(cR.getSourceInfo());
        HybridCache tC = HybridCache.getData(cR.getTargetInfo());
        LinearFilter f = new LinearFilter();
        SetConstraintsMapper sCM = SetConstraintsMapperFactory.getMapper(cR.executionPlan, cR.sourceInfo, cR.targetInfo, sC, tC, new LinearFilter(), cR.granularity);
        Mapping actualMapping = sCM.getLinks(cR.metricExpression, cR.acceptanceThreshold);
        log.info((Object)("Found " + actualMapping.size() + " links."));
    }

    public static void testModelRegistry() throws FileNotFoundException, UnsupportedEncodingException {
        KBInfo kb = new KBInfo();
        kb.id = "ACM";
        kb.endpoint = "C:\\Users\\Lyko\\workspace\\LIMES\\Examples\\GeneticEval\\Datasets\\DBLP-ACM\\ACM.csv";
        kb.type = "CSV";
        QueryModule qm = QueryModuleFactory.getQueryModule("csv", kb);
        System.out.println(qm);
        Model model = ModelFactory.createDefaultModel();
        RDFReader r = model.getReader(kb.type);
        FileInputStream in = new FileInputStream(kb.endpoint);
        InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF8");
        r.read(model, (Reader)reader, null);
        System.out.println("RDF model read from " + kb.endpoint + " is of size " + model.size());
        ModelRegistry.register(kb.endpoint, model);
        Model model2 = ModelRegistry.getInstance().getMap().get(kb.endpoint);
        System.out.println(model);
        System.out.println(model2);
    }

    public static void readConfigProperties() {
        String configFile = "PublicationData.xml";
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        KBInfo source = cR.getSourceInfo();
        String prefix = source.var;
        if (prefix.startsWith("?") && prefix.length() >= 2) {
            prefix = prefix.substring(1);
        }
        for (String prop : source.properties) {
            System.out.println(prefix + "." + prop);
        }
    }

    public static void testOracleReader() {
        String folder = "C:\\Users\\Lyko\\workspace\\LIMES\\resources\\Persons1\\";
        String xml = "dataset11_dataset12_goldstandard_person.xml";
        String csv = "dataset11_dataset12_goldstandard_person.xml.csv";
        Mapping m = new XMLMappingReader().getMapping(folder + xml);
        Mapping m2 = new CSVMappingReader().getMapping(folder + csv);
        System.out.println(m.size() + " vs. " + m2.size());
    }
}

