/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.filter.LinearFilter;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.mapper.SetConstraintsMapper;
import de.uni_leipzig.simba.mapper.SetConstraintsMapperFactory;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestActualMapping {
    HybridCache fullSource;
    HybridCache fullTarget;
    Mapping fullReference;

    public TestActualMapping(HybridCache source, HybridCache target, Mapping reference) {
        this.fullSource = source;
        this.fullTarget = target;
        this.fullReference = reference;
    }

    public TestActualMapping(ConfigReader cR, String pathToReference) {
        this(HybridCache.getData(cR.sourceInfo), HybridCache.getData(cR.targetInfo), OracleFactory.getOracle(pathToReference, "csv", "simple").getMapping());
    }

    public static HashMap<String, Double> testData(ConfigReader cR, HybridCache sC, HybridCache tC, Mapping optimal, String expression, double accThreshold) {
        HashMap<String, Double> res = new HashMap<String, Double>();
        LinearFilter f = new LinearFilter();
        SetConstraintsMapper sCM = SetConstraintsMapperFactory.getMapper("simple", cR.sourceInfo, cR.targetInfo, sC, tC, f, cR.granularity);
        try {
            Mapping m = sCM.getLinks(expression, accThreshold);
            PRFComputer prfC = new PRFComputer();
            res.put("precision", prfC.computePrecision(m, optimal));
            res.put("recall", prfC.computeRecall(m, optimal));
            res.put("f-score", prfC.computeFScore(m, optimal));
        }
        catch (OutOfMemoryError e) {
            res.put("precision", Double.NaN);
            res.put("recall", Double.NaN);
            res.put("f-score", Double.NaN);
        }
        return res;
    }

    public HashMap<String, Double> testData(ConfigReader cR, String expression, double accThreshold) {
        return TestActualMapping.testData(cR, this.fullSource, this.fullTarget, this.fullReference, expression, accThreshold);
    }
}

