/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.statistics;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.util.Clock;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.ProgramChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImprovedBatchEvaluation {
    public static final String SEP = ";";
    int gens = 50;
    static int RUNS = 5;
    int inqueries = 10;
    int examplesPerInquiry = 10;
    public float mutation = 0.6f;
    public float crossover = 0.6f;
    public float mutationCrossRate = 0.6f;
    public float reproduction = 0.7f;
    static final Logger logger = Logger.getLogger((String)"LIMES");

    public static void main(String[] args) {
        DataSetChooser.DataSets[] datas = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.DBPLINKEDMDB, DataSetChooser.DataSets.DRUGS, DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.AMAZONGOOGLE, DataSetChooser.DataSets.DBLPSCHOLAR};
        try {
            for (DataSetChooser.DataSets data : datas) {
                for (int population = 20; population <= 100; population += 80) {
                    ImprovedBatchEvaluation learner = new ImprovedBatchEvaluation();
                    learner.run(data, RUNS, population, 10, 10);
                }
            }
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void run(DataSetChooser.DataSets data, int numberOfRuns, int popSize, int numberOfInqueries, int questionsperInquery) throws InvalidConfigurationException {
        logger.info((Object)("Running dataset " + (Object)((Object)data)));
        HashMap<String, Object> params = DataSetChooser.getData(data);
        String name = "" + params.get("evalfolder") + ((String)params.get("evalfilename")).replaceAll("Pseudo_eval_", "_BATCH_pop=" + popSize + "_");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead("" + params.get("basefolder") + params.get("config"));
        String verificationFile = "" + params.get("basefolder") + params.get("datasetfolder") + params.get("reference");
        Oracle o = OracleFactory.getOracle(verificationFile, verificationFile.substring(verificationFile.lastIndexOf(".") + 1), "simple");
        File evalFile = null;
        try {
            evalFile = this.createFile(name, popSize, numberOfRuns);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int inquery = 1; inquery <= numberOfInqueries; ++inquery) {
            LinkedList<EvaluationPseudoMemory> perInqery = new LinkedList<EvaluationPseudoMemory>();
            for (int run = 1; run <= numberOfRuns; ++run) {
                EvaluationPseudoMemory memOfRun = this.run(params, cR, o, run, popSize, inquery, questionsperInquery);
                perInqery.add(memOfRun);
            }
            if (evalFile != null) {
                try {
                    this.writeEntry(evalFile, o.getMapping(), perInqery);
                }
                catch (IOException e) {
                    logger.error((Object)("Unable to write file: " + name));
                    e.printStackTrace();
                    System.exit(1);
                }
                continue;
            }
            logger.error((Object)("Unable to write file: " + name));
            System.exit(1);
        }
    }

    public void runRest(String nameExpansion, DataSetChooser.DataSets data, int numberOfRuns, int popSize, int concreteInquiry, int questionsperInquery) throws InvalidConfigurationException {
        logger.info((Object)("Running dataset " + (Object)((Object)data)));
        HashMap<String, Object> params = DataSetChooser.getData(data);
        String name = "" + params.get("evalfolder") + ((String)params.get("evalfilename")).replaceAll("Pseudo_eval_", "_" + nameExpansion + "_BATCH_pop=" + popSize + "_");
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead("" + params.get("basefolder") + params.get("config"));
        String verificationFile = "" + params.get("basefolder") + params.get("datasetfolder") + params.get("reference");
        Oracle o = OracleFactory.getOracle(verificationFile, verificationFile.substring(verificationFile.lastIndexOf(".") + 1), "simple");
        File evalFile = null;
        try {
            evalFile = this.createFile(name, popSize, numberOfRuns);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LinkedList<EvaluationPseudoMemory> perInqery = new LinkedList<EvaluationPseudoMemory>();
        for (int run = 1; run <= numberOfRuns; ++run) {
            EvaluationPseudoMemory memOfRun = this.run(params, cR, o, run, popSize, concreteInquiry, questionsperInquery);
            perInqery.add(memOfRun);
        }
        if (evalFile != null) {
            try {
                this.writeEntry(evalFile, o.getMapping(), perInqery);
            }
            catch (IOException e) {
                logger.error((Object)("Unable to write file: " + name));
                e.printStackTrace();
                System.exit(1);
            }
        } else {
            logger.error((Object)("Unable to write file: " + name));
            System.exit(1);
        }
    }

    private void writeEntry(File evalFile, Mapping reference, List<EvaluationPseudoMemory> data) throws IOException {
        statistics oracle = new statistics();
        statistics fitness = new statistics();
        statistics fscore = new statistics();
        statistics prec = new statistics();
        statistics recall = new statistics();
        statistics duration = new statistics();
        FileWriter writer = new FileWriter(evalFile, true);
        int gen = 0;
        for (EvaluationPseudoMemory mem : data) {
            gen = mem.generation;
            oracle.add(mem.knownInstances);
            fitness.add(mem.fitness);
            PRFComputer prfc = new PRFComputer();
            fscore.add(prfc.computeFScore(mem.fullMapping, reference));
            prec.add(prfc.computePrecision(mem.fullMapping, reference));
            recall.add(prfc.computeRecall(mem.fullMapping, reference));
            duration.add(mem.runTime);
        }
        String line = "" + gen + SEP + oracle.mean + SEP + oracle.standardDeviation + SEP + fitness.mean + SEP + fitness.standardDeviation + SEP + fscore.mean + SEP + fscore.standardDeviation + SEP + prec.mean + SEP + prec.mean + SEP + recall.mean + SEP + recall.standardDeviation + SEP + duration.mean + SEP + duration.standardDeviation;
        writer.write(line);
        writer.write(System.getProperty("line.separator"));
        writer.flush();
        writer.close();
    }

    private File createFile(String name, int popSize, int runs) throws IOException {
        File file = new File(name);
        FileWriter writer = new FileWriter(file, false);
        String head = "population= " + popSize + " runs= " + runs;
        writer.write(head);
        writer.write(System.getProperty("line.separator"));
        head = "gen;oralce;oracle_std;fitness;fitness_std;f-score;f-score_std;prec;prec_std;recall;recall_std;duration;duration_std";
        writer.write(head);
        writer.write(System.getProperty("line.separator"));
        writer.flush();
        writer.close();
        return file;
    }

    private EvaluationPseudoMemory run(HashMap<String, Object> param, ConfigReader cR, Oracle o, int run, int popSize, int inquery, int questionsperInquery) throws InvalidConfigurationException {
        String name = ((String)param.get("evalfilename")).replaceAll("Pseudo_eval_", "_BATCH_");
        param.put("evalfilename", name);
        LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(cR.sourceInfo, cR.targetInfo, (PropertyMapping)param.get("propertymapping"));
        config.setSelectFromPrevGen(this.reproduction);
        config.setCrossoverProb(this.mutationCrossRate);
        config.setMutationProb(this.mutationCrossRate);
        config.setReproductionProb(this.reproduction);
        config.setPopulationSize(popSize);
        config.setPreservFittestIndividual(true);
        config.setAlwaysCaculateFitness(true);
        int oralceSize = inquery * questionsperInquery;
        Mapping trainingData = ExampleOracleTrimmer.trimExamplesRandomly(o.getMapping(), oralceSize);
        ExpressionFitnessFunction fitness = ExpressionFitnessFunction.getInstance(config, o.getMapping(), "f-score", oralceSize);
        fitness.trimKnowledgeBases(trainingData);
        config.setFitnessFunction(fitness);
        ExpressionProblem gpP = new ExpressionProblem(config);
        GPGenotype gp = gpP.create();
        Clock clock = new Clock();
        for (int gen = 1; gen <= this.gens * inquery; ++gen) {
            gp.evolve();
        }
        IGPProgram bestProgram = this.processRun(gp, fitness);
        Metric bestMetric = this.getMetric(bestProgram);
        EvaluationPseudoMemory mem = new EvaluationPseudoMemory(run, this.gens * inquery, bestMetric, fitness.calculateRawFitness(bestProgram), clock.totalDuration());
        mem.program = bestProgram;
        mem.knownInstances = trainingData.size();
        mem.fullMapping = fitness.getMapping(bestMetric.getExpression(), bestMetric.getThreshold(), true);
        fitness.destroy();
        fitness = null;
        LinkSpecGeneticLearnerConfig.reset();
        return mem;
    }

    private Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    private IGPProgram processRun(GPGenotype gp, ExpressionFitnessFunction fitness) {
        LinkedList<IGPProgram> bests = new LinkedList<IGPProgram>();
        bests.add(gp.getAllTimeBest());
        bests.add(gp.getFittestProgram());
        bests.add(gp.getFittestProgramComputed());
        GPPopulation pop = gp.getGPPopulation();
        IGPProgram pBest = pop.determineFittestProgram();
        double bestFit = fitness.calculateRawFitness(pBest);
        for (IGPProgram p : bests) {
            if (p == null || !(fitness.calculateRawFitness(p) < bestFit) || !(fitness.calculateRawFitness(p) >= 0.0)) continue;
            bestFit = fitness.calculateRawFitness(p);
            pBest = p;
        }
        return pBest;
    }
}

