/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public class ExampleOracleTrimmer {
    Mapping reference = new Mapping();

    public static Mapping trimExamples(Oracle pM, int max) {
        Mapping m = pM.getMapping();
        Mapping output = new Mapping();
        HashMap<String, HashMap<String, Double>> map = m.map;
        int count = 0;
        for (Map.Entry<String, HashMap<String, Double>> e : map.entrySet()) {
            if (count >= max) break;
            String key = e.getKey();
            HashMap<String, Double> value = e.getValue();
            output.add(key, value);
            ++count;
        }
        return output;
    }

    public static Mapping trimExamplesRandomly(Mapping m, int max) {
        Mapping output = new Mapping();
        while (output.size() < max) {
            String target;
            String key;
            Random rand = new Random(System.currentTimeMillis());
            if (m.map.keySet().size() <= 0 || !m.map.get(key = m.map.keySet().toArray(new String[0])[rand.nextInt(m.map.keySet().size())]).keySet().iterator().hasNext() || output.contains(key, target = m.map.get(key).entrySet().iterator().next().getKey())) continue;
            output.add(key, target, m.getSimilarity(key, target));
        }
        return output;
    }

    public static HybridCache[] processData(HybridCache hc1, HybridCache hc2, Mapping m) {
        Logger logger = Logger.getLogger((String)"LIMES");
        if (m.size < 100) {
            logger.info((Object)("Scaling Caches down to " + m));
        }
        HybridCache[] ret = new HybridCache[2];
        HybridCache h1 = new HybridCache();
        HybridCache h2 = new HybridCache();
        HashMap<String, HashMap<String, Double>> map = m.map;
        for (Map.Entry<String, HashMap<String, Double>> e : map.entrySet()) {
            String key = e.getKey();
            Instance i = hc1.getInstance(key);
            if (i == null) {
                logger.info((Object)("unable to find instance with key " + key));
                continue;
            }
            h1.addInstance(i);
            HashMap<String, Double> value = e.getValue();
            for (Map.Entry<String, Double> e2 : value.entrySet()) {
                Instance j = hc2.getInstance(e2.getKey());
                if (j != null) {
                    h2.addInstance(j);
                    continue;
                }
                logger.info((Object)("unable to find instance with key " + e2.getKey()));
            }
        }
        ret[0] = h1;
        ret[1] = h2;
        return ret;
    }

    public HybridCache[] processDataEqually(HybridCache hc1, HybridCache hc2, Oracle o, int numberOfQuestions) {
        this.reference.map.clear();
        HybridCache[] ret = new HybridCache[2];
        HybridCache h1 = new HybridCache();
        HybridCache h2 = new HybridCache();
        int countQuestions = 0;
        Mapping alreadyAsked = new Mapping();
        ArrayList<String> uris1 = hc1.getAllUris();
        ArrayList<String> uris2 = hc2.getAllUris();
        while (countQuestions < numberOfQuestions) {
            String uri2;
            Random random = new Random(System.currentTimeMillis());
            String uri1 = uris1.get(random.nextInt(uris1.size()));
            if (alreadyAsked.contains(uri1, uri2 = uris2.get(random.nextInt(uris2.size())))) continue;
            h1.addInstance(hc1.getInstance(uri1));
            h2.addInstance(hc2.getInstance(uri2));
            ++countQuestions;
            if (!o.ask(uri1, uri2)) continue;
            this.reference.add(uri1, uri2, 1.0);
        }
        ret[0] = h1;
        ret[1] = h2;
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.info((Object)("asking random " + numberOfQuestions + " questions got me " + this.reference.size() + " valid links"));
        if (this.reference.size < numberOfQuestions / 2) {
            Mapping ref2 = ExampleOracleTrimmer.trimExamplesRandomly(o.getMapping(), numberOfQuestions / 2);
            HybridCache[] adding = ExampleOracleTrimmer.processData(hc1, hc2, ref2);
            HashMap<String, HashMap<String, Double>> map = ref2.map;
            for (Map.Entry<String, HashMap<String, Double>> e : map.entrySet()) {
                this.reference.add(e.getKey(), e.getValue());
            }
            for (Instance i : adding[0].getAllInstances()) {
                ret[0].addInstance(i);
            }
            for (Instance i : adding[1].getAllInstances()) {
                ret[1].addInstance(i);
            }
            logger.info((Object)("adding " + ref2.size() + " valid links and instances."));
        }
        return ret;
    }

    public static void main(String[] args) {
        String configFile = "Examples/GeneticEval/PublicationData.xml";
        String file = "Examples/GeneticEval/Datasets/DBLP-ACM/DBLP-ACM_perfectMapping.csv";
        configFile = "Examples/GeneticEval/DBLP-Scholar.xml";
        file = "Examples/GeneticEval/Datasets/DBLP-Scholar/DBLP-Scholar_perfectMapping.csv";
        Oracle o = OracleFactory.getOracle(file, "csv", "simple");
        o.getMapping();
        ExampleOracleTrimmer trimmer = new ExampleOracleTrimmer();
        Mapping res = ExampleOracleTrimmer.trimExamples(o, 10);
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        HybridCache sC = HybridCache.getData(cR.getSourceInfo());
        HybridCache rC = HybridCache.getData(cR.getTargetInfo());
        HybridCache[] caches = trimmer.processDataEqually(sC, rC, o, 50);
        System.out.println(trimmer.getReferenceMapping().size());
        System.out.println("Cache 1: ");
        System.out.println(caches[0].size());
        System.out.println("Cache 2: ");
        System.out.println(caches[1].size());
    }

    public Mapping getReferenceMapping() {
        return this.reference;
    }
}

