/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class EvalLogger {
    private static String folder = "testResults";
    private FileWriter writer;
    private File file;
    private String fileName;
    private static EvalLogger instance = null;

    private EvalLogger(String path) {
        this.setFileName(path);
        this.file = new File(folder + "/" + path);
    }

    public static EvalLogger getInstance() {
        if (instance == null) {
            instance = new EvalLogger("GeneticLog.txt");
        }
        return instance;
    }

    public void createFile(String name) {
        this.file = new File(folder + "/" + name);
        try {
            this.writer = new FileWriter(this.file);
            String out = "Gen\tFitness\tfScore\trecall\tprecision\tExpression";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String solution, double fitness, double fScore, int gen) {
        try {
            this.writer = new FileWriter(this.file, true);
            String out = gen + "\"\t" + fitness + "\t" + fScore + "\t\"" + solution;
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeComplete(int nr, String solution, double fitness, double fScore, double recall, double prec) {
        try {
            this.writer = new FileWriter(this.file, true);
            String out = nr + "\"\t" + fitness + "\t" + fScore + "\t" + recall + "\t" + prec + "\t\"" + solution;
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeString(String str) {
        try {
            this.writer = new FileWriter(this.file, true);
            this.writer.write(str);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

