/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;
import org.apache.log4j.Logger;

public class EvalFileLoggerComplete {
    static Logger logger = Logger.getLogger((String)"Limes");
    private static String folder = "testResults";
    private FileWriter writer;
    private File file;
    private String fileName;
    private static EvalFileLoggerComplete instance = null;
    public static final String SEP = ";";

    private EvalFileLoggerComplete(String path) {
        this.setFileName(path);
        this.file = new File(folder + "/" + path);
    }

    public static EvalFileLoggerComplete getInstance() {
        if (instance == null) {
            instance = new EvalFileLoggerComplete("GeneticLog.txt");
        }
        return instance;
    }

    public void createFile(String name) {
        String subFolder = name.substring(0, name.lastIndexOf("/"));
        logger.info((Object)("name=" + name));
        logger.info((Object)("subFolder=" + subFolder));
        String fileName = subFolder + "/" + folder + name.substring(name.lastIndexOf("/"), name.indexOf("_")) + name.substring(name.lastIndexOf("/"));
        logger.info((Object)("FilePath=" + fileName));
        this.file = new File(fileName);
        try {
            if (!this.fileExists(fileName)) {
                this.writer = new FileWriter(this.file, true);
                String out = "Cycle;Gen;averageFitness;Fitness;fScore;recall;precision;oracleSize;duration;Expression";
                this.writer.write(out);
                this.writer.write(System.getProperty("line.separator"));
                this.writer.flush();
            } else {
                this.writer = new FileWriter(this.file, true);
            }
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeComplete(int cycle, long duration, int nr, double avgFit, String solution, double fitness, double fScore, double recall, double prec, int oracleSize) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        df.applyPattern("#,###,######0.00000");
        try {
            this.writer = new FileWriter(this.file, true);
            String out = cycle + "" + SEP + "" + nr + "" + SEP + "" + df.format(avgFit) + "" + SEP + "" + df.format(fitness) + "" + SEP + "" + df.format(fScore) + "" + SEP + "" + df.format(recall) + "" + SEP + "" + df.format(prec) + "" + SEP + "" + oracleSize + "" + SEP + "" + duration + "" + SEP + "\"" + solution + "\"";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeString(String str) {
        try {
            this.writer = new FileWriter(this.file, true);
            this.writer.write(str);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean fileExists(String name) {
        this.file = new File(name);
        return this.file.exists();
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

