/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Locale;

public class EvalFileLogger {
    private FileWriter writer;
    private File file;
    private String fileName;
    private static EvalFileLogger instance = null;
    public static final String SEP = ";";

    private EvalFileLogger(String path) {
        this.setFileName(path);
        this.file = new File(path);
    }

    public static EvalFileLogger getInstance() {
        if (instance == null) {
            instance = new EvalFileLogger("GeneticLog.txt");
        }
        return instance;
    }

    public void createFile(String folder, String name, boolean override) {
        if (!folder.substring(folder.length() - 2).equalsIgnoreCase("/")) {
            folder = folder + "/";
        }
        this.file = new File(folder + name);
        try {
            this.writer = new FileWriter(this.file, !override);
            String out = "Gen;averageFitness;Fitness;fScore;recall;precision;Expression";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String solution, double fitness, double fScore, int gen) {
        try {
            this.writer = new FileWriter(this.file, true);
            String out = gen + "" + SEP + "" + fitness + "" + SEP + "" + fScore + "" + SEP + "\"" + solution + "\"";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeComplete(int nr, double avgFit, String solution, double fitness, double fScore, double recall, double prec) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        df.applyPattern("#,###,######0.00000");
        try {
            this.writer = new FileWriter(this.file, true);
            String out = nr + "" + SEP + "" + df.format(avgFit) + "" + SEP + "" + df.format(fitness) + "" + SEP + "" + df.format(fScore) + "" + SEP + "" + df.format(recall) + "" + SEP + "" + df.format(prec) + "" + SEP + "\"" + solution + "\"";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeWithDuration(int nr, double avgFit, String solution, double fitness, double fScore, double recall, double prec, long dur) {
        DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance(Locale.ENGLISH);
        df.applyPattern("#,###,######0.00000");
        try {
            this.writer = new FileWriter(this.file, true);
            String out = nr + "" + SEP + "" + df.format(avgFit) + "" + SEP + "" + df.format(fitness) + "" + SEP + "" + df.format(fScore) + "" + SEP + "" + df.format(recall) + "" + SEP + "" + df.format(prec) + "" + SEP + "" + dur + "" + SEP + "\"" + solution + "\"";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeString(String str) {
        try {
            this.writer = new FileWriter(this.file, true);
            this.writer.write(str);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean fileExists(String name) {
        this.file = new File(name);
        return this.file.exists();
    }

    public void writeHead() {
        try {
            this.writer = new FileWriter(this.file, true);
            String out = "Gen;averageFitness;Fitness;fScore;recall;precision;duration;Expression";
            this.writer.write(out);
            this.writer.write(System.getProperty("line.separator"));
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }
}

