/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.DatasetChooser;
import de.uni_leipzig.simba.genetics.evaluation.EvalFileLoggerComplete;
import de.uni_leipzig.simba.genetics.evaluation.EvalLogMem;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.genetics.evaluation.TestActualMapping;
import de.uni_leipzig.simba.genetics.util.PropMapper;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.util.Clock;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;

public class BatchMainComplete {
    static Logger logger1 = Logger.getLogger((String)"LIMES");
    static Logger logger = Logger.getLogger((String)"Genetics");
    List<EvalLogMem> logMem = new LinkedList<EvalLogMem>();
    String measure = "f-score";
    String verificationFile;
    int oracleSize;
    LinkSpecGeneticLearnerConfig config;
    int actualOracleSize;
    ExpressionFitnessFunction fF;
    Clock clock;
    private ConfigReader cR;
    private Oracle o;

    public static void main(String[] args) throws InvalidConfigurationException {
        int generations = 50;
        if (args.length < 1) {
            for (int dataset = 2; dataset >= 0; --dataset) {
                BatchMainComplete runner = new BatchMainComplete();
                runner.runBaseLine(dataset, generations);
            }
        } else if (args.length == 1) {
            generations = Integer.parseInt(args[0]);
            for (int dataset = 2; dataset >= 0; --dataset) {
                BatchMainComplete runner = new BatchMainComplete();
                runner.runBaseLine(dataset, generations);
            }
        } else if (args.length == 2) {
            int dataset = Integer.parseInt(args[0]);
            generations = Integer.parseInt(args[1]);
            BatchMainComplete runner = new BatchMainComplete();
            runner.runBaseLine(dataset, generations);
        }
    }

    public void runBaseLine(int dataset, int generations) {
        logger.setLevel(Level.WARN);
        String pathToConfig = DatasetChooser.getDataset(dataset)[0];
        this.verificationFile = DatasetChooser.getDataset(dataset)[1];
        int numberOfExamples = 0;
        int popSize = 10;
        float crossoverProb = 0.6f;
        float mutationProb = 0.6f;
        float reproductionProb = 0.7f;
        for (popSize = 20; popSize <= 100; popSize += 80) {
            for (int ex = 10; ex <= 100; ex += 10) {
                numberOfExamples = ex;
                int gens = generations * (numberOfExamples / 10);
                for (int cycle = 0; cycle < 5; ++cycle) {
                    try {
                        mutationProb = crossoverProb;
                        logger.info((Object)("Running " + pathToConfig + " Pop=" + popSize + " Gen=" + gens + " oracleSize=" + numberOfExamples + " Mutation=" + mutationProb + " crossoverProb=" + crossoverProb));
                        this.run(pathToConfig, this.verificationFile, popSize, gens, numberOfExamples, mutationProb, crossoverProb, reproductionProb, cycle);
                        continue;
                    }
                    catch (InvalidConfigurationException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void run(String configFile, String verificationFile, int popSize, int gens, int numberOfExamples, float mutation, float crossover, float reproduction, int cycle) throws InvalidConfigurationException {
        this.oracleSize = numberOfExamples;
        this.measure = "f-score";
        this.clock = new Clock();
        logger.info((Object)("Running cycle " + cycle + " on " + configFile.substring(0, configFile.lastIndexOf(".")) + " pop=" + popSize + " gens=" + gens + " examples=" + numberOfExamples + " mutation=" + mutation));
        EvalFileLoggerComplete fileLog = EvalFileLoggerComplete.getInstance();
        String name = configFile.substring(0, configFile.lastIndexOf(".")) + "_pop=" + popSize + ".csv";
        fileLog.createFile(name);
        this.cR = new ConfigReader();
        this.cR.validateAndRead(configFile);
        this.config = new LinkSpecGeneticLearnerConfig(this.cR.sourceInfo, this.cR.targetInfo, PropMapper.getPropertyMapping(configFile));
        this.config.setCrossoverProb(crossover);
        this.config.setMutationProb(mutation);
        this.config.setReproductionProb(reproduction);
        this.config.setPopulationSize(popSize);
        this.o = OracleFactory.getOracle(verificationFile, "csv", "simple");
        logger.info((Object)("Trying to get fitness with oracleSize " + this.oracleSize));
        this.fF = ExpressionFitnessFunction.getInstance(this.config, this.o, "f-score", this.oracleSize);
        Mapping ref = ExampleOracleTrimmer.trimExamplesRandomly(this.o.getMapping(), this.oracleSize);
        logger.info((Object)("Trimmed Oracle to " + ref.size() + " instances."));
        this.fF.setReferenceMapping(ref);
        this.fF.trimKnowledgeBases(ref);
        this.actualOracleSize = ref.size();
        this.config.setFitnessFunction(this.fF);
        ExpressionProblem gpP = new ExpressionProblem(this.config);
        GPGenotype gp = gpP.create();
        for (int i = 0; i < gens; ++i) {
            this.examineGen(i, gp);
        }
        EvalLogMem best = this.processRun(gens, gp);
        this.writeInstance(cycle, this.clock.durationSinceClick(), best);
        logger.info((Object)("Finished run " + cycle + " pop =" + popSize + " on " + configFile.substring(0, configFile.lastIndexOf("."))));
        this.fF.destroy();
        Configuration.reset();
        this.config = null;
        this.logMem.clear();
        this.fF = null;
    }

    private EvalLogMem processRun(int gens, GPGenotype gp) {
        EvalLogMem bestOverAll = this.getBest();
        bestOverAll.gen = gens / 50;
        return bestOverAll;
    }

    private EvalLogMem getBest() {
        EvalLogMem fittestEver = null;
        double fittest = Double.MAX_VALUE;
        for (EvalLogMem log : this.logMem) {
            if (!(fittest > log.fitness) || this.getMetric(log.fittestProg).getExpression().indexOf("falseProp") != -1) continue;
            fittestEver = log;
            fittest = log.fitness;
        }
        return fittestEver;
    }

    private void examineGen(int gNum, GPGenotype gp) {
        Metric met_fit;
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        GPProgram fittest = (GPProgram)gp.getFittestProgram();
        BatchMainComplete.printPopulation(gNum, gp);
        double fit = Double.MAX_VALUE;
        if (fittest != null && (met_fit = this.getMetric((IGPProgram)fittest)).isValid()) {
            fit = this.fF.calculateRawFitness((IGPProgram)fittest);
        }
        for (GPProgram p : (GPProgram[])pop.getGPPrograms()) {
            double actFit = this.fF.calculateRawFitness((IGPProgram)p);
            if (!(fit > actFit) || !this.getMetric((IGPProgram)p).isValid()) continue;
            fit = actFit;
            fittest = p;
        }
        double avgFitness = 0.0;
        avgFitness = gp.getTotalFitness();
        this.logMem.add(new EvalLogMem(gNum, (IGPProgram)fittest, this.fF.calculateRawFitness((IGPProgram)fittest), avgFitness));
    }

    private void writeInstance(int cycle, long dur, EvalLogMem best) {
        Object[] args = new Object[]{};
        EvalFileLoggerComplete fileLog = EvalFileLoggerComplete.getInstance();
        ProgramChromosome pc = best.fittestProg.getChromosome(0);
        String expr = "";
        double d = 0.99;
        try {
            Metric metric = (Metric)pc.getNode(0).execute_object(pc, 0, args);
            expr = metric.getExpression();
            d = metric.getThreshold();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (expr.indexOf("falseProp") > -1) {
            fileLog.writeComplete(cycle, dur, best.gen, best.avgFitness, expr + ">=" + d, best.fitness, 0.0, 0.0, 0.0, this.oracleSize);
        } else {
            HashMap<String, Double> res = TestActualMapping.testData(this.cR, this.fF.getSourceCache(), this.fF.getTargetCache(), this.o.getMapping(), expr, d);
            fileLog.writeComplete(cycle, dur, best.gen, best.avgFitness, expr + ">=" + d, best.fitness, res.get("f-score"), res.get("recall"), res.get("precision"), this.actualOracleSize);
        }
    }

    private static void printPopulation(int generation, GPGenotype gt) {
        logger.info((Object)(generation + "th Generation"));
        GPPopulation gp = gt.getGPPopulation();
        gp.sortByFitness();
        LinkedList<String> allProgs = new LinkedList<String>();
        for (int i = 0; i < gp.size(); ++i) {
            GPProgram gProg = (GPProgram)gp.getGPProgram(i);
            Object[] args = new Object[]{};
            ProgramChromosome pc = gProg.getChromosome(0);
            String expr = "";
            double d = 0.99;
            try {
                Metric metric = (Metric)pc.getNode(0).execute_object(pc, 0, args);
                expr = metric.getExpression();
                d = metric.getThreshold();
            }
            catch (IllegalStateException e) {
                continue;
            }
            String out = i + ". Program : " + expr + " >= " + d + "\n\t" + gProg.getFitnessValue();
            if (!(gProg.getFitnessValue() <= 1.0)) continue;
            allProgs.add(out);
        }
    }

    public Metric getMetric(IGPProgram p) {
        if (p == null) {
            logger.info((Object)"p is null!!!!");
        }
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResourceTerminalType {
        SOURCE(1),
        TARGET(2),
        THRESHOLD(3),
        SOURCENUMBER(4),
        TARGETNUMBER(5),
        NUMBERTHRESHOLD(6);

        private int m_value;

        public int intValue() {
            return this.m_value;
        }

        private ResourceTerminalType(int a_value) {
            this.m_value = a_value;
        }
    }
}

