/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.PseudoEvalFileLogger;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchEvaluation {
    public static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    public static final int RUNS = 5;
    public static final int oracleQuestions = 10;
    public DataSetChooser.DataSets currentDataSet;
    HashMap<String, Object> params;
    public ExpressionFitnessFunction fitness;
    Oracle o;
    ConfigReader cR;
    List<EvaluationPseudoMemory> perDatasetMemory = new LinkedList<EvaluationPseudoMemory>();
    private float mutationCrossRate = 0.6f;
    private float reproduction = 0.7f;
    Clock clock;

    public void run(DataSetChooser.DataSets data, int popSize, int gens, int inqueries, int questions) throws InvalidConfigurationException {
        logger.info("Running dataset " + (Object)((Object)data));
        this.currentDataSet = data;
        this.params = DataSetChooser.getData(data);
        String name = ((String)this.params.get("evalfilename")).replaceAll("Pseudo_eval_", "_BATCH_");
        this.params.put("evalfilename", name);
        this.cR = new ConfigReader();
        this.cR.validateAndRead("" + this.params.get("basefolder") + this.params.get("config"));
        String verificationFile = "" + this.params.get("basefolder") + this.params.get("datasetfolder") + this.params.get("reference");
        this.o = OracleFactory.getOracle(verificationFile, verificationFile.substring(verificationFile.lastIndexOf(".") + 1), "simple");
        for (int inquery = 1; inquery <= inqueries; ++inquery) {
            for (int run = 1; run <= 5; ++run) {
                LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(this.cR.sourceInfo, this.cR.targetInfo, (PropertyMapping)this.params.get("propertymapping"));
                config.setSelectFromPrevGen(this.reproduction);
                config.setCrossoverProb(this.mutationCrossRate);
                config.setMutationProb(this.mutationCrossRate);
                config.setReproductionProb(this.reproduction);
                config.setPopulationSize(popSize);
                config.setPreservFittestIndividual(true);
                config.setAlwaysCaculateFitness(true);
                Mapping trainingData = ExampleOracleTrimmer.trimExamplesRandomly(this.o.getMapping(), inquery * questions);
                this.fitness = ExpressionFitnessFunction.getInstance(config, this.o.getMapping(), "f-score", inquery * questions);
                this.fitness.setReferenceMapping(trainingData);
                this.fitness.trimKnowledgeBases(trainingData);
                config.setFitnessFunction(this.fitness);
                ExpressionProblem gpP = new ExpressionProblem(config);
                GPGenotype gp = gpP.create();
                this.clock = new Clock();
                for (int gen = 1; gen <= gens * inquery; ++gen) {
                    gp.evolve();
                }
                this.processRun(gp, run, gens * inquery, trainingData.size());
                this.fitness.destroy();
                LinkSpecGeneticLearnerConfig.reset();
            }
        }
        this.finishDataSet(popSize, gens);
    }

    private void finishDataSet(int popSize, int gens) {
        Collections.sort(this.perDatasetMemory);
        PseudoEvalFileLogger fileLog = new PseudoEvalFileLogger((String)this.params.get("evalfolder"), (String)this.params.get("evalfilename"));
        fileLog.nameExtansion = "Batch_pop=" + popSize + "_gens=" + gens;
        fileLog.log(this.perDatasetMemory, 5, gens, this.params);
        this.perDatasetMemory.clear();
    }

    private void processRun(GPGenotype gp, int run, int gens, int trainingSize) {
        LinkedList<IGPProgram> bests = new LinkedList<IGPProgram>();
        bests.add(gp.getAllTimeBest());
        bests.add(gp.getFittestProgram());
        bests.add(gp.getFittestProgramComputed());
        GPPopulation pop = gp.getGPPopulation();
        IGPProgram pBest = pop.determineFittestProgram();
        double bestFit = this.fitness.calculateRawFitness(pBest);
        for (IGPProgram p : bests) {
            if (p == null || !(this.fitness.calculateRawFitness(p) < bestFit)) continue;
            bestFit = this.fitness.calculateRawFitness(p);
            pBest = p;
        }
        Metric m = this.fitness.getMetric(pBest);
        EvaluationPseudoMemory mem = new EvaluationPseudoMemory(run, gens, m, bestFit, this.clock.totalDuration());
        mem.knownInstances = trainingSize;
        mem.program = pBest;
        Mapping full = this.fitness.getMapping(mem.metric.getExpression(), mem.metric.getThreshold(), true);
        PRFComputer comp = new PRFComputer();
        double fM = comp.computeFScore(full, this.o.getMapping());
        double rec = comp.computeRecall(full, this.o.getMapping());
        double prec = comp.computePrecision(full, this.o.getMapping());
        mem.fmeasue = fM != Double.NaN ? fM : 0.0;
        mem.recall = rec != Double.NaN ? rec : 0.0;
        mem.precision = prec != Double.NaN ? prec : 0.0;
        this.perDatasetMemory.add(mem);
    }

    public static void main(String[] args) {
        DataSetChooser.DataSets[] datas = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.DBLPACM, DataSetChooser.DataSets.ABTBUY, DataSetChooser.DataSets.AMAZONGOOGLE, DataSetChooser.DataSets.DBLPSCHOLAR};
        try {
            for (DataSetChooser.DataSets data : datas) {
                BatchEvaluation evaluation = new BatchEvaluation();
                evaluation.run(data, 20, 50, 10, 10);
            }
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

