/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.ExpressionFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.EvalFileLogger;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.DataSetChooser;
import de.uni_leipzig.simba.genetics.evaluation.pseudomeasures.EvaluationPseudoMemory;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Baseliner {
    Logger logger = Logger.getLogger((String)"LIMES");
    String configFile;
    String verificationFile;
    public static int pop = 20;
    public static int gens = 100;
    float mutCross = 0.6f;
    float reprod = 0.7f;
    Clock clock;
    LinkSpecGeneticLearnerConfig config;
    ExpressionFitnessFunction fF;
    Cache sC;
    Cache tC;
    List<EvaluationPseudoMemory> memList;
    ConfigReader cR;
    Mapping reference;
    IGPProgram bestEver;
    double bestEverFitness = Double.MAX_VALUE;

    public static void main(String[] args) {
        if (args.length == 2) {
            DataSetChooser.DataSets d = DataSetChooser.DataSets.DBPLINKEDMDB;
            int gen = Integer.parseInt(args[0]);
            int pop = Integer.parseInt(args[1]);
            Baseliner bL = new Baseliner();
            try {
                gens = gen;
                Baseliner.pop = pop;
                HashMap<String, Object> params = DataSetChooser.getData(d);
                params.put("evalfilename", "BaseLine_" + pop + "pop_" + gen + "gens_" + (Object)((Object)d) + ".csv");
                bL.run(params);
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            DataSetChooser.DataSets[] data;
            for (DataSetChooser.DataSets d : data = new DataSetChooser.DataSets[]{DataSetChooser.DataSets.DBPLINKEDMDB, DataSetChooser.DataSets.PERSON1, DataSetChooser.DataSets.RESTAURANTS}) {
                Baseliner liner = new Baseliner();
                try {
                    HashMap<String, Object> params = DataSetChooser.getData(d);
                    params.put("evalfilename", "BaseLine_" + pop + "pop_" + gens + "gens_" + (Object)((Object)d) + ".csv");
                    liner.run(params);
                }
                catch (InvalidConfigurationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void run(HashMap<String, Object> params) throws InvalidConfigurationException {
        this.memList = new LinkedList<EvaluationPseudoMemory>();
        this.clock = new Clock();
        this.cR = new ConfigReader();
        this.cR.validateAndRead((String)params.get("basefolder") + params.get("config"));
        PropertyMapping propMap = (PropertyMapping)params.get("propertymapping");
        this.sC = (Cache)params.get("sourcecache");
        this.tC = (Cache)params.get("targetcache");
        this.reference = (Mapping)params.get("referencemapping");
        this.config = new LinkSpecGeneticLearnerConfig(this.cR.sourceInfo, this.cR.targetInfo, propMap);
        this.config.setCrossoverProb(this.mutCross);
        this.config.setMutationProb(this.mutCross);
        this.config.setReproductionProb(this.reprod);
        this.config.setPopulationSize(pop);
        ExpressionProblem gpP = new ExpressionProblem(this.config);
        this.fF = ExpressionFitnessFunction.getInstance(this.config, (Mapping)params.get("referencemapping"), "f-score", 0);
        this.fF.useFullCaches(true);
        this.config.setFitnessFunction(this.fF);
        GPGenotype gp = gpP.create();
        for (int i = 0; i < gens; ++i) {
            gp.evolve();
            this.processGen(i, gp);
        }
        this.finishRun((String)params.get("evalfolder"), (String)params.get("evalfilename"));
        this.destroy();
    }

    private void finishRun(String folder, String fileName) {
        for (EvaluationPseudoMemory mem : this.memList) {
            mem = this.evaluateInstance(mem);
        }
        Collections.sort(this.memList);
        this.writeFile(folder, fileName);
    }

    private EvaluationPseudoMemory evaluateInstance(EvaluationPseudoMemory mem) {
        PRFComputer prf = new PRFComputer();
        Mapping map = this.fF.getMapping(mem.metric.getExpression(), mem.metric.getThreshold(), true);
        mem.precision = prf.computePrecision(map, this.reference);
        mem.recall = prf.computeRecall(map, this.reference);
        mem.fmeasue = prf.computeFScore(map, this.reference);
        return mem;
    }

    private void processGen(int nr, GPGenotype gp) {
        GPProgram fittest = (GPProgram)this.determinFittest(gp);
        double avgFitness = 0.0;
        avgFitness = gp.getTotalFitness();
        gp.outputSolution(gp.getAllTimeBest());
        this.logger.info((Object)("Processing generation " + nr + " avergeFitness " + avgFitness / (double)pop));
        if (fittest != null && this.getMetric(fittest) != null) {
            this.logger.info((Object)("best fitness:" + fittest.calcFitnessValue() + " " + this.getMetric(fittest)));
            EvaluationPseudoMemory mem = new EvaluationPseudoMemory(1, nr, this.getMetric(fittest), fittest.calcFitnessValue(), this.clock.durationSinceClick());
            this.memList.add(mem);
        } else {
            this.logger.info((Object)"Got no valid fittest program.");
        }
    }

    private void writeFile(String folder, String fileName) {
        EvalFileLogger fileLogger = EvalFileLogger.getInstance();
        fileLogger.createFile(folder, fileName, true);
        fileLogger.writeHead();
        for (EvaluationPseudoMemory mem : this.memList) {
            this.writeInstance(fileLogger, mem);
        }
    }

    private void writeInstance(EvalFileLogger fileLogger, EvaluationPseudoMemory best) {
        fileLogger.writeWithDuration(best.generation, 0.0, best.metric.toString(), best.fitness, best.fmeasue, best.recall, best.precision, best.runTime);
    }

    private Metric getMetric(GPProgram prog) {
        ProgramChromosome pc = prog.getChromosome(0);
        Object[] args = new Object[]{};
        try {
            Metric metric = (Metric)pc.getNode(0).execute_object(pc, 0, args);
            return metric;
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    private IGPProgram determinFittest(GPGenotype gp) {
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        IGPProgram[] bests = new IGPProgram[]{gp.getFittestProgramComputed(), pop.determineFittestProgram(), gp.getAllTimeBest(), pop.getGPProgram(0), pop.getGPProgram(pop.getPopSize() - 1)};
        IGPProgram bestHere = null;
        double fittest = Double.MAX_VALUE;
        for (IGPProgram p : bests) {
            double fitM;
            if (p == null || !((fitM = this.fF.calculateRawFitness(p)) < fittest)) continue;
            fittest = fitM;
            bestHere = p;
        }
        if (fittest < this.bestEverFitness) {
            this.bestEverFitness = fittest;
            gp.getGPPopulation().addFittestProgram(this.bestEver);
            return bestHere;
        }
        return this.bestEver;
    }

    private void destroy() {
        this.sC = null;
        this.tC = null;
        this.fF.destroy();
        Configuration.reset();
        this.config = null;
        this.memList.clear();
        this.fF = null;
    }
}

