/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.genetics.evaluation;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.data.Triple;
import de.uni_leipzig.simba.genetics.core.ALDecider;
import de.uni_leipzig.simba.genetics.core.ALFitnessFunction;
import de.uni_leipzig.simba.genetics.core.ExpressionProblem;
import de.uni_leipzig.simba.genetics.core.LinkSpecGeneticLearnerConfig;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.evaluation.EvalFileLoggerComplete;
import de.uni_leipzig.simba.genetics.evaluation.EvalLogMem;
import de.uni_leipzig.simba.genetics.evaluation.EvalLogMemAL;
import de.uni_leipzig.simba.genetics.evaluation.ExampleOracleTrimmer;
import de.uni_leipzig.simba.genetics.evaluation.TestActualMapping;
import de.uni_leipzig.simba.genetics.util.PropMapper;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import de.uni_leipzig.simba.util.Clock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jgap.Configuration;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.gp.impl.GPProgram;
import org.jgap.gp.impl.ProgramChromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ALMainComplete {
    Clock clock;
    public int cycle;
    public boolean useFullCaches = false;
    public HashSet<Integer> added = new HashSet();
    public float mutation = 0.6f;
    public float crossover = 0.6f;
    public float mutationCrossRate = 0.6f;
    public float reproduction = 0.7f;
    public float limit;
    List<EvalLogMem> logMem = new LinkedList<EvalLogMem>();
    List<EvalLogMem> bestEachTest = new LinkedList<EvalLogMem>();
    List<EvalLogMemAL> memory = new LinkedList<EvalLogMemAL>();
    ConfigReader cR;
    List<EvalLogMem> besteachGen = new LinkedList<EvalLogMem>();
    String configFile = "Examples/GeneticEval/";
    String verificationFile = "Examples/GeneticEval/";
    Oracle o;
    static Logger logger = Logger.getLogger((String)"LIMES");
    static Set<IGPProgram> bestSolutions = new LinkedHashSet<IGPProgram>();
    public ALFitnessFunction fitness;

    public static void main(String[] args) throws InvalidConfigurationException {
        block13: {
            float limit;
            int generations;
            int popSize;
            int numberOfExamples;
            int dataset;
            block15: {
                block14: {
                    block12: {
                        dataset = 0;
                        numberOfExamples = 10;
                        popSize = 50;
                        generations = 50;
                        limit = 5.0f;
                        if (args.length != 0) break block12;
                        for (dataset = 2; dataset >= 0; --dataset) {
                            for (popSize = 20; popSize <= 100; popSize += 80) {
                                try {
                                    generations = 50;
                                    for (int cycle = 0; cycle < 5; ++cycle) {
                                        ALMainComplete aLMain = new ALMainComplete();
                                        aLMain.run(dataset, popSize, generations, numberOfExamples, cycle);
                                    }
                                    continue;
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                        break block13;
                    }
                    if (args.length != 1) break block14;
                    generations = Integer.parseInt(args[0]);
                    for (dataset = 0; dataset < 3; ++dataset) {
                        for (popSize = 20; popSize <= 100; popSize += 80) {
                            for (int cycle = 0; cycle < 5; ++cycle) {
                                ALMainComplete aLMain = new ALMainComplete();
                                logger.info((Object)("Perform test " + dataset + " with limit " + limit));
                                aLMain.run(dataset, popSize, generations, numberOfExamples, cycle);
                            }
                        }
                    }
                    break block13;
                }
                if (args.length != 2) break block15;
                dataset = Integer.parseInt(args[0]);
                generations = Integer.parseInt(args[1]);
                for (popSize = 20; popSize <= 100; popSize += 80) {
                    for (int cycle = 0; cycle < 5; ++cycle) {
                        ALMainComplete aLMain = new ALMainComplete();
                        logger.info((Object)("Perform test " + dataset + " with limit " + limit));
                        aLMain.run(dataset, popSize, generations, numberOfExamples, cycle);
                    }
                }
                break block13;
            }
            if (args.length != 3) break block13;
            dataset = Integer.parseInt(args[0]);
            generations = Integer.parseInt(args[1]);
            boolean fullCache = Boolean.parseBoolean(args[2]);
            for (popSize = 20; popSize <= 100; popSize += 80) {
                for (int cycle = 0; cycle < 5; ++cycle) {
                    ALMainComplete aLMain = new ALMainComplete();
                    aLMain.useFullCaches = fullCache;
                    logger.info((Object)("Perform test " + dataset + " with limit " + limit));
                    aLMain.run(dataset, popSize, generations, numberOfExamples, cycle);
                }
            }
        }
    }

    public void run(int examplNr, int popSize, int gens, int numberOfExamples, int cycle) throws InvalidConfigurationException {
        this.cycle = cycle;
        switch (examplNr) {
            case 0: {
                this.configFile = this.configFile + "PublicationData.xml";
                this.verificationFile = this.verificationFile + "Datasets/DBLP-ACM/DBLP-ACM_perfectMapping.csv";
                break;
            }
            case 1: {
                this.configFile = this.configFile + "dailymed-drugbank.xml";
                this.verificationFile = this.verificationFile + "Datasets/dailymed-drugbank-ingredients/reference2.csv";
                break;
            }
            case 2: {
                this.configFile = this.configFile + "dbpedia-linkedmdb.xml";
                this.verificationFile = this.verificationFile + "Datasets/dbpedia-linkedmdb/reference2.csv";
                break;
            }
            default: {
                this.configFile = this.configFile + "PublicationData.xml";
                this.verificationFile = this.verificationFile + "Datasets/DBLP-ACM/DBLP-ACM_perfectMapping.csv";
            }
        }
        int oracleQuestions = 0;
        String full = "";
        if (this.useFullCaches) {
            full = "_full_";
        }
        EvalFileLoggerComplete fileLog = EvalFileLoggerComplete.getInstance();
        String name = this.configFile.substring(0, this.configFile.lastIndexOf(".")) + "_AL_pop=" + popSize + "_gens=" + gens + full + ".csv";
        fileLog.createFile(name);
        this.cR = new ConfigReader();
        this.cR.validateAndRead(this.configFile);
        this.o = OracleFactory.getOracle(this.verificationFile, this.verificationFile.substring(this.verificationFile.lastIndexOf(".") + 1), "simple");
        PropertyMapping propMap = PropMapper.getPropertyMapping(this.cR, this.configFile);
        LinkSpecGeneticLearnerConfig config = new LinkSpecGeneticLearnerConfig(this.cR.sourceInfo, this.cR.targetInfo, propMap);
        config.setCrossoverProb(this.mutationCrossRate);
        config.setMutationProb(this.mutationCrossRate);
        config.setReproductionProb(this.reproduction);
        config.setPopulationSize(popSize);
        config.setPreservFittestIndividual(true);
        this.fitness = new ALFitnessFunction(config, this.o, "f-score", numberOfExamples);
        System.out.println(this.cR.sourceInfo + "\nvs.\n" + config.source);
        System.out.println(this.cR.targetInfo + "\nvs.\n" + config.target);
        System.out.println(propMap);
        Mapping start = ExampleOracleTrimmer.trimExamplesRandomly(this.o.getMapping(), numberOfExamples);
        System.out.println(start);
        logger.info((Object)("Got " + start.size() + " instances for start...:"));
        this.fitness.setReferenceMapping(start);
        System.out.println(start);
        if (this.useFullCaches) {
            this.fitness.useFullCaches(true);
        } else {
            this.fitness.trimKnowledgeBases(start);
        }
        ++oracleQuestions;
        config.setAlwaysCaculateFitness(true);
        config.setSelectFromPrevGen(this.reproduction);
        this.clock = new Clock();
        ExpressionProblem gpP = new ExpressionProblem(config);
        config.setFitnessFunction(this.fitness);
        GPGenotype gp = gpP.create();
        while (oracleQuestions <= 10) {
            ALDecider aLD = new ALDecider();
            logger.info((Object)("running " + gens * oracleQuestions + " generations "));
            for (int i = 0; i < gens * oracleQuestions; ++i) {
                gp.evolve();
                gp.calcFitness();
                if (gp.getFittestProgram() == null) continue;
                this.examineGen(i, gp);
            }
            if (gp.getFittestProgram() != null) {
                logger.info((Object)("now best " + gp.getFittestProgram().getFitnessValue()));
            }
            this.beforeNewInstances(cycle, gens * oracleQuestions, oracleQuestions, gp);
            logger.info((Object)("finished run " + cycle + " with " + gens * oracleQuestions + " gens oracleSize=" + this.fitness.getReferenceMapping().size() + " on " + name));
            List<Mapping> mapsOfPop = this.getMaps(gp.getGPPopulation());
            if (mapsOfPop.size() <= 0) continue;
            List<Triple> toAsk = aLD.getControversyCandidates(mapsOfPop, numberOfExamples);
            logger.info((Object)("Asking about " + toAsk.size() + " instances."));
            if (toAsk.size() == 0) {
                aLD.maxCount += 100;
            }
            Mapping oracleAnswers = new Mapping();
            for (Triple t : toAsk) {
                if (!this.o.ask(t.getSourceUri(), t.getTargetUri())) continue;
                oracleAnswers.add(t.getSourceUri(), t.getTargetUri(), 1.0);
            }
            this.fitness.addToReference(oracleAnswers);
            this.fitness.fillCachesIncrementally(toAsk);
            ++oracleQuestions;
        }
        for (EvalLogMemAL mem : this.memory) {
            this.writeSingleItem(mem, mem.dur, mem.cycle, mem.inquiries);
        }
        this.fitness.destroy();
        Configuration.reset();
        config = null;
        this.fitness = null;
    }

    private void examineGen(int i, GPGenotype gp) {
        GPProgram pBest = (GPProgram)gp.getFittestProgramComputed();
        GPPopulation pop = gp.getGPPopulation();
        pop.sortByFitness();
        double fittest = Double.MAX_VALUE;
        for (GPProgram p : (GPProgram[])pop.getGPPrograms()) {
            double actFit = this.fitness.calculateRawFitness((IGPProgram)p);
            if (!(fittest > actFit) || this.getMetric((IGPProgram)p).getExpression().indexOf("falseProp") != -1) continue;
            pBest = p;
            fittest = actFit;
        }
        EvalLogMem rem = new EvalLogMem(i, (IGPProgram)pBest, pBest.calcFitnessValue(), gp.getTotalFitness());
        this.besteachGen.add(rem);
    }

    private void beforeNewInstances(int cycle, int inquiries, int gens, GPGenotype gp) {
        EvalLogMem best = this.getBestSoFar();
        if (best == null) {
            return;
        }
        GPProgram p = (GPProgram)best.fittestProg;
        EvalLogMemAL mem = new EvalLogMemAL(cycle, inquiries, gens, (IGPProgram)p, p.calcFitnessValue(), gp.getTotalFitness(), this.clock.totalDuration());
        mem.refMapSize = this.fitness.getReferenceMapping().size();
        this.memory.add(mem);
        this.besteachGen.clear();
    }

    public void writeSingleItem(EvalLogMemAL mem, long dur, int cycle, int oracleSize) {
        EvalFileLoggerComplete fileLog = EvalFileLoggerComplete.getInstance();
        String expr = "";
        double d = 0.99;
        try {
            Metric metric = this.getMetric(mem.fittestProg);
            expr = metric.getExpression();
            d = metric.getThreshold();
        }
        catch (IllegalStateException e) {
            return;
        }
        if (expr.indexOf("falseProp") > -1) {
            fileLog.writeComplete(cycle, mem.dur, mem.gen, mem.avgFitness, expr + ">=" + d, mem.fitness, Double.NaN, Double.NaN, Double.NaN, mem.refMapSize);
        } else {
            HashMap<String, Double> res = TestActualMapping.testData(this.cR, this.fitness.getSourceCache(), this.fitness.getTargetCache(), this.o.getMapping(), expr, d);
            fileLog.writeComplete(cycle, mem.dur, mem.gen, mem.avgFitness, expr + ">=" + d, mem.fitness, res.get("f-score"), res.get("recall"), res.get("precision"), mem.refMapSize);
        }
    }

    public List<Mapping> getMaps(GPPopulation pop) {
        LinkedList<Mapping> allMaps = new LinkedList<Mapping>();
        HashSet<String> expressions = new HashSet<String>();
        int maxMaps = 20;
        for (int i = 0; i < Math.min(pop.size(), 20); ++i) {
            IGPProgram gProg = pop.getGPProgram(i);
            String expr = "falseProp";
            double d = 0.9;
            try {
                Metric metric = this.getMetric(gProg);
                expr = metric.getExpression();
                d = metric.getThreshold();
            }
            catch (IllegalStateException e) {
                continue;
            }
            if (expr.indexOf("falseProp") > -1) continue;
            if (expressions.contains(expr + d)) {
                ++maxMaps;
                continue;
            }
            expressions.add(expr + d);
            try {
                allMaps.add(this.fitness.getMapping(expr, d, true));
                continue;
            }
            catch (OutOfMemoryError bounded) {
                logger.info((Object)"Encountered Memory error...");
            }
        }
        return allMaps;
    }

    public EvalLogMem getBestSoFar() {
        double bestFitness = Double.MAX_VALUE;
        EvalLogMem bestProg = null;
        for (EvalLogMem mem : this.besteachGen) {
            IGPProgram prog = mem.fittestProg;
            double actFitness = this.fitness.calculateRawFitness(prog);
            if (!(actFitness < bestFitness) || this.getMetric(prog).getExpression().indexOf("falseProp") != -1) continue;
            bestFitness = actFitness;
            System.out.println("Best Program of Gen" + mem.gen + "=" + this.getMetric(mem.fittestProg) + "\nold fitness=" + mem.fitness + " - new=" + actFitness);
            mem.fittestProg.setFitnessValue(actFitness);
            mem.fitness = actFitness;
            bestProg = mem.clone();
            bestProg.fittestProg.setFitnessValue(actFitness);
            bestProg.fitness = actFitness;
        }
        return bestProg;
    }

    public void outPutBestSoFar() {
        EvalLogMem best = this.getBestSoFar();
        StringBuffer buf = new StringBuffer("Best individual so far has FScore ");
        buf.append(best.FScore);
        buf.append(" considering the current examples given.");
    }

    public Metric getMetric(IGPProgram p) {
        Object[] args = new Object[]{};
        ProgramChromosome pc = p.getChromosome(0);
        return (Metric)pc.getNode(0).execute_object(pc, 0, args);
    }
}

